/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.avro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.commons.codec.binary.Base64;
import org.apache.storm.hdfs.avro.AbstractAvroSerializer;

public class FixedAvroSerializer
extends AbstractAvroSerializer {
    private static final String FP_ALGO = "CRC-64-AVRO";
    final Map<String, Schema> fingerprint2schemaMap = new HashMap<String, Schema>();
    final Map<Schema, String> schema2fingerprintMap = new HashMap<Schema, String>();

    public FixedAvroSerializer() throws IOException, NoSuchAlgorithmException {
        String line;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("FixedAvroSerializer.config");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            Schema schema = new Schema.Parser().parse(line);
            byte[] fp = SchemaNormalization.parsingFingerprint((String)FP_ALGO, (Schema)schema);
            String fingerPrint = new String(Base64.decodeBase64((byte[])fp));
            this.fingerprint2schemaMap.put(fingerPrint, schema);
            this.schema2fingerprintMap.put(schema, fingerPrint);
        }
    }

    @Override
    public String getFingerprint(Schema schema) {
        return this.schema2fingerprintMap.get(schema);
    }

    @Override
    public Schema getSchema(String fingerPrint) {
        return this.fingerprint2schemaMap.get(fingerPrint);
    }
}

