/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.hdfs.blobstore.HdfsBlobStoreImpl;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.thrift.TBase;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBlobStore
extends BlobStore {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsBlobStore.class);
    private static final String DATA_PREFIX = "data_";
    private static final String META_PREFIX = "meta_";
    private static final HashMap<String, Subject> alreadyLoggedInUsers = new HashMap();
    private BlobStoreAclHandler aclHandler;
    private HdfsBlobStoreImpl hbs;
    private Subject localSubject;
    private Map<String, Object> conf;

    private Subject getHadoopUser() {
        Subject subj;
        try {
            subj = (Subject)UserGroupInformation.getCurrentUser().doAs((PrivilegedAction)new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    return Subject.getSubject(AccessController.getContext());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating subject and logging user in!", e);
        }
        return subj;
    }

    private Subject checkAndGetSubject(Subject who) {
        if (who == null) {
            return this.localSubject;
        }
        return who;
    }

    public void prepare(Map conf, String overrideBase, NimbusInfo nimbusInfo) {
        this.conf = conf;
        this.prepareInternal(conf, overrideBase, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareInternal(Map conf, String overrideBase, Configuration hadoopConf) {
        block13: {
            this.conf = conf;
            if (overrideBase == null) {
                overrideBase = (String)conf.get("blobstore.dir");
            }
            if (overrideBase == null) {
                throw new RuntimeException("You must specify a blobstore directory for HDFS to use!");
            }
            LOG.debug("directory is: {}", (Object)overrideBase);
            try {
                String principal = (String)conf.get("blobstore.hdfs.principal");
                String keyTab = (String)conf.get("blobstore.hdfs.keytab");
                if (principal != null && keyTab != null) {
                    String combinedKey = principal + " from " + keyTab;
                    HashMap<String, Subject> hashMap = alreadyLoggedInUsers;
                    synchronized (hashMap) {
                        this.localSubject = alreadyLoggedInUsers.get(combinedKey);
                        if (this.localSubject == null) {
                            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keyTab);
                            this.localSubject = this.getHadoopUser();
                            alreadyLoggedInUsers.put(combinedKey, this.localSubject);
                        }
                        break block13;
                    }
                }
                if (principal == null && keyTab != null) {
                    throw new RuntimeException("You must specify an HDFS principal to go with the keytab!");
                }
                if (principal != null && keyTab == null) {
                    throw new RuntimeException("You must specify HDFS keytab go with the principal!");
                }
                this.localSubject = this.getHadoopUser();
            }
            catch (IOException e) {
                throw new RuntimeException("Error logging in from keytab!", e);
            }
        }
        this.aclHandler = new BlobStoreAclHandler(conf);
        Path baseDir = new Path(overrideBase, "blobs");
        try {
            this.hbs = hadoopConf != null ? new HdfsBlobStoreImpl(baseDir, conf, hadoopConf) : new HdfsBlobStoreImpl(baseDir, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AtomicOutputStream createBlob(String key, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyAlreadyExistsException {
        if (meta.get_replication_factor() <= 0) {
            meta.set_replication_factor(((Integer)this.conf.get("storm.blobstore.replication.factor")).intValue());
        }
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        this.aclHandler.normalizeSettableBlobMeta(key, meta, who, 7);
        BlobStoreAclHandler.validateSettableACLs((String)key, (List)meta.get_acl());
        this.aclHandler.hasPermissions(meta.get_acl(), 7, who, key);
        if (this.hbs.exists(DATA_PREFIX + key)) {
            throw new KeyAlreadyExistsException(key);
        }
        BlobStore.BlobStoreFileOutputStream mOut = null;
        try {
            BlobStoreFile metaFile = this.hbs.write(META_PREFIX + key, true);
            metaFile.setMetadata(meta);
            mOut = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, metaFile);
            mOut.write(Utils.thriftSerialize((TBase)meta));
            mOut.close();
            mOut = null;
            BlobStoreFile dataFile = this.hbs.write(DATA_PREFIX + key, true);
            dataFile.setMetadata(meta);
            BlobStore.BlobStoreFileOutputStream blobStoreFileOutputStream = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, dataFile);
            return blobStoreFileOutputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (mOut != null) {
                try {
                    mOut.cancel();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public AtomicOutputStream updateBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        HdfsBlobStore.validateKey((String)key);
        this.aclHandler.hasPermissions(meta.get_acl(), 2, who, key);
        try {
            BlobStoreFile dataFile = this.hbs.write(DATA_PREFIX + key, false);
            dataFile.setMetadata(meta);
            return new BlobStore.BlobStoreFileOutputStream((BlobStore)this, dataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SettableBlobMeta getStoredBlobMeta(String key) throws KeyNotFoundException {
        InputStream in = null;
        try {
            int len;
            BlobStoreFile pf = this.hbs.read(META_PREFIX + key);
            try {
                in = pf.getInputStream();
            }
            catch (FileNotFoundException fnf) {
                throw new KeyNotFoundException(key);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            in = null;
            SettableBlobMeta settableBlobMeta = (SettableBlobMeta)Utils.thriftDeserialize(SettableBlobMeta.class, (byte[])out.toByteArray());
            return settableBlobMeta;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ReadableBlobMeta getBlobMeta(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this.aclHandler.validateUserCanReadMeta(meta.get_acl(), who, key);
        ReadableBlobMeta rbm = new ReadableBlobMeta();
        rbm.set_settable(meta);
        try {
            BlobStoreFile pf = this.hbs.read(DATA_PREFIX + key);
            rbm.set_version(pf.getModTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rbm;
    }

    public void setBlobMeta(String key, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyNotFoundException {
        if (meta.get_replication_factor() <= 0) {
            meta.set_replication_factor(((Integer)this.conf.get("storm.blobstore.replication.factor")).intValue());
        }
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        this.aclHandler.normalizeSettableBlobMeta(key, meta, who, 4);
        BlobStoreAclHandler.validateSettableACLs((String)key, (List)meta.get_acl());
        SettableBlobMeta orig = this.getStoredBlobMeta(key);
        this.aclHandler.hasPermissions(orig.get_acl(), 4, who, key);
        Object mOut = null;
        this.writeMetadata(key, meta);
    }

    public void deleteBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this.aclHandler.hasPermissions(meta.get_acl(), 2, who, key);
        try {
            this.hbs.deleteKey(DATA_PREFIX + key);
            this.hbs.deleteKey(META_PREFIX + key);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStreamWithMeta getBlob(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this.aclHandler.hasPermissions(meta.get_acl(), 1, who, key);
        try {
            return new BlobStore.BlobStoreFileInputStream((BlobStore)this, this.hbs.read(DATA_PREFIX + key));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<String> listKeys() {
        try {
            return new BlobStore.KeyTranslationIterator(this.hbs.listKeys(), DATA_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
    }

    public int getBlobReplication(String key, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        this.aclHandler.hasAnyPermissions(meta.get_acl(), 7, who, key);
        try {
            return this.hbs.getBlobReplication(DATA_PREFIX + key);
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }

    public int updateBlobReplication(String key, int replication, Subject who) throws AuthorizationException, KeyNotFoundException {
        who = this.checkAndGetSubject(who);
        HdfsBlobStore.validateKey((String)key);
        SettableBlobMeta meta = this.getStoredBlobMeta(key);
        meta.set_replication_factor(replication);
        this.aclHandler.hasAnyPermissions(meta.get_acl(), 6, who, key);
        try {
            this.writeMetadata(key, meta);
            return this.hbs.updateBlobReplication(DATA_PREFIX + key, replication);
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
    }

    public void writeMetadata(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        BlobStore.BlobStoreFileOutputStream mOut = null;
        try {
            BlobStoreFile hdfsFile = this.hbs.write(META_PREFIX + key, false);
            hdfsFile.setMetadata(meta);
            mOut = new BlobStore.BlobStoreFileOutputStream((BlobStore)this, hdfsFile);
            mOut.write(Utils.thriftSerialize((TBase)meta));
            mOut.close();
            mOut = null;
        }
        catch (IOException exp) {
            throw new RuntimeException(exp);
        }
        finally {
            if (mOut != null) {
                try {
                    mOut.cancel();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void fullCleanup(long age) throws IOException {
        this.hbs.fullCleanup(age);
    }
}

