/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.hdfs.blobstore.HdfsBlobStoreImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBlobStoreFile
extends BlobStoreFile {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsBlobStoreFile.class);
    private final String _key;
    private final boolean _isTmp;
    private final Path _path;
    private Long _modTime = null;
    private final boolean _mustBeNew;
    private final Configuration _hadoopConf;
    private final FileSystem _fs;
    private SettableBlobMeta meta;
    public static final FsPermission BLOBSTORE_FILE_PERMISSION = FsPermission.createImmutable((short)420);

    public HdfsBlobStoreFile(Path base, String name, Configuration hconf) {
        if ("data".equals(name)) {
            this._isTmp = false;
        } else {
            Matcher m = TMP_NAME_PATTERN.matcher(name);
            if (!m.matches()) {
                throw new IllegalArgumentException("File name does not match '" + name + "' !~ " + TMP_NAME_PATTERN);
            }
            this._isTmp = true;
        }
        this._hadoopConf = hconf;
        this._key = base.getName();
        this._path = new Path(base, name);
        this._mustBeNew = false;
        try {
            this._fs = this._path.getFileSystem(this._hadoopConf);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting filesystem for path: " + this._path, e);
        }
    }

    public HdfsBlobStoreFile(Path base, boolean isTmp, boolean mustBeNew, Configuration hconf) {
        this._key = base.getName();
        this._hadoopConf = hconf;
        this._isTmp = isTmp;
        this._mustBeNew = mustBeNew;
        this._path = this._isTmp ? new Path(base, System.currentTimeMillis() + ".tmp") : new Path(base, "data");
        try {
            this._fs = this._path.getFileSystem(this._hadoopConf);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting filesystem for path: " + this._path, e);
        }
    }

    public void delete() throws IOException {
        this._fs.delete(this._path, true);
    }

    public boolean isTmp() {
        return this._isTmp;
    }

    public String getKey() {
        return this._key;
    }

    public long getModTime() throws IOException {
        if (this._modTime == null) {
            FileSystem fs = this._path.getFileSystem(this._hadoopConf);
            this._modTime = fs.getFileStatus(this._path).getModificationTime();
        }
        return this._modTime;
    }

    private void checkIsNotTmp() {
        if (!this.isTmp()) {
            throw new IllegalStateException("Can only operate on a temporary blobstore file.");
        }
    }

    private void checkIsTmp() {
        if (this.isTmp()) {
            throw new IllegalStateException("Cannot operate on a temporary blobstore file.");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkIsTmp();
        return this._fs.open(this._path);
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkIsNotTmp();
        FSDataOutputStream out = null;
        FsPermission fileperms = new FsPermission(BLOBSTORE_FILE_PERMISSION);
        try {
            out = this._fs.create(this._path, (short)this.getMetadata().get_replication_factor());
            this._fs.setPermission(this._path, fileperms);
            this._fs.setReplication(this._path, (short)this.getMetadata().get_replication_factor());
        }
        catch (IOException e) {
            FsPermission dirperms = new FsPermission(HdfsBlobStoreImpl.BLOBSTORE_DIR_PERMISSION);
            if (!this._fs.mkdirs(this._path.getParent(), dirperms)) {
                LOG.warn("error creating parent dir: " + this._path.getParent());
            }
            out = this._fs.create(this._path, (short)this.getMetadata().get_replication_factor());
            this._fs.setPermission(this._path, dirperms);
            this._fs.setReplication(this._path, (short)this.getMetadata().get_replication_factor());
        }
        if (out == null) {
            throw new IOException("Error in creating: " + this._path);
        }
        return out;
    }

    public void commit() throws IOException {
        this.checkIsNotTmp();
        FileContext fc = FileContext.getFileContext((Configuration)this._hadoopConf);
        Path dest = new Path(this._path.getParent(), "data");
        if (this._mustBeNew) {
            fc.rename(this._path, dest, new Options.Rename[0]);
        } else {
            fc.rename(this._path, dest, new Options.Rename[]{Options.Rename.OVERWRITE});
        }
    }

    public void cancel() throws IOException {
        this.checkIsNotTmp();
        this.delete();
    }

    public String toString() {
        return this._path + ":" + (this._isTmp ? "tmp" : "data") + ":" + this._key;
    }

    public long getFileLength() throws IOException {
        return this._fs.getFileStatus(this._path).getLen();
    }

    public SettableBlobMeta getMetadata() {
        return this.meta;
    }

    public void setMetadata(SettableBlobMeta meta) {
        this.meta = meta;
    }
}

