/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.TimedRotationPolicy;
import org.apache.storm.hdfs.bolt.sync.SyncPolicy;
import org.apache.storm.hdfs.common.AbstractHDFSWriter;
import org.apache.storm.hdfs.common.NullPartitioner;
import org.apache.storm.hdfs.common.Partitioner;
import org.apache.storm.hdfs.common.rotation.RotationAction;
import org.apache.storm.hdfs.common.security.HdfsSecurityUtil;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHdfsBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHdfsBolt.class);
    private static final Integer DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_TICK_TUPLE_INTERVAL_SECS = 15;
    private static final Integer DEFAULT_MAX_OPEN_FILES = 50;
    protected Map<String, AbstractHDFSWriter> writers;
    protected Map<String, Integer> rotationCounterMap = new HashMap<String, Integer>();
    protected List<RotationAction> rotationActions = new ArrayList<RotationAction>();
    protected OutputCollector collector;
    protected transient FileSystem fs;
    protected SyncPolicy syncPolicy;
    protected FileRotationPolicy rotationPolicy;
    protected FileNameFormat fileNameFormat;
    protected String fsUrl;
    protected String configKey;
    protected transient Object writeLock;
    protected transient Timer rotationTimer;
    private List<Tuple> tupleBatch = new LinkedList<Tuple>();
    protected long offset = 0L;
    protected Integer fileRetryCount = DEFAULT_RETRY_COUNT;
    protected Integer tickTupleInterval = 15;
    protected Integer maxOpenFiles = DEFAULT_MAX_OPEN_FILES;
    protected Partitioner partitioner = new NullPartitioner();
    protected transient Configuration hdfsConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotateOutputFile(AbstractHDFSWriter writer) throws IOException {
        LOG.info("Rotating output file...");
        long start = System.currentTimeMillis();
        Object object = this.writeLock;
        synchronized (object) {
            writer.close();
            LOG.info("Performing {} file rotation actions.", (Object)this.rotationActions.size());
            for (RotationAction action : this.rotationActions) {
                action.execute(this.fs, writer.getFilePath());
            }
        }
        long time = System.currentTimeMillis() - start;
        LOG.info("File rotation took {} ms.", (Object)time);
    }

    public final void prepare(Map conf, TopologyContext topologyContext, OutputCollector collector) {
        this.writeLock = new Object();
        if (this.syncPolicy == null) {
            throw new IllegalStateException("SyncPolicy must be specified.");
        }
        if (this.rotationPolicy == null) {
            throw new IllegalStateException("RotationPolicy must be specified.");
        }
        if (this.fsUrl == null) {
            throw new IllegalStateException("File system URL must be specified.");
        }
        this.writers = new WritersMap((long)this.maxOpenFiles.intValue());
        this.collector = collector;
        this.fileNameFormat.prepare(conf, topologyContext);
        this.hdfsConfig = new Configuration();
        Map map = (Map)conf.get(this.configKey);
        if (map != null) {
            for (String key : map.keySet()) {
                this.hdfsConfig.set(key, String.valueOf(map.get(key)));
            }
        }
        try {
            HdfsSecurityUtil.login(conf, this.hdfsConfig);
            this.doPrepare(conf, topologyContext, collector);
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing HdfsBolt: " + e.getMessage(), e);
        }
        if (this.rotationPolicy instanceof TimedRotationPolicy) {
            this.startTimedRotationPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Tuple tuple) {
        Object object = this.writeLock;
        synchronized (object) {
            boolean forceSync = false;
            AbstractHDFSWriter writer = null;
            String writerKey = null;
            if (TupleUtils.isTick((Tuple)tuple)) {
                LOG.debug("TICK! forcing a file system flush");
                this.collector.ack(tuple);
                forceSync = true;
            } else {
                writerKey = this.getHashKeyForTuple(tuple);
                try {
                    writer = this.getOrCreateWriter(writerKey, tuple);
                    this.offset = writer.write(tuple);
                    this.tupleBatch.add(tuple);
                }
                catch (IOException e) {
                    LOG.info("Tuple failed to write, forcing a flush of existing data.");
                    this.collector.reportError((Throwable)e);
                    forceSync = true;
                    this.collector.fail(tuple);
                }
            }
            if (this.syncPolicy.mark(tuple, this.offset) || forceSync && this.tupleBatch.size() > 0) {
                int attempts = 0;
                boolean success = false;
                IOException lastException = null;
                while (!success && attempts < this.fileRetryCount) {
                    ++attempts;
                    try {
                        this.syncAllWriters();
                        LOG.debug("Data synced to filesystem. Ack'ing [{}] tuples", (Object)this.tupleBatch.size());
                        for (Tuple t : this.tupleBatch) {
                            this.collector.ack(t);
                        }
                        this.tupleBatch.clear();
                        this.syncPolicy.reset();
                        success = true;
                    }
                    catch (IOException e) {
                        LOG.warn("Data could not be synced to filesystem on attempt [{}]", (Object)attempts);
                        this.collector.reportError((Throwable)e);
                        lastException = e;
                    }
                }
                if (!success) {
                    LOG.warn("Data could not be synced to filesystem, failing this batch of tuples");
                    for (Tuple t : this.tupleBatch) {
                        this.collector.fail(t);
                    }
                    this.tupleBatch.clear();
                    throw new RuntimeException("Sync failed [" + attempts + "] times.", lastException);
                }
            }
            if (writer != null && writer.needsRotation()) {
                this.doRotationAndRemoveWriter(writerKey, writer);
            }
        }
    }

    private AbstractHDFSWriter getOrCreateWriter(String writerKey, Tuple tuple) throws IOException {
        AbstractHDFSWriter writer = this.writers.get(writerKey);
        if (writer == null) {
            Path pathForNextFile = this.getBasePathForNextFile(tuple);
            writer = this.makeNewWriter(pathForNextFile, tuple);
            this.writers.put(writerKey, writer);
        }
        return writer;
    }

    private String getHashKeyForTuple(Tuple tuple) {
        String boltKey = this.getWriterKey(tuple);
        String partitionDir = this.partitioner.getPartitionPath(tuple);
        return boltKey + "****" + partitionDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRotationAndRemoveWriter(String writerKey, AbstractHDFSWriter writer) {
        try {
            this.rotateOutputFile(writer);
        }
        catch (IOException e) {
            this.collector.reportError((Throwable)e);
            LOG.error("File could not be rotated");
        }
        finally {
            this.writers.remove(writerKey);
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        return TupleUtils.putTickFrequencyIntoComponentConfig((Map)super.getComponentConfiguration(), (int)this.tickTupleInterval);
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    public void cleanup() {
        this.rotationTimer.cancel();
    }

    private void syncAllWriters() throws IOException {
        for (AbstractHDFSWriter writer : this.writers.values()) {
            writer.sync();
        }
    }

    private void startTimedRotationPolicy() {
        long interval = ((TimedRotationPolicy)this.rotationPolicy).getInterval();
        this.rotationTimer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                for (AbstractHDFSWriter writer : AbstractHdfsBolt.this.writers.values()) {
                    try {
                        AbstractHdfsBolt.this.rotateOutputFile(writer);
                    }
                    catch (IOException e) {
                        LOG.warn("IOException during scheduled file rotation.", (Throwable)e);
                    }
                }
                AbstractHdfsBolt.this.writers.clear();
            }
        };
        this.rotationTimer.scheduleAtFixedRate(task, interval, interval);
    }

    protected Path getBasePathForNextFile(Tuple tuple) {
        String partitionPath = this.partitioner.getPartitionPath(tuple);
        int rotation = this.rotationCounterMap.containsKey(partitionPath) ? this.rotationCounterMap.get(partitionPath) + 1 : 0;
        this.rotationCounterMap.put(partitionPath, rotation);
        return new Path(this.fsUrl + this.fileNameFormat.getPath() + partitionPath, this.fileNameFormat.getName(rotation, System.currentTimeMillis()));
    }

    protected abstract void doPrepare(Map var1, TopologyContext var2, OutputCollector var3) throws IOException;

    protected abstract String getWriterKey(Tuple var1);

    protected abstract AbstractHDFSWriter makeNewWriter(Path var1, Tuple var2) throws IOException;

    static class WritersMap
    extends LinkedHashMap<String, AbstractHDFSWriter> {
        final long maxWriters;

        public WritersMap(long maxWriters) {
            super((int)maxWriters, 0.75f, true);
            this.maxWriters = maxWriters;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AbstractHDFSWriter> eldest) {
            return (long)this.size() > this.maxWriters;
        }
    }
}

