/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt.format;

import java.util.Map;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.task.TopologyContext;

public class DefaultFileNameFormat
implements FileNameFormat {
    private String componentId;
    private int taskId;
    private String path = "/storm";
    private String prefix = "";
    private String extension = ".txt";

    public DefaultFileNameFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public DefaultFileNameFormat withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public DefaultFileNameFormat withPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public void prepare(Map conf, TopologyContext topologyContext) {
        this.componentId = topologyContext.getThisComponentId();
        this.taskId = topologyContext.getThisTaskId();
    }

    @Override
    public String getName(long rotation, long timeStamp) {
        return this.prefix + this.componentId + "-" + this.taskId + "-" + rotation + "-" + timeStamp + this.extension;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

