/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt.format;

import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.storm.hdfs.bolt.format.SequenceFormat;
import org.apache.storm.tuple.Tuple;

public class DefaultSequenceFormat
implements SequenceFormat {
    private transient LongWritable key;
    private transient Text value;
    private String keyField;
    private String valueField;

    public DefaultSequenceFormat(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    @Override
    public Class keyClass() {
        return LongWritable.class;
    }

    @Override
    public Class valueClass() {
        return Text.class;
    }

    public Writable key(Tuple tuple) {
        if (this.key == null) {
            this.key = new LongWritable();
        }
        this.key.set(tuple.getLongByField(this.keyField).longValue());
        return this.key;
    }

    public Writable value(Tuple tuple) {
        if (this.value == null) {
            this.value = new Text();
        }
        this.value.set(tuple.getStringByField(this.valueField));
        return this.value;
    }
}

