/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt.format;

import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.Utils;

public class SimpleFileNameFormat
implements FileNameFormat {
    private static final long serialVersionUID = 1L;
    private String componentId;
    private int taskId;
    private String host;
    private String path = "/storm";
    private String name = "$TIME.$NUM.txt";
    private String timeFormat = "yyyyMMddHHmmss";

    @Override
    public String getName(long rotation, long timeStamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.timeFormat);
        String ret = this.name.replace("$TIME", dateFormat.format(new Date(timeStamp))).replace("$NUM", String.valueOf(rotation)).replace("$HOST", this.host).replace("$COMPONENT", this.componentId).replace("$TASK", String.valueOf(this.taskId));
        return ret;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void prepare(Map conf, TopologyContext topologyContext) {
        this.componentId = topologyContext.getThisComponentId();
        this.taskId = topologyContext.getThisTaskId();
        try {
            this.host = Utils.localHostname();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleFileNameFormat withPath(String path) {
        this.path = path;
        return this;
    }

    public SimpleFileNameFormat withName(String name) {
        this.name = name;
        return this;
    }

    public SimpleFileNameFormat withTimeFormat(String timeFormat) {
        try {
            new SimpleDateFormat(timeFormat);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid timeFormat: " + e.getMessage());
        }
        this.timeFormat = timeFormat;
        return this;
    }
}

