/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.storm.hdfs.spout.AbstractFileReader;
import org.apache.storm.hdfs.spout.FileOffset;
import org.apache.storm.hdfs.spout.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileReader
extends AbstractFileReader {
    public static final String[] defaultFields = new String[]{"line"};
    public static final String CHARSET = "hdfsspout.reader.charset";
    public static final String BUFFER_SIZE = "hdfsspout.reader.buffer.bytes";
    private static final int DEFAULT_BUFF_SIZE = 4096;
    private BufferedReader reader;
    private final Logger LOG = LoggerFactory.getLogger(TextFileReader.class);
    private Offset offset;

    public TextFileReader(FileSystem fs, Path file, Map conf) throws IOException {
        this(fs, file, conf, new Offset(0L, 0L));
    }

    public TextFileReader(FileSystem fs, Path file, Map conf, String startOffset) throws IOException {
        this(fs, file, conf, new Offset(startOffset));
    }

    private TextFileReader(FileSystem fs, Path file, Map conf, Offset startOffset) throws IOException {
        super(fs, file);
        this.offset = startOffset;
        FSDataInputStream in = fs.open(file);
        String charSet = conf == null || !conf.containsKey(CHARSET) ? "UTF-8" : conf.get(CHARSET).toString();
        int buffSz = conf == null || !conf.containsKey(BUFFER_SIZE) ? 4096 : Integer.parseInt(conf.get(BUFFER_SIZE).toString());
        this.reader = new BufferedReader(new InputStreamReader((InputStream)in, charSet), buffSz);
        if (this.offset.charOffset > 0L) {
            this.reader.skip(this.offset.charOffset);
        }
    }

    @Override
    public Offset getFileOffset() {
        return this.offset.clone();
    }

    @Override
    public List<Object> next() throws IOException, ParseException {
        String line = this.readLineAndTrackOffset(this.reader);
        if (line != null) {
            return Collections.singletonList(line);
        }
        return null;
    }

    private String readLineAndTrackOffset(BufferedReader reader) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer(1000);
        long before = this.offset.charOffset;
        while ((ch = reader.read()) != -1) {
            ++this.offset.charOffset;
            if (ch == 10) {
                ++this.offset.lineNumber;
                return sb.toString();
            }
            if (ch == 13) continue;
            sb.append((char)ch);
        }
        if (before == this.offset.charOffset) {
            return null;
        }
        return sb.toString();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.LOG.warn("Ignoring error when closing file " + this.getFilePath(), (Throwable)e);
        }
    }

    public static class Offset
    implements FileOffset {
        long charOffset;
        long lineNumber;

        public Offset(long byteOffset, long lineNumber) {
            this.charOffset = byteOffset;
            this.lineNumber = lineNumber;
        }

        public Offset(String offset) {
            if (offset == null) {
                throw new IllegalArgumentException("offset cannot be null");
            }
            try {
                if (offset.equalsIgnoreCase("0")) {
                    this.charOffset = 0L;
                    this.lineNumber = 0L;
                } else {
                    String[] parts = offset.split(":");
                    this.charOffset = Long.parseLong(parts[0].split("=")[1]);
                    this.lineNumber = Long.parseLong(parts[1].split("=")[1]);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'" + offset + "' cannot be interpreted. It is not in expected format for TextFileReader. Format e.g.  {char=123:line=5}");
            }
        }

        public String toString() {
            return "{char=" + this.charOffset + ":line=" + this.lineNumber + ":}";
        }

        @Override
        public boolean isNextOffset(FileOffset rhs) {
            if (rhs instanceof Offset) {
                Offset other = (Offset)rhs;
                return other.charOffset > this.charOffset && other.lineNumber == this.lineNumber + 1L;
            }
            return false;
        }

        @Override
        public int compareTo(FileOffset o) {
            Offset rhs = (Offset)o;
            if (this.lineNumber < rhs.lineNumber) {
                return -1;
            }
            if (this.lineNumber == rhs.lineNumber) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Offset)) {
                return false;
            }
            Offset that = (Offset)o;
            if (this.charOffset != that.charOffset) {
                return false;
            }
            return this.lineNumber == that.lineNumber;
        }

        public int hashCode() {
            int result = (int)(this.charOffset ^ this.charOffset >>> 32);
            result = 31 * result + (int)(this.lineNumber ^ this.lineNumber >>> 32);
            return result;
        }

        @Override
        public Offset clone() {
            return new Offset(this.charOffset, this.lineNumber);
        }
    }
}

