/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.storm.hdfs.common.rotation.RotationAction;
import org.apache.storm.hdfs.common.security.HdfsSecurityUtil;
import org.apache.storm.hdfs.trident.format.FileNameFormat;
import org.apache.storm.hdfs.trident.format.RecordFormat;
import org.apache.storm.hdfs.trident.format.SequenceFormat;
import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.FileSizeRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.TimedRotationPolicy;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsState
implements State {
    public static final Logger LOG = LoggerFactory.getLogger(HdfsState.class);
    private Options options;
    private volatile TxnRecord lastSeenTxn;
    private Path indexFilePath;

    HdfsState(Options options) {
        this.options = options;
    }

    void prepare(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
        this.options.prepare(conf, partitionIndex, numPartitions);
        this.initLastTxn(conf, partitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxnRecord readTxnRecord(Path path) throws IOException {
        try (FSDataInputStream inputStream = null;){
            inputStream = this.options.fs.open(path);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
            String line = reader.readLine();
            if (line != null) {
                String[] fields = line.split(",");
                TxnRecord txnRecord = new TxnRecord(Long.valueOf(fields[0]), fields[1], Long.valueOf(fields[2]));
                return txnRecord;
            }
        }
        return new TxnRecord(0L, this.options.currentFile.toString(), 0L);
    }

    private Path tmpFilePath(String filename) {
        return new Path(filename + ".tmp");
    }

    private TxnRecord getTxnRecord(Path indexFilePath) throws IOException {
        Path tmpPath = this.tmpFilePath(indexFilePath.toString());
        if (this.options.fs.exists(indexFilePath)) {
            return this.readTxnRecord(indexFilePath);
        }
        if (this.options.fs.exists(tmpPath)) {
            return this.readTxnRecord(tmpPath);
        }
        return new TxnRecord(0L, this.options.currentFile.toString(), 0L);
    }

    private void initLastTxn(Map conf, int partition) {
        String indexFileName = String.format(".index.%s.%d", conf.get("topology.name"), partition);
        this.indexFilePath = new Path(this.options.fileNameFormat.getPath(), indexFileName);
        try {
            this.lastSeenTxn = this.getTxnRecord(this.indexFilePath);
            LOG.debug("initLastTxn updated lastSeenTxn to [{}]", (Object)this.lastSeenTxn);
        }
        catch (IOException e) {
            LOG.warn("initLastTxn failed due to IOException.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void updateIndex(long txId) {
        LOG.debug("Starting index update.");
        Path tmpPath = this.tmpFilePath(this.indexFilePath.toString());
        try (FSDataOutputStream out = this.options.fs.create(tmpPath, true);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out));){
            TxnRecord txnRecord = new TxnRecord(txId, this.options.currentFile.toString(), this.options.getCurrentOffset());
            bw.write(txnRecord.toString());
            bw.newLine();
            bw.flush();
            out.close();
            this.options.fs.delete(this.indexFilePath, false);
            this.options.fs.rename(tmpPath, this.indexFilePath);
            this.lastSeenTxn = txnRecord;
            LOG.debug("updateIndex updated lastSeenTxn to [{}]", (Object)this.lastSeenTxn);
        }
        catch (IOException e) {
            LOG.warn("Begin commit failed due to IOException. Failing batch", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    public void beginCommit(Long txId) {
        if (txId <= this.lastSeenTxn.txnid) {
            LOG.info("txID {} is already processed, lastSeenTxn {}. Triggering recovery.", (Object)txId, (Object)this.lastSeenTxn);
            long start = System.currentTimeMillis();
            this.options.recover(this.lastSeenTxn.dataFilePath, this.lastSeenTxn.offset);
            LOG.info("Recovery took {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        this.updateIndex(txId);
    }

    public void commit(Long txId) {
        try {
            this.options.doCommit(txId);
        }
        catch (IOException e) {
            LOG.warn("Commit failed due to IOException. Failing the batch.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector tridentCollector) {
        try {
            this.options.execute(tuples);
        }
        catch (IOException e) {
            LOG.warn("Failing batch due to IOException.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    void close() throws IOException {
        this.options.closeOutputFile();
    }

    private static class TxnRecord {
        private long txnid;
        private String dataFilePath;
        private long offset;

        private TxnRecord(long txnId, String dataFilePath, long offset) {
            this.txnid = txnId;
            this.dataFilePath = dataFilePath;
            this.offset = offset;
        }

        public String toString() {
            return Long.toString(this.txnid) + "," + this.dataFilePath + "," + Long.toString(this.offset);
        }
    }

    public static class SequenceFileOptions
    extends Options {
        private SequenceFormat format;
        private SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.RECORD;
        private transient SequenceFile.Writer writer;
        private String compressionCodec = "default";
        private transient CompressionCodecFactory codecFactory;

        public SequenceFileOptions withCompressionCodec(String codec) {
            this.compressionCodec = codec;
            return this;
        }

        public SequenceFileOptions withFsUrl(String fsUrl) {
            this.fsUrl = fsUrl;
            return this;
        }

        public SequenceFileOptions withConfigKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public SequenceFileOptions withFileNameFormat(FileNameFormat fileNameFormat) {
            this.fileNameFormat = fileNameFormat;
            return this;
        }

        public SequenceFileOptions withSequenceFormat(SequenceFormat format) {
            this.format = format;
            return this;
        }

        public SequenceFileOptions withRotationPolicy(FileRotationPolicy rotationPolicy) {
            this.rotationPolicy = rotationPolicy;
            return this;
        }

        public SequenceFileOptions withCompressionType(SequenceFile.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        public SequenceFileOptions addRotationAction(RotationAction action) {
            this.rotationActions.add(action);
            return this;
        }

        @Override
        void doPrepare(Map conf, int partitionIndex, int numPartitions) throws IOException {
            LOG.info("Preparing Sequence File State...");
            if (this.format == null) {
                throw new IllegalStateException("SequenceFormat must be specified.");
            }
            this.fs = FileSystem.get((URI)URI.create(this.fsUrl), (Configuration)this.hdfsConfig);
            this.codecFactory = new CompressionCodecFactory(this.hdfsConfig);
        }

        @Override
        public long getCurrentOffset() throws IOException {
            return this.writer.getLength();
        }

        @Override
        public void doCommit(Long txId) throws IOException {
            if (this.rotationPolicy.mark(this.writer.getLength())) {
                this.rotateOutputFile();
                this.rotationPolicy.reset();
            } else {
                this.writer.hsync();
            }
        }

        @Override
        void doRecover(Path srcPath, long nBytes) throws Exception {
            SequenceFile.Reader reader = new SequenceFile.Reader(this.hdfsConfig, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)srcPath), SequenceFile.Reader.length((long)nBytes)});
            Writable key = (Writable)this.format.keyClass().newInstance();
            Writable value = (Writable)this.format.valueClass().newInstance();
            while (reader.next(key, value)) {
                this.writer.append(key, value);
            }
        }

        @Override
        Path createOutputFile() throws IOException {
            Path p = new Path(this.fsUrl + this.fileNameFormat.getPath(), this.fileNameFormat.getName(this.rotation, System.currentTimeMillis()));
            this.writer = SequenceFile.createWriter((Configuration)this.hdfsConfig, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)p), SequenceFile.Writer.keyClass((Class)this.format.keyClass()), SequenceFile.Writer.valueClass((Class)this.format.valueClass()), SequenceFile.Writer.compression((SequenceFile.CompressionType)this.compressionType, (CompressionCodec)this.codecFactory.getCodecByName(this.compressionCodec))});
            return p;
        }

        @Override
        void closeOutputFile() throws IOException {
            this.writer.close();
        }

        @Override
        public void execute(List<TridentTuple> tuples) throws IOException {
            for (TridentTuple tuple : tuples) {
                this.writer.append(this.format.key(tuple), this.format.value(tuple));
            }
        }
    }

    public static class HdfsFileOptions
    extends Options {
        private transient FSDataOutputStream out;
        protected RecordFormat format;
        private long offset = 0L;
        private int bufferSize = 131072;

        public HdfsFileOptions withFsUrl(String fsUrl) {
            this.fsUrl = fsUrl;
            return this;
        }

        public HdfsFileOptions withConfigKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public HdfsFileOptions withFileNameFormat(FileNameFormat fileNameFormat) {
            this.fileNameFormat = fileNameFormat;
            return this;
        }

        public HdfsFileOptions withRecordFormat(RecordFormat format) {
            this.format = format;
            return this;
        }

        public HdfsFileOptions withRotationPolicy(FileRotationPolicy rotationPolicy) {
            this.rotationPolicy = rotationPolicy;
            return this;
        }

        public HdfsFileOptions withBufferSize(int sizeInBytes) {
            this.bufferSize = Math.max(4096, sizeInBytes);
            return this;
        }

        @Deprecated
        public HdfsFileOptions addRotationAction(RotationAction action) {
            this.rotationActions.add(action);
            return this;
        }

        @Override
        void doPrepare(Map conf, int partitionIndex, int numPartitions) throws IOException {
            LOG.info("Preparing HDFS File state...");
            this.fs = FileSystem.get((URI)URI.create(this.fsUrl), (Configuration)this.hdfsConfig);
        }

        @Override
        public long getCurrentOffset() {
            return this.offset;
        }

        @Override
        public void doCommit(Long txId) throws IOException {
            if (this.rotationPolicy.mark(this.offset)) {
                this.rotateOutputFile();
                this.offset = 0L;
                this.rotationPolicy.reset();
            } else if (this.out instanceof HdfsDataOutputStream) {
                ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            } else {
                this.out.hsync();
            }
        }

        @Override
        void doRecover(Path srcPath, long nBytes) throws IOException {
            this.offset = 0L;
            FSDataInputStream is = this.fs.open(srcPath);
            this.copyBytes(is, this.out, nBytes);
            this.offset = nBytes;
        }

        private void copyBytes(FSDataInputStream is, FSDataOutputStream out, long bytesToCopy) throws IOException {
            int n;
            byte[] buf = new byte[this.bufferSize];
            while ((n = is.read(buf)) != -1 && bytesToCopy > 0L) {
                out.write(buf, 0, (int)Math.min((long)n, bytesToCopy));
                bytesToCopy -= (long)n;
            }
        }

        @Override
        void closeOutputFile() throws IOException {
            this.out.close();
        }

        @Override
        Path createOutputFile() throws IOException {
            Path path = new Path(this.fileNameFormat.getPath(), this.fileNameFormat.getName(this.rotation, System.currentTimeMillis()));
            this.out = this.fs.create(path);
            return path;
        }

        @Override
        public void execute(List<TridentTuple> tuples) throws IOException {
            for (TridentTuple tuple : tuples) {
                byte[] bytes = this.format.format(tuple);
                this.out.write(bytes);
                this.offset += (long)bytes.length;
            }
        }
    }

    public static abstract class Options
    implements Serializable {
        protected String fsUrl;
        protected String configKey;
        protected transient FileSystem fs;
        private Path currentFile;
        protected FileRotationPolicy rotationPolicy;
        protected FileNameFormat fileNameFormat;
        protected int rotation = 0;
        protected transient Configuration hdfsConfig;
        protected ArrayList<RotationAction> rotationActions = new ArrayList();

        abstract void closeOutputFile() throws IOException;

        abstract Path createOutputFile() throws IOException;

        abstract void execute(List<TridentTuple> var1) throws IOException;

        abstract void doPrepare(Map var1, int var2, int var3) throws IOException;

        abstract long getCurrentOffset() throws IOException;

        abstract void doCommit(Long var1) throws IOException;

        abstract void doRecover(Path var1, long var2) throws Exception;

        protected void rotateOutputFile(boolean doRotateAction) throws IOException {
            LOG.info("Rotating output file...");
            long start = System.currentTimeMillis();
            this.closeOutputFile();
            ++this.rotation;
            Path newFile = this.createOutputFile();
            if (doRotateAction) {
                LOG.info("Performing {} file rotation actions.", (Object)this.rotationActions.size());
                for (RotationAction action : this.rotationActions) {
                    action.execute(this.fs, this.currentFile);
                }
            }
            this.currentFile = newFile;
            long time = System.currentTimeMillis() - start;
            LOG.info("File rotation took {} ms.", (Object)time);
        }

        protected void rotateOutputFile() throws IOException {
            this.rotateOutputFile(true);
        }

        void prepare(Map conf, int partitionIndex, int numPartitions) {
            if (this.rotationPolicy == null) {
                throw new IllegalStateException("RotationPolicy must be specified.");
            }
            if (this.rotationPolicy instanceof FileSizeRotationPolicy) {
                long rotationBytes = ((FileSizeRotationPolicy)this.rotationPolicy).getMaxBytes();
                LOG.warn("FileSizeRotationPolicy specified with {} bytes.", (Object)rotationBytes);
                LOG.warn("Recovery will fail if data files cannot be copied within topology.message.timeout.secs.");
                LOG.warn("Ensure that the data files does not grow too big with the FileSizeRotationPolicy.");
            } else if (this.rotationPolicy instanceof TimedRotationPolicy) {
                LOG.warn("TimedRotationPolicy specified with interval {} ms.", (Object)((TimedRotationPolicy)this.rotationPolicy).getInterval());
                LOG.warn("Recovery will fail if data files cannot be copied within topology.message.timeout.secs.");
                LOG.warn("Ensure that the data files does not grow too big with the TimedRotationPolicy.");
            }
            if (this.fsUrl == null) {
                throw new IllegalStateException("File system URL must be specified.");
            }
            this.fileNameFormat.prepare(conf, partitionIndex, numPartitions);
            this.hdfsConfig = new Configuration();
            Map map = (Map)conf.get(this.configKey);
            if (map != null) {
                for (String key : map.keySet()) {
                    this.hdfsConfig.set(key, String.valueOf(map.get(key)));
                }
            }
            try {
                HdfsSecurityUtil.login(conf, this.hdfsConfig);
                this.doPrepare(conf, partitionIndex, numPartitions);
                this.currentFile = this.createOutputFile();
            }
            catch (Exception e) {
                throw new RuntimeException("Error preparing HdfsState: " + e.getMessage(), e);
            }
            this.rotationPolicy.start();
        }

        private void recover(String srcFile, long nBytes) {
            try {
                Path srcPath = new Path(srcFile);
                this.rotateOutputFile(false);
                this.rotationPolicy.reset();
                if (nBytes > 0L) {
                    this.doRecover(srcPath, nBytes);
                    LOG.info("Recovered {} bytes from {} to {}", new Object[]{nBytes, srcFile, this.currentFile});
                } else {
                    LOG.info("Nothing to recover from {}", (Object)srcFile);
                }
                this.fs.delete(srcPath, false);
                LOG.info("Deleted file {} that had partial commits.", (Object)srcFile);
            }
            catch (Exception e) {
                LOG.warn("Recovery failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

