/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.evaluator.AbstractAttributeEvaluator;
import org.apache.tiles.servlet.context.ServletUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18NAttributeEvaluator
extends AbstractAttributeEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(I18NAttributeEvaluator.class);

    public Object evaluate(String expression, TilesRequestContext request) {
        String result = expression;
        HttpServletRequest httpRequest = ServletUtil.getServletRequest((TilesRequestContext)request).getRequest();
        ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
        if (ctx == null) {
            LOG.error("Cannot obtain HttpServletRequest from [{}]", new String[]{request.getClass().getName()});
            throw new ConfigurationException("There is no ActionContext for current request!");
        }
        TextProviderFactory tpf = new TextProviderFactory();
        ctx.getContainer().inject((Object)tpf);
        LocaleProvider localeProvider = (LocaleProvider)ctx.getContainer().getInstance(LocaleProvider.class);
        TextProvider textProvider = tpf.createInstance(ctx.getActionInvocation().getAction().getClass(), localeProvider);
        if (textProvider != null) {
            LOG.debug("Trying find text [{}] using TextProvider {}", new Object[]{expression, textProvider});
            result = textProvider.getText(expression);
        }
        return result;
    }

    public void init(Map<String, String> initParameters) {
    }
}

