/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class DirectFileReadDataSource
implements DataSource {
    private static final int TRANSFER_SIZE = 8192;
    private RandomAccessFile raf;

    public DirectFileReadDataSource(File f) throws IOException {
        this.raf = new RandomAccessFile(f, "r");
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int bytesToRead;
        int totalRead;
        int len = byteBuffer.remaining();
        int bytesRead = 0;
        byte[] buf = new byte[8192];
        for (totalRead = 0; totalRead < len && (bytesRead = this.raf.read(buf, 0, bytesToRead = Math.min(len - totalRead, 8192))) >= 0; totalRead += bytesRead) {
            byteBuffer.put(buf, 0, bytesRead);
        }
        return bytesRead < 0 && totalRead == 0 ? -1 : totalRead;
    }

    public int readAllInOnce(ByteBuffer byteBuffer) throws IOException {
        byte[] buf = new byte[byteBuffer.remaining()];
        int read = this.raf.read(buf);
        byteBuffer.put(buf, 0, read);
        return read;
    }

    public long size() throws IOException {
        return this.raf.length();
    }

    public long position() throws IOException {
        return this.raf.getFilePointer();
    }

    public void position(long nuPos) throws IOException {
        this.raf.seek(nuPos);
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return target.write(this.map(position, count));
    }

    public ByteBuffer map(long startPosition, long size) throws IOException {
        this.raf.seek(startPosition);
        byte[] payload = new byte[CastUtils.l2i((long)size)];
        this.raf.readFully(payload);
        return ByteBuffer.wrap(payload);
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

