/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.tika.parser.strings.StringsEncoding;

public class StringsConfig
implements Serializable {
    private static final long serialVersionUID = -1465227101645003594L;
    private String stringsPath = "";
    private int minLength = 4;
    private StringsEncoding encoding = StringsEncoding.SINGLE_7_BIT;
    private int timeout = 120;

    public StringsConfig() {
        this.init(this.getClass().getResourceAsStream("Strings.properties"));
    }

    public StringsConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        this.setStringsPath(props.getProperty("stringsPath", "" + this.getStringsPath()));
        this.setMinLength(Integer.parseInt(props.getProperty("minLength", "" + this.getMinLength())));
        this.setEncoding(StringsEncoding.valueOf(props.getProperty("encoding", "" + this.getEncoding().get())));
        this.setTimeout(Integer.parseInt(props.getProperty("timeout", "" + this.getTimeout())));
    }

    public String getStringsPath() {
        return this.stringsPath;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public StringsEncoding getEncoding() {
        return this.encoding;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setStringsPath(String path) {
        if (!path.isEmpty() && !path.endsWith(File.separator)) {
            path = path + File.separatorChar;
        }
        this.stringsPath = path;
    }

    public void setMinLength(int minLength) {
        if (minLength < 1) {
            throw new IllegalArgumentException("Invalid minimum length");
        }
        this.minLength = minLength;
    }

    public void setEncoding(StringsEncoding encoding) {
        this.encoding = encoding;
    }

    public void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        this.timeout = timeout;
    }
}

