/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TransformSerializer;

public class GraphBinaryWriter {
    private final TypeSerializerRegistry registry;
    private static final byte VALUE_FLAG_NULL = 1;
    private static final byte VALUE_FLAG_NONE = 0;
    public static final byte VERSION_BYTE = -127;
    private static final byte[] unspecifiedNullBytes = new byte[]{DataType.UNSPECIFIED_NULL.getCodeByte(), 1};
    private static final byte[] customTypeCodeBytes = new byte[]{DataType.CUSTOM.getCodeByte()};

    public GraphBinaryWriter() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryWriter(TypeSerializerRegistry registry) {
        this.registry = registry;
    }

    public <T> void writeValue(T value, ByteBuf buffer, boolean nullable) throws SerializationException {
        if (value == null) {
            if (!nullable) {
                throw new SerializationException("Unexpected null value when nullable is false");
            }
            this.writeValueFlagNull(buffer);
            return;
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        serializer.writeValue(value, buffer, this, nullable);
    }

    public <T> void write(T value, ByteBuf buffer) throws SerializationException {
        if (value == null) {
            buffer.writeBytes(unspecifiedNullBytes);
            return;
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        if (serializer instanceof CustomTypeSerializer) {
            CustomTypeSerializer customTypeSerializer = (CustomTypeSerializer)serializer;
            buffer.writeBytes(Unpooled.wrappedBuffer((byte[])customTypeCodeBytes));
            this.writeValue(customTypeSerializer.getTypeName(), buffer, false);
            customTypeSerializer.write(value, buffer, this);
            return;
        }
        if (serializer instanceof TransformSerializer) {
            TransformSerializer transformSerializer = (TransformSerializer)serializer;
            this.write(transformSerializer.transform(value), buffer);
            return;
        }
        buffer.writeBytes(serializer.getDataType().getDataTypeBuffer());
        serializer.write(value, buffer, this);
    }

    public <T> void writeFullyQualifiedNull(Class<T> objectClass, ByteBuf buffer, Object information) throws SerializationException {
        TypeSerializer<Object> serializer = this.registry.getSerializer(objectClass);
        serializer.write(null, buffer, this);
    }

    public void writeValueFlagNull(ByteBuf buffer) {
        buffer.writeByte(1);
    }

    public void writeValueFlagNone(ByteBuf buffer) {
        buffer.writeByte(0);
    }
}

