/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.BigDecimalSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.BigIntegerSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.BindingSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.BulkSetSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ByteBufferSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ByteCodeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CharSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ClassSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.DateSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.DurationSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.EdgeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.EnumSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.GraphSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.InetAddressSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.InstantSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.LambdaSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ListSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.LocalDateSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.LocalDateTimeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.LocalTimeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.MapEntrySerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.MapSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.MetricsSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.MonthDaySerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.OffsetDateTimeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.OffsetTimeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.PSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.PathSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.PeriodSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.PropertySerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SetSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SingleTypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.StringSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TransformSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TraversalExplanationSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TraversalMetricsSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TraversalStrategySerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TraverserSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TreeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.UUIDSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.VertexPropertySerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.VertexSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.YearMonthSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ZoneOffsetSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.ZonedDateTimeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public class TypeSerializerRegistry {
    private static final RegistryEntry[] defaultEntries = new RegistryEntry[]{new RegistryEntry(Integer.class, SingleTypeSerializer.IntSerializer), new RegistryEntry(Long.class, SingleTypeSerializer.LongSerializer), new RegistryEntry(String.class, new StringSerializer()), new RegistryEntry(Date.class, DateSerializer.DateSerializer), new RegistryEntry(Timestamp.class, DateSerializer.TimestampSerializer), new RegistryEntry(Class.class, new ClassSerializer()), new RegistryEntry(Double.class, SingleTypeSerializer.DoubleSerializer), new RegistryEntry(Float.class, SingleTypeSerializer.FloatSerializer), new RegistryEntry(List.class, new ListSerializer()), new RegistryEntry(Map.class, new MapSerializer()), new RegistryEntry(Set.class, new SetSerializer()), new RegistryEntry(UUID.class, new UUIDSerializer()), new RegistryEntry(Edge.class, new EdgeSerializer()), new RegistryEntry(Path.class, new PathSerializer()), new RegistryEntry(VertexProperty.class, new VertexPropertySerializer()), new RegistryEntry(Property.class, new PropertySerializer()), new RegistryEntry(Graph.class, new GraphSerializer()), new RegistryEntry(Vertex.class, new VertexSerializer()), new RegistryEntry(SackFunctions.Barrier.class, EnumSerializer.BarrierSerializer), new RegistryEntry(Bytecode.Binding.class, new BindingSerializer()), new RegistryEntry(Bytecode.class, new ByteCodeSerializer()), new RegistryEntry(VertexProperty.Cardinality.class, EnumSerializer.CardinalitySerializer), new RegistryEntry(Column.class, EnumSerializer.ColumnSerializer), new RegistryEntry(Direction.class, EnumSerializer.DirectionSerializer), new RegistryEntry(Operator.class, EnumSerializer.OperatorSerializer), new RegistryEntry(Order.class, EnumSerializer.OrderSerializer), new RegistryEntry(TraversalOptionParent.Pick.class, EnumSerializer.PickSerializer), new RegistryEntry(Pop.class, EnumSerializer.PopSerializer), new RegistryEntry(Lambda.class, new LambdaSerializer()), new RegistryEntry(P.class, new PSerializer<P>(DataType.P, P.class)), new RegistryEntry(AndP.class, new PSerializer<AndP>(DataType.P, AndP.class)), new RegistryEntry(OrP.class, new PSerializer<OrP>(DataType.P, OrP.class)), new RegistryEntry(TextP.class, new PSerializer<TextP>(DataType.TEXTP, TextP.class)), new RegistryEntry(Scope.class, EnumSerializer.ScopeSerializer), new RegistryEntry(T.class, EnumSerializer.TSerializer), new RegistryEntry(Traverser.class, new TraverserSerializer()), new RegistryEntry(BigDecimal.class, new BigDecimalSerializer()), new RegistryEntry(BigInteger.class, new BigIntegerSerializer()), new RegistryEntry(Byte.class, SingleTypeSerializer.ByteSerializer), new RegistryEntry(ByteBuffer.class, new ByteBufferSerializer()), new RegistryEntry(Short.class, SingleTypeSerializer.ShortSerializer), new RegistryEntry(Boolean.class, SingleTypeSerializer.BooleanSerializer), new RegistryEntry(TraversalStrategy.class, new TraversalStrategySerializer()), new RegistryEntry(BulkSet.class, new BulkSetSerializer()), new RegistryEntry(Tree.class, new TreeSerializer()), new RegistryEntry(Metrics.class, new MetricsSerializer()), new RegistryEntry(TraversalMetrics.class, new TraversalMetricsSerializer()), new RegistryEntry(Map.Entry.class, new MapEntrySerializer()), new RegistryEntry(TraversalExplanation.class, new TraversalExplanationSerializer()), new RegistryEntry(Character.class, new CharSerializer()), new RegistryEntry(Duration.class, new DurationSerializer()), new RegistryEntry(InetAddress.class, new InetAddressSerializer()), new RegistryEntry(Inet4Address.class, new InetAddressSerializer()), new RegistryEntry(Inet6Address.class, new InetAddressSerializer()), new RegistryEntry(Instant.class, new InstantSerializer()), new RegistryEntry(LocalDate.class, new LocalDateSerializer()), new RegistryEntry(LocalTime.class, new LocalTimeSerializer()), new RegistryEntry(LocalDateTime.class, new LocalDateTimeSerializer()), new RegistryEntry(MonthDay.class, new MonthDaySerializer()), new RegistryEntry(OffsetDateTime.class, new OffsetDateTimeSerializer()), new RegistryEntry(OffsetTime.class, new OffsetTimeSerializer()), new RegistryEntry(Period.class, new PeriodSerializer()), new RegistryEntry(Year.class, SingleTypeSerializer.YearSerializer), new RegistryEntry(YearMonth.class, new YearMonthSerializer()), new RegistryEntry(ZonedDateTime.class, new ZonedDateTimeSerializer()), new RegistryEntry(ZoneOffset.class, new ZoneOffsetSerializer())};
    public static final TypeSerializerRegistry INSTANCE = TypeSerializerRegistry.build().create();
    private final Map<Class<?>, TypeSerializer<?>> serializers = new HashMap();
    private final Map<Class<?>, TypeSerializer<?>> serializersByInterface = new LinkedHashMap();
    private final Map<DataType, TypeSerializer<?>> serializersByDataType = new HashMap();
    private final Map<String, CustomTypeSerializer> serializersByCustomTypeName = new HashMap<String, CustomTypeSerializer>();
    private Function<Class<?>, TypeSerializer<?>> fallbackResolver;
    private final ConcurrentHashMap<Class<?>, TypeSerializer<?>> serializersByImplementation = new ConcurrentHashMap();

    public static Builder build() {
        return new Builder();
    }

    private TypeSerializerRegistry(Collection<RegistryEntry> entries, Function<Class<?>, TypeSerializer<?>> fallbackResolver) {
        HashSet<Class> providedTypes = new HashSet<Class>(entries.size());
        for (RegistryEntry entry : entries) {
            this.put(entry);
            providedTypes.add(entry.type);
        }
        Arrays.stream(defaultEntries).filter(e -> !providedTypes.contains(((RegistryEntry)e).type)).forEach(this::put);
        this.fallbackResolver = fallbackResolver;
    }

    private void put(RegistryEntry entry) {
        Class type = entry.getType();
        TypeSerializer serializer = entry.getTypeSerializer();
        if (type == null) {
            throw new NullPointerException("Type can not be null");
        }
        if (serializer == null) {
            throw new NullPointerException("Serializer instance can not be null");
        }
        if (serializer.getDataType() == null && !(serializer instanceof TransformSerializer)) {
            throw new NullPointerException("Serializer data type can not be null");
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            this.serializers.put(type, serializer);
        } else {
            this.serializersByInterface.put(type, serializer);
        }
        if (serializer.getDataType() == DataType.CUSTOM) {
            this.serializersByCustomTypeName.put(entry.getCustomTypeName(), (CustomTypeSerializer)serializer);
        } else if (serializer.getDataType() != null) {
            this.serializersByDataType.put(serializer.getDataType(), serializer);
        }
    }

    public <DT> TypeSerializer<DT> getSerializer(Class<DT> type) throws SerializationException {
        TypeSerializer<?> serializer = this.serializers.get(type);
        if (null == serializer) {
            serializer = this.serializersByImplementation.get(type);
        }
        if (serializer != null) {
            return serializer;
        }
        if (Enum.class.isAssignableFrom(type)) {
            serializer = this.serializers.get(type.getSuperclass());
        }
        if (null == serializer) {
            for (Map.Entry<Class<?>, TypeSerializer<?>> entry : this.serializersByInterface.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                serializer = entry.getValue();
                break;
            }
        }
        if (null == serializer && this.fallbackResolver != null) {
            serializer = this.fallbackResolver.apply(type);
        }
        TypeSerializerRegistry.validateInstance(serializer, type.getTypeName());
        this.serializersByImplementation.put(type, serializer);
        return serializer;
    }

    public <DT> TypeSerializer<DT> getSerializer(DataType dataType) throws SerializationException {
        if (dataType == DataType.CUSTOM) {
            throw new IllegalArgumentException("Custom type serializers can not be retrieved using this method");
        }
        return TypeSerializerRegistry.validateInstance(this.serializersByDataType.get((Object)dataType), dataType.toString());
    }

    public <DT> CustomTypeSerializer<DT> getSerializerForCustomType(String name) throws SerializationException {
        CustomTypeSerializer serializer = this.serializersByCustomTypeName.get(name);
        if (serializer == null) {
            throw new SerializationException(String.format("Serializer for custom type '%s' not found", name));
        }
        return serializer;
    }

    private static TypeSerializer validateInstance(TypeSerializer serializer, String typeName) throws SerializationException {
        if (serializer == null) {
            throw new SerializationException(String.format("Serializer for type %s not found", typeName));
        }
        return serializer;
    }

    private static class RegistryEntry<DT> {
        private final Class<DT> type;
        private final TypeSerializer<DT> typeSerializer;

        private RegistryEntry(Class<DT> type, TypeSerializer<DT> typeSerializer) {
            this.type = type;
            this.typeSerializer = typeSerializer;
        }

        public Class<DT> getType() {
            return this.type;
        }

        public DataType getDataType() {
            return this.typeSerializer.getDataType();
        }

        public String getCustomTypeName() {
            if (this.getDataType() != DataType.CUSTOM) {
                return null;
            }
            CustomTypeSerializer customTypeSerializer = (CustomTypeSerializer)this.typeSerializer;
            return customTypeSerializer.getTypeName();
        }

        public TypeSerializer<DT> getTypeSerializer() {
            return this.typeSerializer;
        }
    }

    public static class Builder {
        private final List<RegistryEntry> list = new LinkedList<RegistryEntry>();
        private Function<Class<?>, TypeSerializer<?>> fallbackResolver;

        public <DT> Builder add(Class<DT> type, TypeSerializer<DT> serializer) {
            if (serializer.getDataType() == DataType.CUSTOM) {
                throw new IllegalArgumentException("DataType can not be CUSTOM, use addCustomType() method instead");
            }
            if (serializer.getDataType() == DataType.UNSPECIFIED_NULL) {
                throw new IllegalArgumentException("Adding a serializer for a UNSPECIFIED_NULL is not permitted");
            }
            if (serializer instanceof CustomTypeSerializer) {
                throw new IllegalArgumentException("CustomTypeSerializer implementations are reserved for customtypes");
            }
            this.list.add(new RegistryEntry(type, serializer));
            return this;
        }

        public <DT> Builder addCustomType(Class<DT> type, CustomTypeSerializer<DT> serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer can not be null");
            }
            if (serializer.getDataType() != DataType.CUSTOM) {
                throw new IllegalArgumentException("Custom serializer must use CUSTOM data type");
            }
            if (serializer.getTypeName() == null) {
                throw new NullPointerException("serializer custom type name can not be null");
            }
            this.list.add(new RegistryEntry(type, serializer));
            return this;
        }

        public Builder withFallbackResolver(Function<Class<?>, TypeSerializer<?>> fallbackResolver) {
            this.fallbackResolver = fallbackResolver;
            return this;
        }

        public TypeSerializerRegistry create() {
            return new TypeSerializerRegistry(this.list, this.fallbackResolver);
        }
    }
}

