/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;

public class TraversalStrategySerializer
extends SimpleTypeSerializer<TraversalStrategy> {
    public TraversalStrategySerializer() {
        super(DataType.TRAVERSALSTRATEGY);
    }

    @Override
    protected TraversalStrategy readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Class clazz = context.readValue(buffer, Class.class, false);
        Map config = context.readValue(buffer, Map.class, false);
        return new TraversalStrategyProxy(clazz, (Configuration)new MapConfiguration(config));
    }

    @Override
    protected void writeValue(TraversalStrategy value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.getClass(), buffer, false);
        context.writeValue(TraversalStrategySerializer.translateToBytecode(ConfigurationConverter.getMap((Configuration)value.getConfiguration())), buffer, false);
    }

    private static Map<Object, Object> translateToBytecode(Map<Object, Object> conf) {
        LinkedHashMap<Object, Object> newConf = new LinkedHashMap<Object, Object>(conf.size());
        conf.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof Traversal) {
                newConf.put(entry.getKey(), ((Traversal)entry.getValue()).asAdmin().getBytecode());
            } else {
                newConf.put(entry.getKey(), entry.getValue());
            }
        });
        return newConf;
    }
}

