/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;

public class TraversalMetricsSerializer
extends SimpleTypeSerializer<TraversalMetrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public TraversalMetricsSerializer() {
        super(DataType.TRAVERSALMETRICS);
    }

    @Override
    protected TraversalMetrics readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Long durationNanos = context.readValue(buffer, Long.class, false);
        ArrayList metrics = new ArrayList(collectionSerializer.readValue(buffer, context));
        return new DefaultTraversalMetrics(durationNanos.longValue(), metrics);
    }

    @Override
    protected void writeValue(TraversalMetrics value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.getDuration(TimeUnit.NANOSECONDS), buffer, false);
        collectionSerializer.writeValue(value.getMetrics(), buffer, context);
    }
}

