/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.MonthDay;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class MonthDaySerializer
extends SimpleTypeSerializer<MonthDay> {
    public MonthDaySerializer() {
        super(DataType.MONTHDAY);
    }

    @Override
    protected MonthDay readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return MonthDay.of(buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    protected void writeValue(MonthDay value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
    }
}

