/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.plugin.dsl.credential;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.mindrot.jbcrypt.BCrypt;

@Deprecated
public class CredentialGraph {
    private final int BCRYPT_ROUNDS = 4;
    private final Graph graph;
    private final GraphTraversalSource g;
    private final boolean supportsTransactions;

    public CredentialGraph(Graph graph) {
        this.graph = graph;
        this.g = graph.traversal();
        this.supportsTransactions = graph.features().graph().supportsTransactions();
    }

    public Vertex findUser(String username) {
        GraphTraversal t;
        Vertex v;
        if (this.supportsTransactions) {
            this.g.tx().rollback();
        }
        Vertex vertex = v = (t = this.g.V(new Object[0]).has("username", (Object)username)).hasNext() ? (Vertex)t.next() : null;
        if (t.hasNext()) {
            throw new IllegalStateException(String.format("Multiple users with username %s", username));
        }
        return v;
    }

    public Vertex createUser(String username, String password) {
        if (this.findUser(username) != null) {
            throw new IllegalStateException("User with this name already exists");
        }
        if (this.supportsTransactions) {
            this.graph.tx().rollback();
        }
        try {
            Vertex v = this.graph.addVertex(new Object[]{T.label, "user", "username", username, "password", BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)4))});
            if (this.supportsTransactions) {
                this.graph.tx().commit();
            }
            return v;
        }
        catch (Exception ex) {
            if (this.supportsTransactions) {
                this.graph.tx().rollback();
            }
            throw new RuntimeException(ex);
        }
    }

    public long removeUser(String username) {
        if (this.supportsTransactions) {
            this.graph.tx().rollback();
        }
        try {
            long count = (Long)this.g.V(new Object[0]).has("username", (Object)username).sideEffect((Traversal)__.drop()).count().next();
            if (this.supportsTransactions) {
                this.graph.tx().commit();
            }
            return count;
        }
        catch (Exception ex) {
            if (this.supportsTransactions) {
                this.graph.tx().rollback();
            }
            throw new RuntimeException(ex);
        }
    }

    public long countUsers() {
        if (this.supportsTransactions) {
            this.graph.tx().rollback();
        }
        return (Long)this.g.V(new Object[0]).hasLabel("user", new String[0]).count().next();
    }

    public String toString() {
        return "CredentialGraph{graph=" + this.graph + '}';
    }

    public static CredentialGraph credentials(Graph graph) {
        return new CredentialGraph(graph);
    }
}

