/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.server.handler.ServerSerializers;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WsGremlinTextRequestDecoder
extends MessageToMessageDecoder<TextWebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WsGremlinTextRequestDecoder.class);
    private final Map<String, MessageSerializer> serializers;

    public WsGremlinTextRequestDecoder(Map<String, MessageSerializer> serializers) {
        this.serializers = serializers;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, TextWebSocketFrame frame, List<Object> objects) throws Exception {
        try {
            MessageTextSerializer serializer = (MessageTextSerializer)this.select("application/json", ServerSerializers.DEFAULT_SERIALIZER);
            channelHandlerContext.channel().attr(StateKey.SESSION).set(null);
            channelHandlerContext.channel().attr(StateKey.SERIALIZER).set((Object)serializer);
            channelHandlerContext.channel().attr(StateKey.USE_BINARY).set((Object)false);
            objects.add(serializer.deserializeRequest(frame.text()));
        }
        catch (SerializationException se) {
            objects.add(RequestMessage.INVALID);
        }
    }

    private MessageSerializer select(String mimeType, MessageSerializer defaultSerializer) {
        if (logger.isWarnEnabled() && !this.serializers.containsKey(mimeType)) {
            logger.warn("Gremlin Server is not configured with a serializer for the requested mime type [{}] - using {} by default", (Object)mimeType, (Object)defaultSerializer.getClass().getName());
        }
        return this.serializers.getOrDefault(mimeType, defaultSerializer);
    }
}

