/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import junit.framework.TestFailure;
import junit.framework.TestResult;

public class ResultPrinter
extends junit.textui.ResultPrinter {
    public ResultPrinter(PrintStream writer) {
        super(writer);
    }

    public PrintStream writer() {
        return this.getWriter();
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            TestFailure failure;
            this.writer().println("\n~~ Failure Results ~~~~~~~~~\n");
            if (result.failureCount() == 1) {
                this.writer().println("There was " + result.failureCount() + " failure:");
            } else {
                this.writer().println("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            this.writer().println("\nFailure Summary:");
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                failure = (TestFailure)e.nextElement();
                this.writer().println(i + ") " + failure.failedTest());
                ++i;
            }
            i = 1;
            this.writer().println("\nFailure Details:");
            e = result.failures();
            while (e.hasMoreElements()) {
                failure = (TestFailure)e.nextElement();
                this.writer().println("\n" + i + ") " + failure.failedTest());
                Throwable t = failure.thrownException();
                if (t.getMessage() != null) {
                    this.writer().println("\t\"" + t.getMessage() + "\"");
                } else {
                    this.writer().println();
                    failure.thrownException().printStackTrace();
                }
                ++i;
            }
        }
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.writer().println();
            this.writer().print("OK");
            this.writer().println(" (" + result.runCount() + " tests)");
        } else {
            this.writer().println();
            this.writer().println("FAILURES!!!");
            this.writer().println("~~ Test Results ~~~~~~~~~~~~");
            this.writer().println("      Run: " + result.runCount());
            this.writer().println(" Failures: " + result.failureCount());
            this.writer().println("   Errors: " + result.errorCount());
        }
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            TestFailure failure;
            this.writer().println("\n~~ Error Results ~~~~~~~~~~~\n");
            if (result.errorCount() == 1) {
                this.writer().println("There was " + result.errorCount() + " error:");
            } else {
                this.writer().println("There were " + result.errorCount() + " errors:");
            }
            this.writer().println("\nError Summary:");
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                failure = (TestFailure)e.nextElement();
                this.writer().println(i + ") " + failure.failedTest());
                ++i;
            }
            this.writer().println("\nError Details:");
            i = 1;
            e = result.errors();
            while (e.hasMoreElements()) {
                failure = (TestFailure)e.nextElement();
                this.writer().println(i + ") " + failure.failedTest());
                String trace = this.getRelevantStackTrace(failure.thrownException());
                this.writer().println(trace);
                ++i;
            }
        }
    }

    public String getRelevantStackTrace(Throwable t) {
        StringBuffer trace = new StringBuffer();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bos);
            t.printStackTrace(pw);
            pw.close();
            BufferedReader reader = new BufferedReader(new StringReader(bos.toString()));
            String line = reader.readLine();
            while (line != null && line.indexOf("at junit.framework") == -1 && line.indexOf("at org.apache.openejb.test.NumberedTestCase") == -1 && line.indexOf("at org.apache.openejb.test.TestSuite") == -1) {
                trace.append(line).append('\n');
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace.toString();
    }
}

