/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.io.DataInputStream;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.test.TestSecurityManager;
import org.apache.openejb.test.TestServer;

public class RiTestServer
implements TestServer {
    protected Process server;
    protected boolean startServerProcess;
    protected String configFile;
    protected String serverClassName = " org.apache.openejb.ri.server.Server ";
    protected String classPath;
    protected DataInputStream in;
    protected DataInputStream err;
    protected String testHomePath;
    protected File testHome;
    public static final String TEST_HOME = "test.home";
    public static final String SERVER_CLASSPATH = "server.classpath";
    public static final String SERVER_CONFIG = "test.server.config";
    public static final String START_SERVER_PROCESS = "test.start.server.process";
    public static final String BAD_ENVIRONMENT_ERROR = "The following environment variables must be set before running the test suite:\n";

    @Override
    public void init(Properties props) {
        try {
            try {
                System.setSecurityManager(new TestSecurityManager());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String tmp = props.getProperty(START_SERVER_PROCESS, "true").trim();
            this.startServerProcess = "true".equalsIgnoreCase(tmp);
            if (!this.startServerProcess) {
                return;
            }
            this.testHomePath = props.getProperty(TEST_HOME);
            this.classPath = props.getProperty(SERVER_CLASSPATH);
            this.configFile = props.getProperty(SERVER_CONFIG);
            this.checkEnvironment();
            this.testHome = new File(this.testHomePath);
            this.testHome = this.testHome.getAbsoluteFile();
            this.testHomePath = this.testHome.getAbsolutePath();
            this.prepareServerClasspath();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void destroy() {
    }

    @Override
    public void start() {
        if (!this.startServerProcess) {
            return;
        }
        String command = "java -classpath " + this.classPath + " " + this.serverClassName + " " + this.configFile;
        try {
            this.server = Runtime.getRuntime().exec(command);
            this.in = new DataInputStream(this.server.getInputStream());
            this.err = new DataInputStream(this.server.getErrorStream());
            try {
                String line;
                do {
                    line = this.in.readLine();
                    System.out.println(line);
                } while (line != null && !"[RI Server] Ready!".equals(line));
            }
            catch (Exception e) {
                // empty catch block
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = RiTestServer.this.in.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (Exception e) {
                    }
                }
            });
            t.start();
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = RiTestServer.this.err.readLine()) != null) {
                        }
                    }
                    catch (Exception e) {}
                }
            });
            t2.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (!this.startServerProcess) {
            return;
        }
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
        try {
            this.in.close();
            this.err.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Properties getContextEnvironment() {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "org.apache.openejb.ri.server.RiInitCtxFactory");
        try {
            properties.put("java.naming.provider.url", new URL("http", "127.0.0.1", 1098, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private String getConfFilePath(String confFileName) {
        String str = this.getConfFile(confFileName).getAbsolutePath();
        return str;
    }

    private File getConfFile(String confFileName) {
        return new File(this.testHome, confFileName);
    }

    private void checkEnvironment() {
        if (this.testHomePath == null || this.classPath == null || this.configFile == null) {
            Object error = BAD_ENVIRONMENT_ERROR;
            error = (String)error + (this.testHomePath == null ? "test.home\n" : "");
            error = (String)error + (this.classPath == null ? "server.classpath\n" : "");
            error = (String)error + (this.configFile == null ? "test.server.config\n" : "");
            throw new RuntimeException((String)error);
        }
    }

    private void prepareServerClasspath() {
        char PS = File.pathSeparatorChar;
        char FS = File.separatorChar;
        String javaTools = System.getProperty("java.home") + FS + "lib" + FS + "tools.jar";
        this.classPath = this.classPath.replace('/', FS);
        this.classPath = this.classPath.replace(':', PS);
        this.classPath = this.classPath + PS + javaTools;
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

