/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import org.apache.openejb.test.AnnotatedApplicationException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.StatelessTestClient;

public class StatelessLocalBusinessIntfcTests
extends StatelessTestClient {
    private BasicStatelessBusinessLocal businessLocal;

    public StatelessLocalBusinessIntfcTests() {
        super("LocalBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessPojoHomeBusinessLocal");
        StatelessLocalBusinessIntfcTests.assertNotNull((Object)obj);
        StatelessLocalBusinessIntfcTests.assertTrue((String)"instance of BasicStatelessBusinessLocal", (boolean)(obj instanceof BasicStatelessBusinessLocal));
        this.businessLocal = (BasicStatelessBusinessLocal)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessLocal.businessMethod("sseccuS");
            StatelessLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Exception e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessLocal.echo(expected);
            StatelessLocalBusinessIntfcTests.assertSame((String)"pass by reference", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessLocal.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessLocalBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessLocal.businessMethod("sseccuS");
            StatelessLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessLocal.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            StatelessLocalBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatelessLocalBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessLocalBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessLocal.remove();
        StatelessLocalBusinessIntfcTests.assertNotNull((Object)obj);
    }

    public void test07_throwAnnotatedApplicationException() {
        try {
            this.businessLocal.throwAnnotatedApplicationException();
        }
        catch (AnnotatedApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessLocalBusinessIntfcTests.fail((String)"An AnnotatedApplicationException should have been thrown.");
    }

    public void test08_invokeAfterAnnotatedApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessLocal.businessMethod("sseccuS");
            StatelessLocalBusinessIntfcTests.assertEquals((Object)"Success", (Object)actual);
        }
        catch (Throwable e) {
            StatelessLocalBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

