/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jws.WebService;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class POJODeployer
implements Deployer {
    private static Log log = LogFactory.getLog(POJODeployer.class);
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            block20: {
                try {
                    ArrayList<String> classList;
                    FileInputStream fin;
                    block21: {
                        String extension = DeploymentFileData.getFileExtension(deploymentFileData.getName());
                        if ("class".equals(extension)) {
                            File file = deploymentFileData.getFile();
                            File parentFile = file.getParentFile();
                            ClassLoader classLoader = Utils.getClassLoader(this.configCtx.getAxisConfiguration().getSystemClassLoader(), parentFile);
                            Thread.currentThread().setContextClassLoader(classLoader);
                            String className = file.getName();
                            className = className.replaceAll(".class", "");
                            Class clazz = Loader.loadClass(className);
                            log.info(Messages.getMessage("deployingpojo", className, deploymentFileData.getFile().getAbsolutePath()));
                            WebService webService = clazz.getAnnotation(WebService.class);
                            if (webService != null) {
                                AxisService axisService = this.createAxisService(classLoader, className, deploymentFileData.getFile().toURL());
                                this.configCtx.getAxisConfiguration().addService(axisService);
                                break block20;
                            } else {
                                AxisService axisService = this.createAxisServiceUsingAnnogen(className, classLoader, deploymentFileData.getFile().toURL());
                                this.configCtx.getAxisConfiguration().addService(axisService);
                            }
                            break block20;
                        }
                        if (!"jar".equals(extension)) break block20;
                        fin = null;
                        ZipInputStream zin = null;
                        try {
                            try {
                                ZipEntry entry;
                                fin = new FileInputStream(deploymentFileData.getAbsolutePath());
                                zin = new ZipInputStream(fin);
                                classList = new ArrayList<String>();
                                while ((entry = zin.getNextEntry()) != null) {
                                    String name = entry.getName();
                                    if (!name.endsWith(".class")) continue;
                                    classList.add(name);
                                }
                                zin.close();
                                fin.close();
                            }
                            catch (Exception e) {
                                log.debug(Messages.getMessage("deployingexception", e.getMessage()), e);
                                throw new DeploymentException(e);
                            }
                            Object var12_27 = null;
                            if (zin == null) break block21;
                        }
                        catch (Throwable throwable) {
                            Object var12_28 = null;
                            if (zin != null) {
                                zin.close();
                            }
                            if (fin == null) throw throwable;
                            fin.close();
                            throw throwable;
                        }
                        zin.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                    ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
                    for (Object e : classList) {
                        String string = (String)e;
                        ArrayList<URL> urls = new ArrayList<URL>();
                        urls.add(deploymentFileData.getFile().toURL());
                        urls.add(this.configCtx.getAxisConfiguration().getRepository());
                        String webLocation = DeploymentEngine.getWebLocationString();
                        if (webLocation != null) {
                            urls.add(new File(webLocation).toURL());
                        }
                        ClassLoader classLoader = Utils.createClassLoader(urls, this.configCtx.getAxisConfiguration().getSystemClassLoader(), true, (File)this.configCtx.getAxisConfiguration().getParameterValue("artifactsDIR"));
                        Thread.currentThread().setContextClassLoader(classLoader);
                        String string3 = string.replaceAll(".class", "");
                        string3 = string3.replaceAll("/", ".");
                        Class clazz = Loader.loadClass(string3);
                        WebService annotation = clazz.getAnnotation(WebService.class);
                        if (annotation == null) continue;
                        AxisService axisService = this.createAxisService(classLoader, string3, deploymentFileData.getFile().toURL());
                        axisServiceList.add(axisService);
                    }
                    if (axisServiceList.size() > 0) {
                        AxisServiceGroup serviceGroup = new AxisServiceGroup();
                        serviceGroup.setServiceGroupName(deploymentFileData.getName());
                        for (Object e : axisServiceList) {
                            AxisService axisService = (AxisService)e;
                            serviceGroup.addService(axisService);
                        }
                        this.configCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
                    } else {
                        String msg = "Error:\n No annotated classes found in the jar: " + deploymentFileData.getFile().getName() + ". Service deployment failed.";
                        log.error(msg);
                        this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                    }
                }
                catch (Exception e) {
                    log.debug(Messages.getMessage("stroringfaultyservice", e.getMessage()), e);
                    this.storeFaultyService(deploymentFileData, e);
                    Object var18_36 = null;
                    if (threadClassLoader == null) return;
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    return;
                }
                catch (Throwable t) {
                    log.debug(Messages.getMessage("stroringfaultyservice", t.getMessage()), t);
                    this.storeFaultyService(deploymentFileData, t);
                    Object var18_37 = null;
                    if (threadClassLoader == null) return;
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    return;
                }
            }
            Object var18_35 = null;
            if (threadClassLoader == null) return;
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            return;
        }
        catch (Throwable throwable) {
            Object var18_38 = null;
            if (threadClassLoader == null) throw throwable;
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            throw throwable;
        }
    }

    private void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    private AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        try {
            Class<?> claxx = Class.forName("org.apache.axis2.jaxws.description.DescriptionFactory");
            Method mthod = claxx.getMethod("createAxisService", Class.class);
            Class pojoClass = Loader.loadClass(classLoader, className);
            axisService = (AxisService)mthod.invoke(claxx, pojoClass);
            if (axisService != null) {
                Iterator<AxisOperation> operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = operations.next();
                    if (axisOperation.getMessageReceiver() != null) continue;
                    try {
                        Class jaxwsMR = Loader.loadClass("org.apache.axis2.jaxws.server.JAXWSMessageReceiver");
                        MessageReceiver jaxwsMRInstance = (MessageReceiver)jaxwsMR.newInstance();
                        axisOperation.setMessageReceiver(jaxwsMRInstance);
                    }
                    catch (Exception e) {
                        log.debug("Error occurde while loading JAXWSMessageReceiver for " + className);
                    }
                }
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            Utils.fillAxisService(axisService, this.configCtx.getAxisConfiguration(), new ArrayList(), new ArrayList());
        }
        catch (Exception e) {
            log.info(Messages.getMessage("jaxwsjarsmissing", e.getMessage()), e);
            axisService = this.createAxisServiceUsingAnnogen(className, classLoader, serviceLocation);
        }
        return axisService;
    }

    private AxisService createAxisServiceUsingAnnogen(String className, ClassLoader classLoader, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
        MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
        Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
        AxisService axisService = AxisService.createService(className, this.configCtx.getAxisConfiguration(), messageReciverMap, null, null, classLoader);
        axisService.setFileName(serviceLocation);
        return axisService;
    }

    public void setMessageReceivers(AxisService service) {
        Iterator<AxisOperation> iterator = service.getOperations();
        while (iterator.hasNext()) {
            AxisOperation operation = iterator.next();
            String MEP = operation.getMessageExchangePattern();
            if (MEP == null) continue;
            try {
                if ("http://www.w3.org/ns/wsdl/in-only".equals(MEP)) {
                    Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
                    MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
                    operation.setMessageReceiver(messageReceiver);
                    continue;
                }
                Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
                operation.setMessageReceiver(inOutmessageReceiver);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                log.error(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
        if ((fileName = Utils.getShortFileName(fileName)).endsWith(".class")) {
            String className = fileName.replaceAll(".class", "");
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(className);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info(Messages.getMessage("serviceremoved", fileName));
            }
            catch (AxisFault axisFault) {
                log.debug(Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        } else if (fileName.endsWith(".jar")) {
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(fileName);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info(Messages.getMessage("serviceremoved", fileName));
            }
            catch (AxisFault axisFault) {
                log.debug(Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        }
    }
}

