/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDL11ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    public static final int COMPONENT_PORT_TYPE = 1;
    public static final int COMPONENT_MESSAGE = 2;
    public static final int COMPONENT_BINDING = 3;
    protected static final Log log = LogFactory.getLog(WSDL11ToAxisServiceBuilder.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    protected String portName;
    private static final String BINDING = "Binding";
    private static final String SERVICE = "Service";
    private static final String PORT = "Port";
    private static final String PORT_TYPE = "PortType";
    private static final String PORT_TYPE_OPERATION = "PortType.Operation";
    private static final String PORT_TYPE_OPERATION_INPUT = "PortType.Operation.Input";
    private static final String PORT_TYPE_OPERATION_OUTPUT = "PortType.Operation.Output";
    private static final String PORT_TYPE_OPERATION_FAULT = "PortType.Operation.Fault";
    private static final String BINDING_OPERATION = "Binding.Operation";
    private static final String BINDING_OPERATION_INPUT = "Binding.Operation.Input";
    private static final String BINDING_OPERATION_OUTPUT = "Binding.Operation.Output";
    protected Definition wsdl4jDefinition = null;
    protected String wsdlBaseDocumentURI = null;
    private WSDLLocator customWSDLResolver;
    public static final String RPC_STYLE = "rpc";
    public static final String DOCUMENT_STYLE = "document";
    public static final String ENCODED_USE = "encoded";
    private List wrappableBOEs = new ArrayList();
    private String bindingType;
    public static final String WRAPPED_OUTPUTNAME_SUFFIX = "Response";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String NAMESPACE_DECLARATION_PREFIX = "xmlns:";
    private static int prefixCounter = 0;
    public static final String NAMESPACE_URI = "namespace";
    public static final String TRAGET_NAMESPACE = "targetNamespace";
    public static final String BINDING_TYPE_SOAP = "soap";
    public static final String BINDING_TYPE_HTTP = "http";
    private boolean setupComplete = false;
    private Map schemaMap = null;
    private static final String JAVAX_WSDL_VERBOSE_MODE_KEY = "javax.wsdl.verbose";
    private Map processedBindings;
    private boolean isAllPorts;

    public WSDL11ToAxisServiceBuilder(InputStream in, QName serviceName, String portName) {
        super(in, serviceName);
        this.portName = portName;
    }

    public WSDL11ToAxisServiceBuilder(Definition def, QName serviceName, String portName) {
        super(null, serviceName);
        this.wsdl4jDefinition = def;
        this.portName = portName;
        this.isAllPorts = false;
    }

    public WSDL11ToAxisServiceBuilder(Definition def, QName serviceName, String portName, boolean isAllPorts) {
        this(def, serviceName, portName);
        this.isAllPorts = isAllPorts;
    }

    public WSDL11ToAxisServiceBuilder(InputStream in, AxisService service) {
        super(in, service);
    }

    public WSDL11ToAxisServiceBuilder(InputStream in) {
        this(in, null, null);
    }

    public void setCustomWSLD4JResolver(WSDLLocator customResolver) {
        this.setCustomWSDLResolver(customResolver);
    }

    public void setCustomWSDLResolver(WSDLLocator customResolver) {
        this.customWSDLResolver = customResolver;
        this.setDocumentBaseUri(this.customWSDLResolver.getBaseURI());
    }

    public void setDocumentBaseUri(String baseUri) {
        if (this.wsdl4jDefinition != null) {
            this.wsdl4jDefinition.setDocumentBaseURI(baseUri);
        }
        this.wsdlBaseDocumentURI = baseUri;
    }

    public String getDocumentBaseUri() {
        return this.wsdlBaseDocumentURI;
    }

    public AxisService populateService() throws AxisFault {
        try {
            Service wsdl4jService;
            Binding binding;
            Definition bindingWSDL;
            Definition portTypeWSDL;
            PortType portType;
            this.setup();
            if (this.wsdl4jDefinition == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.wsdl4jDefinition.getTargetNamespace());
            this.axisService.setNamespaceMap(new NamespaceMap(this.wsdl4jDefinition.getNamespaces()));
            Map importsMap = this.wsdl4jDefinition.getImports();
            if (importsMap != null) {
                ArrayList imports = new ArrayList(importsMap.keySet());
                this.axisService.setImportedNamespaces(imports);
            }
            if ((portType = (portTypeWSDL = this.getParentDefinition(bindingWSDL = this.getParentDefinition(this.wsdl4jDefinition, (binding = this.findBinding(this.wsdl4jDefinition, wsdl4jService = this.findService(this.wsdl4jDefinition))).getQName(), 3, new HashSet()), binding.getPortType().getQName(), 1, new HashSet())).getPortType(binding.getPortType().getQName())) == null) {
                throw new AxisFault("There is no port type associated with the binding");
            }
            Element[] schemaElements = this.generateWrapperSchema(this.schemaMap, binding, portType);
            this.processTypes(this.wsdl4jDefinition, this.axisService);
            if (schemaElements != null && schemaElements.length > 0) {
                for (int i = 0; i < schemaElements.length; ++i) {
                    Element schemaElement = schemaElements[i];
                    if (schemaElement == null) continue;
                    this.axisService.addSchema(this.getXMLSchema(schemaElement, null));
                }
            }
            Element documentationElement = this.wsdl4jDefinition.getDocumentationElement();
            this.addDocumentation(this.axisService, documentationElement);
            this.axisService.setName(wsdl4jService.getQName().getLocalPart());
            this.populateEndpoints(binding, bindingWSDL, wsdl4jService, portType, portTypeWSDL);
            this.processPoliciesInDefintion(this.wsdl4jDefinition);
            this.axisService.getPolicyInclude().setPolicyRegistry(this.registry);
            Parameter wsdlDefinitionParameter = new Parameter();
            wsdlDefinitionParameter.setName("wsdl4jDefinition");
            if (!(this.wsdl4jDefinition instanceof WSDLDefinitionWrapper)) {
                AxisConfiguration ac = this.axisService.getAxisConfiguration();
                if (ac == null) {
                    ac = this.axisConfig;
                }
                WSDLDefinitionWrapper wrapper = new WSDLDefinitionWrapper(this.wsdl4jDefinition, ac);
                wsdlDefinitionParameter.setValue(wrapper);
            } else {
                wsdlDefinitionParameter.setValue(this.wsdl4jDefinition);
            }
            this.axisService.addParameter(wsdlDefinitionParameter);
            this.axisService.setWsdlFound(true);
            this.axisService.setCustomWsdl(true);
            return this.axisService;
        }
        catch (WSDLException e) {
            log.error(e.getMessage(), e);
            throw AxisFault.makeFault(e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw AxisFault.makeFault(e);
        }
    }

    private void processTypes(Definition wsdlDefinition, AxisService axisService) throws AxisFault {
        this.processTypes(wsdlDefinition, axisService, new HashSet());
    }

    private void processTypes(Definition wsdlDefinition, AxisService axisService, Set visitedWSDLs) throws AxisFault {
        visitedWSDLs.add(wsdlDefinition.getDocumentBaseURI());
        Types types = wsdlDefinition.getTypes();
        if (types != null) {
            this.copyExtensibleElements(types.getExtensibilityElements(), wsdlDefinition, axisService, "Types");
        }
        Iterator iter = wsdlDefinition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport2 = null;
        while (iter.hasNext()) {
            values = (Vector)iter.next();
            for (Import wsdlImport2 : values) {
                Definition innerDefinition = wsdlImport2.getDefinition();
                if (visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                this.processTypes(innerDefinition, axisService, visitedWSDLs);
            }
        }
    }

    private void addDocumentation(AxisDescription axisDescription, Element documentationElement) {
        Node firstChild;
        String documentation;
        if (documentationElement != null && documentationElement.getFirstChild() != null && !"".equals(documentation = DOM2Writer.nodeToString(firstChild = documentationElement.getFirstChild()))) {
            axisDescription.setDocumentation(documentation);
        }
    }

    private void populateEndpoints(Binding binding, Definition bindingWSDL, Service wsdl4jService, PortType portType, Definition portTypeWSDL) throws AxisFault {
        Map wsdl4jPorts = wsdl4jService.getPorts();
        QName bindingName = binding.getQName();
        AxisEndpoint axisEndpoint = null;
        this.processedBindings = new HashMap();
        this.populatePortType(portType, portTypeWSDL);
        Definition currentBindingWSDL = null;
        for (Port port : wsdl4jPorts.values()) {
            Binding currentBinding;
            if (this.portName != null && !this.portName.equals(port.getName()) || !(currentBinding = (currentBindingWSDL = this.getParentDefinition(this.wsdl4jDefinition, port.getBinding().getQName(), 3, new HashSet())).getBinding(port.getBinding().getQName())).getPortType().getQName().equals(binding.getPortType().getQName())) continue;
            axisEndpoint = new AxisEndpoint();
            axisEndpoint.setName(port.getName());
            if (this.axisService.getEndpointName() == null && bindingName.equals(port.getBinding().getQName())) {
                this.populateEndpoint(axisEndpoint, port, currentBinding, bindingWSDL, portType, portTypeWSDL, true);
                this.axisService.setEndpointName(axisEndpoint.getName());
                this.axisService.setBindingName(axisEndpoint.getBinding().getName().getLocalPart());
            } else {
                this.populateEndpoint(axisEndpoint, port, currentBinding, bindingWSDL, portType, portTypeWSDL, false);
            }
            axisEndpoint.setParent(this.axisService);
            this.axisService.addEndpoint(port.getName(), axisEndpoint);
        }
    }

    private void populateEndpoint(AxisEndpoint axisEndpoint, Port wsdl4jPort, Binding wsdl4jBinding, Definition bindingWSDL, PortType portType, Definition portTypeWSDL, boolean isSetMessageQNames) throws AxisFault {
        this.copyExtensibleElements(wsdl4jPort.getExtensibilityElements(), this.wsdl4jDefinition, axisEndpoint, BINDING);
        this.processEmbeddedEPR(wsdl4jPort.getExtensibilityElements(), axisEndpoint);
        this.addDocumentation(axisEndpoint, wsdl4jPort.getDocumentationElement());
        if (this.processedBindings.containsKey(wsdl4jBinding.getQName())) {
            axisEndpoint.setBinding((AxisBinding)this.processedBindings.get(wsdl4jBinding.getQName()));
        } else {
            AxisBinding axisBinding = new AxisBinding();
            axisBinding.setName(wsdl4jBinding.getQName());
            axisBinding.setParent(axisEndpoint);
            axisEndpoint.setBinding(axisBinding);
            axisBinding.setParent(axisEndpoint);
            this.populateBinding(axisBinding, wsdl4jBinding, bindingWSDL, portType, portTypeWSDL, isSetMessageQNames);
            this.processedBindings.put(wsdl4jBinding.getQName(), axisBinding);
        }
    }

    private void processEmbeddedEPR(List extensibilityElements, AxisEndpoint axisEndpoint) {
        for (ExtensibilityElement ee : extensibilityElements) {
            if (!AddressingConstants.Final.WSA_ENDPOINT_REFERENCE.equals(ee.getElementType())) continue;
            try {
                Element elt = ((UnknownExtensibilityElement)ee).getElement();
                OMElement eprOMElement = XMLUtils.toOM(elt);
                EndpointReference epr = EndpointReferenceHelper.fromOM(eprOMElement);
                Map<QName, OMElement> referenceParameters = epr.getAllReferenceParameters();
                if (referenceParameters == null) continue;
                axisEndpoint.addParameter("referenceParameters", new ArrayList<OMElement>(referenceParameters.values()));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Exception encountered processing embedded wsa:EndpointReference", e);
            }
        }
    }

    private void populatePortType(PortType wsdl4jPortType, Definition portTypeWSDL) throws AxisFault {
        this.copyExtensionAttributes(wsdl4jPortType.getExtensionAttributes(), this.axisService, PORT_TYPE);
        List wsdl4jOperations = wsdl4jPortType.getOperations();
        this.axisService.addParameter(new Parameter("interface", wsdl4jPortType.getQName().getLocalPart()));
        if (wsdl4jOperations.size() < 1) {
            throw new AxisFault("No operation found in the portType element");
        }
        ArrayList<QName> operationNames = new ArrayList<QName>();
        for (Operation wsdl4jOperation : wsdl4jOperations) {
            AxisOperation axisOperation = this.populateOperations(wsdl4jOperation, wsdl4jPortType, portTypeWSDL);
            this.addDocumentation(axisOperation, wsdl4jOperation.getDocumentationElement());
            axisOperation.setParent(this.axisService);
            this.axisService.addChild(axisOperation);
            operationNames.add(axisOperation.getName());
        }
        if (this.isCodegen) {
            this.axisService.setOperationsNameList(operationNames);
        }
    }

    private void populateBinding(AxisBinding axisBinding, Binding wsdl4jBinding, Definition bindingWSDL, PortType portType, Definition portTypeWSDL, boolean isSetMessageQNames) throws AxisFault {
        this.copyExtensibleElements(wsdl4jBinding.getExtensibilityElements(), bindingWSDL, axisBinding, BINDING);
        List wsdl4jBidingOperations = wsdl4jBinding.getBindingOperations();
        if (wsdl4jBidingOperations.size() < 1) {
            throw new AxisFault("No operation found for the binding");
        }
        this.addDocumentation(axisBinding, wsdl4jBinding.getDocumentationElement());
        TreeMap<String, AxisOperation> httpLocationMap = new TreeMap<String, AxisOperation>();
        String httpLocation = null;
        Iterator iterator = wsdl4jBidingOperations.iterator();
        while (iterator.hasNext()) {
            BindingOutput wsdl4jBindingOutput;
            BindingInput wsdl4jBindingInput;
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            BindingOperation wsdl4jBindingOperation = (BindingOperation)iterator.next();
            Operation wsdl4jOperation = this.findOperation(portType, wsdl4jBindingOperation);
            axisBindingOperation.setName(new QName(bindingWSDL.getTargetNamespace(), wsdl4jBindingOperation.getName()));
            this.addDocumentation(axisBindingOperation, wsdl4jBindingOperation.getDocumentationElement());
            AxisOperation axisOperation = this.axisService.getOperation(new QName(portTypeWSDL.getTargetNamespace(), wsdl4jOperation.getName()));
            axisBindingOperation.setAxisOperation(axisOperation);
            this.copyExtensibleElements(wsdl4jBindingOperation.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingOperation, BINDING_OPERATION);
            httpLocation = (String)axisBindingOperation.getProperty("whttp:location");
            String httpMethod = (String)axisBindingOperation.getProperty("whttp:method");
            if (httpMethod == null || "".equals(httpMethod)) {
                httpMethod = "POST";
            }
            if (httpLocation != null) {
                httpLocationMap.put(WSDLUtil.getConstantFromHTTPLocation(httpLocation, httpMethod), axisBindingOperation.getAxisOperation());
            }
            if ((wsdl4jBindingInput = wsdl4jBindingOperation.getBindingInput()) != null && WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                AxisBindingMessage axisBindingInMessage = new AxisBindingMessage();
                this.addDocumentation(axisBindingInMessage, wsdl4jBindingInput.getDocumentationElement());
                this.copyExtensibleElements(wsdl4jBindingInput.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingInMessage, BINDING_OPERATION_INPUT);
                AxisMessage axisInMessage = axisOperation.getMessage("In");
                List soapHeaders = (List)axisBindingInMessage.getProperty("wsoap:header");
                if (soapHeaders != null) {
                    for (int i = 0; i < soapHeaders.size(); ++i) {
                        SOAPHeaderMessage headerMessage = (SOAPHeaderMessage)soapHeaders.get(i);
                        axisInMessage.addSoapHeader(headerMessage);
                    }
                }
                if (isSetMessageQNames) {
                    BindingOperationEntry boe = this.find(this.wrappableBOEs, wsdl4jBindingOperation);
                    boolean isWrapped = boe == null ? false : boe.isWrappedInput();
                    axisInMessage.setWrapped(isWrapped);
                    this.addQNameReference(axisInMessage, wsdl4jOperation, wsdl4jBindingInput, isWrapped);
                }
                axisBindingInMessage.setAxisMessage(axisInMessage);
                axisBindingInMessage.setName(axisInMessage.getName());
                axisBindingInMessage.setDirection(axisInMessage.getDirection());
                axisBindingInMessage.setParent(axisBindingOperation);
                axisBindingOperation.addChild("In", axisBindingInMessage);
            }
            if ((wsdl4jBindingOutput = wsdl4jBindingOperation.getBindingOutput()) != null && WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                AxisBindingMessage axisBindingOutMessage = new AxisBindingMessage();
                this.addDocumentation(axisBindingOutMessage, wsdl4jBindingOutput.getDocumentationElement());
                AxisMessage axisOutMessage = axisOperation.getMessage("Out");
                this.copyExtensibleElements(wsdl4jBindingOutput.getExtensibilityElements(), this.wsdl4jDefinition, axisBindingOutMessage, BINDING_OPERATION_OUTPUT);
                List soapHeaders = (List)axisBindingOutMessage.getProperty("wsoap:header");
                if (soapHeaders != null) {
                    for (int i = 0; i < soapHeaders.size(); ++i) {
                        SOAPHeaderMessage headerMessage = (SOAPHeaderMessage)soapHeaders.get(i);
                        axisOutMessage.addSoapHeader(headerMessage);
                    }
                }
                if (isSetMessageQNames) {
                    BindingOperationEntry boe = this.find(this.wrappableBOEs, wsdl4jBindingOperation);
                    boolean isWrapped = boe == null ? false : boe.isWrappedOutput();
                    axisOutMessage.setWrapped(isWrapped);
                    this.addQNameReference(axisOutMessage, wsdl4jOperation, wsdl4jBindingOutput, isWrapped);
                }
                axisBindingOutMessage.setAxisMessage(axisOutMessage);
                axisBindingOutMessage.setName(axisOutMessage.getName());
                axisBindingOutMessage.setDirection(axisOutMessage.getDirection());
                axisBindingOutMessage.setParent(axisBindingOperation);
                axisBindingOperation.addChild("Out", axisBindingOutMessage);
            }
            Map bindingFaultsMap = wsdl4jBindingOperation.getBindingFaults();
            for (BindingFault bindingFault : bindingFaultsMap.values()) {
                if (bindingFault.getName() == null) {
                    throw new AxisFault("Binding name is null for the binding fault in  binding operation ==> " + wsdl4jBindingOperation.getName());
                }
                Fault wsdl4jFault = wsdl4jOperation.getFault(bindingFault.getName());
                if (wsdl4jFault == null) {
                    throw new AxisFault("Can not find the corresponding fault element in wsdl operation " + wsdl4jOperation.getName() + " for the fault" + " name " + bindingFault.getName());
                }
                Message wsdl4jFaultMessge = wsdl4jFault.getMessage();
                AxisMessage faultMessage = this.findFaultMessage(wsdl4jFaultMessge.getQName().getLocalPart(), axisOperation.getFaultMessages());
                AxisBindingMessage axisBindingFaultMessage = new AxisBindingMessage();
                this.addDocumentation(axisBindingFaultMessage, wsdl4jFaultMessge.getDocumentationElement());
                axisBindingFaultMessage.setFault(true);
                axisBindingFaultMessage.setAxisMessage(faultMessage);
                axisBindingFaultMessage.setName(faultMessage.getName());
                axisBindingFaultMessage.setParent(axisBindingOperation);
                axisBindingOperation.addFault(axisBindingFaultMessage);
                if (!isSetMessageQNames) continue;
                this.addQNameReference(faultMessage, wsdl4jFault.getMessage());
            }
            axisBindingOperation.setParent(axisBinding);
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
        axisBinding.setProperty("HTTPLocationTable", httpLocationMap);
    }

    protected void setup() throws WSDLException {
        if (this.setupComplete) {
            return;
        }
        if (this.wsdl4jDefinition == null) {
            this.wsdl4jDefinition = this.readInTheWSDLFile(this.in);
        }
        if (this.wsdl4jDefinition == null) {
            return;
        }
        this.schemaMap = new HashMap();
        this.populateSchemaMap(this.wsdl4jDefinition, new HashSet());
        this.setPolicyRegistryFromService(this.axisService);
        this.setupComplete = true;
    }

    private void populateSchemaMap(Definition definition, Set visitedWSDLs) {
        visitedWSDLs.add(definition.getDocumentBaseURI());
        Types types = definition.getTypes();
        if (types != null) {
            for (Object extensibilityElement : types.getExtensibilityElements()) {
                if (!(extensibilityElement instanceof Schema)) continue;
                Element schemaElement = ((Schema)extensibilityElement).getElement();
                this.schemaMap.put(schemaElement.getAttribute(TRAGET_NAMESPACE), schemaElement);
            }
        }
        Iterator iter = definition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport2 = null;
        while (iter.hasNext()) {
            values = (Vector)iter.next();
            for (Import wsdlImport2 : values) {
                Definition innerDefinition = wsdlImport2.getDefinition();
                if (visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                this.populateSchemaMap(innerDefinition, visitedWSDLs);
            }
        }
    }

    private Service findService(Definition definition) throws AxisFault {
        Map services = definition.getServices();
        Service service = null;
        if (this.serviceName != null) {
            service = (Service)services.get(this.serviceName);
            if (service == null) {
                throw new AxisFault("Service " + this.serviceName + " was not found in the WSDL");
            }
        } else if (services.size() > 0) {
            Iterator iter = services.values().iterator();
            while (iter.hasNext() && (service = (Service)iter.next()).getPorts().size() <= 0) {
            }
            if (service == null || service.getPorts().size() == 0) {
                throw new AxisFault("there is no service with ports to pick");
            }
        } else {
            throw new AxisFault("No service was not found in the WSDL at " + definition.getDocumentBaseURI() + " with targetnamespace " + definition.getTargetNamespace());
        }
        return service;
    }

    private Binding findBinding(Definition dif, Service service) throws AxisFault {
        Binding binding = null;
        Port port = null;
        this.copyExtensibleElements(service.getExtensibilityElements(), dif, this.axisService, SERVICE);
        if (this.portName != null) {
            port = service.getPort(this.portName);
            if (port == null) {
                throw new AxisFault("No port found for the given name :" + this.portName);
            }
        } else {
            Map ports = service.getPorts();
            if (ports != null && ports.size() > 0) {
                port = this.findPort(ports);
                if (port == null) {
                    log.info("A SOAP port was not found - picking a random port!");
                    port = (Port)ports.values().toArray()[0];
                }
                if (port != null && this.isCodegen && !this.isAllPorts) {
                    this.portName = port.getName();
                }
            }
        }
        this.axisService.setName(service.getQName().getLocalPart());
        if (port != null) {
            this.copyExtensibleElements(port.getExtensibilityElements(), dif, this.axisService, PORT);
            Definition parentDefinition = this.getParentDefinition(dif, port.getBinding().getQName(), 3, new HashSet());
            binding = parentDefinition.getBinding(port.getBinding().getQName());
            if (binding == null) {
                binding = port.getBinding();
            }
        }
        return binding;
    }

    private Port findPort(Map ports) {
        String location;
        Object extElement;
        int i;
        List extensibilityElements;
        Port returnPort = null;
        block0: for (Port port : ports.values()) {
            extensibilityElements = port.getExtensibilityElements();
            for (i = 0; i < extensibilityElements.size(); ++i) {
                extElement = extensibilityElements.get(i);
                if (!(extElement instanceof SOAP12Address)) continue;
                returnPort = port;
                location = ((SOAP12Address)extElement).getLocationURI().trim();
                if (location != null && location.startsWith("http:")) continue block0;
            }
        }
        if (returnPort != null) {
            return returnPort;
        }
        block2: for (Port port : ports.values()) {
            extensibilityElements = port.getExtensibilityElements();
            for (i = 0; i < extensibilityElements.size(); ++i) {
                extElement = extensibilityElements.get(i);
                if (!(extElement instanceof SOAPAddress)) continue;
                returnPort = port;
                location = ((SOAPAddress)extElement).getLocationURI().trim();
                if (location != null && location.startsWith("http:")) continue block2;
            }
        }
        if (returnPort != null) {
            return returnPort;
        }
        block4: for (Port port : ports.values()) {
            extensibilityElements = port.getExtensibilityElements();
            for (i = 0; i < extensibilityElements.size(); ++i) {
                extElement = extensibilityElements.get(i);
                if (!(extElement instanceof HTTPAddress)) continue;
                returnPort = port;
                location = ((HTTPAddress)extElement).getLocationURI().trim();
                if (location != null && location.startsWith("http:")) continue block4;
            }
        }
        return returnPort;
    }

    private Operation findOperation(PortType portType, BindingOperation wsdl4jBindingOperation) {
        Operation op2;
        Operation op = wsdl4jBindingOperation.getOperation();
        String input = null;
        if (op != null && op.getInput() != null && ":none".equals(input = op.getInput().getName())) {
            input = null;
        }
        String output = null;
        if (op != null && op.getOutput() != null && ":none".equals(output = op.getOutput().getName())) {
            output = null;
        }
        return (op2 = portType.getOperation(op.getName(), input, output)) == null ? op : op2;
    }

    private AxisMessage findFaultMessage(String name, ArrayList faultMessages) {
        for (int i = 0; i < faultMessages.size(); ++i) {
            AxisMessage tempMessage = (AxisMessage)faultMessages.get(i);
            if (!name.equals(tempMessage.getName())) continue;
            return tempMessage;
        }
        return null;
    }

    private void addQNameReference(AxisMessage inMessage, Operation wsdl4jOperation, BindingInput bindingInput, boolean isWrapped) {
        List extensibilityElements = bindingInput.getExtensibilityElements();
        Message wsdl4jMessage = wsdl4jOperation.getInput().getMessage();
        this.addQNameReference(inMessage, wsdl4jOperation, isWrapped, extensibilityElements, wsdl4jMessage, wsdl4jOperation.getName());
    }

    private void addQNameReference(AxisMessage outMessage, Operation wsdl4jOperation, BindingOutput bindingOutput, boolean isWrapped) {
        if (bindingOutput != null) {
            List extensibilityElements = bindingOutput.getExtensibilityElements();
            if (wsdl4jOperation.getOutput() == null) {
                return;
            }
            Message wsdl4jMessage = wsdl4jOperation.getOutput().getMessage();
            this.addQNameReference(outMessage, wsdl4jOperation, isWrapped, extensibilityElements, wsdl4jMessage, wsdl4jOperation.getName() + WRAPPED_OUTPUTNAME_SUFFIX);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addQNameReference(AxisMessage message, Operation wsdl4jOperation, boolean isWrapped, List extensibilityElements, Message wsdl4jMessage, String rpcOperationName) {
        if (isWrapped) {
            message.setElementQName((QName)this.resolvedRpcWrappedElementMap.get(rpcOperationName));
            message.getAxisOperation().getAxisService().addMessageElementQNameToOperationMapping((QName)this.resolvedRpcWrappedElementMap.get(rpcOperationName), message.getAxisOperation());
            return;
        } else {
            List bindingPartsList = this.getPartsListFromSoapBody(extensibilityElements);
            if (bindingPartsList == null) {
                if (wsdl4jMessage.getParts() != null && wsdl4jMessage.getParts().size() > 0) {
                    if (wsdl4jMessage.getParts().size() != 1) throw new WSDLProcessingException("More than one part for message " + wsdl4jMessage.getQName().getLocalPart());
                    Part part = (Part)wsdl4jMessage.getParts().values().iterator().next();
                    QName elementName = part.getElementName();
                    if (elementName == null) throw new WSDLProcessingException("No element type is defined for message " + wsdl4jMessage.getQName().getLocalPart());
                    message.setElementQName(elementName);
                    message.setMessagePartName(part.getName());
                    AxisOperation operation = message.getAxisOperation();
                    AxisService service = operation.getAxisService();
                    service.addMessageElementQNameToOperationMapping(elementName, operation);
                    return;
                } else {
                    message.setElementQName(null);
                }
                return;
            } else if (bindingPartsList.size() == 0) {
                message.setElementQName(null);
                return;
            } else {
                if (bindingPartsList.size() != 1) throw new WSDLProcessingException("More than one element part is not allwed in document literal  type binding operation " + wsdl4jOperation.getName());
                Part part = wsdl4jMessage.getPart((String)bindingPartsList.get(0));
                if (part == null) throw new WSDLProcessingException("Missing part named " + bindingPartsList.get(0) + " ");
                QName elementName = part.getElementName();
                if (elementName == null) throw new WSDLProcessingException("No element type is defined for message" + wsdl4jMessage.getQName().getLocalPart());
                message.setElementQName(elementName);
                message.setMessagePartName(part.getName());
                AxisOperation operation = message.getAxisOperation();
                AxisService service = operation.getAxisService();
                service.addMessageElementQNameToOperationMapping(elementName, operation);
            }
        }
    }

    private void addQNameReference(AxisMessage faultMessage, Message wsdl4jMessage) throws AxisFault {
        Map parts = wsdl4jMessage.getParts();
        if (parts == null || parts.size() == 0) {
            String message = "There are no parts for fault message : " + wsdl4jMessage.getQName();
            log.error(message);
            throw new WSDLProcessingException(message);
        }
        Part wsdl4jMessagePart = (Part)parts.values().toArray()[0];
        if (wsdl4jMessagePart == null) {
            throw new WSDLProcessingException();
        }
        QName name = wsdl4jMessagePart.getElementName();
        if (name == null) {
            String message = "Part '" + wsdl4jMessagePart.getName() + "' of fault message '" + wsdl4jMessage.getQName() + "' must be defined with 'element=QName' and not 'type=QName'";
            log.error(message);
            throw new AxisFault(message);
        }
        faultMessage.setMessagePartName(wsdl4jMessagePart.getName());
        faultMessage.setElementQName(name);
    }

    private String getSOAPStyle(BindingOperation bindingOp) {
        List extensibilityElements = bindingOp.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Object extElement = extensibilityElements.get(i);
            if (extElement instanceof SOAPOperation) {
                return ((SOAPOperation)extElement).getStyle();
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            return ((SOAP12Operation)extElement).getStyle();
        }
        return null;
    }

    private AxisOperation populateOperations(Operation wsdl4jOperation, PortType wsdl4jPortType, Definition dif) throws AxisFault {
        Message message;
        AxisMessage outMessage;
        Output wsdl4jOutputMessage;
        Message message2;
        AxisMessage inMessage;
        QName opName = new QName(dif.getTargetNamespace(), wsdl4jOperation.getName());
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP = this.getMEP(wsdl4jOperation);
            axisOperation = AxisOperationFactory.getOperationDescription(MEP);
            axisOperation.setName(opName);
            PolicyInclude policyInclude = new PolicyInclude(axisOperation);
            axisOperation.setPolicyInclude(policyInclude);
        }
        this.copyExtensionAttributes(wsdl4jOperation.getExtensionAttributes(), axisOperation, PORT_TYPE_OPERATION);
        Input wsdl4jInputMessage = wsdl4jOperation.getInput();
        if (this.isServerSide) {
            String action;
            if (null != wsdl4jInputMessage) {
                inMessage = axisOperation.getMessage("In");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensionAttributes(wsdl4jInputMessage.getExtensionAttributes(), inMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWSAMappingList();
                action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                    this.axisService.mapActionToOperation(action, axisOperation);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("Out");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensionAttributes(wsdl4jInputMessage.getExtensionAttributes(), outMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
        } else {
            if (null != wsdl4jInputMessage) {
                String action;
                inMessage = axisOperation.getMessage("Out");
                message2 = wsdl4jInputMessage.getMessage();
                if (null != message2) {
                    inMessage.setName(message2.getQName().getLocalPart());
                    this.copyExtensionAttributes(wsdl4jInputMessage.getExtensionAttributes(), inMessage, PORT_TYPE_OPERATION_OUTPUT);
                }
                if ((action = axisOperation.getOutputAction()) == null) {
                    action = WSDL11ActionHelper.getActionFromInputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jInputMessage);
                }
                if (action != null) {
                    axisOperation.setOutputAction(action);
                }
            }
            if (null != (wsdl4jOutputMessage = wsdl4jOperation.getOutput())) {
                outMessage = axisOperation.getMessage("In");
                message = wsdl4jOutputMessage.getMessage();
                if (null != message) {
                    outMessage.setName(message.getQName().getLocalPart());
                    this.copyExtensionAttributes(wsdl4jInputMessage.getExtensionAttributes(), outMessage, PORT_TYPE_OPERATION_INPUT);
                }
                ArrayList<String> inputActions = axisOperation.getWSAMappingList();
                String action = null;
                if (inputActions == null || inputActions.size() == 0) {
                    action = WSDL11ActionHelper.getActionFromOutputElement(dif, wsdl4jPortType, wsdl4jOperation, wsdl4jOutputMessage);
                }
                if (action != null) {
                    if (inputActions == null) {
                        inputActions = new ArrayList();
                        axisOperation.setWsamappingList(inputActions);
                    }
                    inputActions.add(action);
                }
            }
        }
        Map faults = wsdl4jOperation.getFaults();
        Iterator faultKeyIterator = faults.keySet().iterator();
        while (faultKeyIterator.hasNext()) {
            String action;
            Fault fault = (Fault)faults.get(faultKeyIterator.next());
            AxisMessage axisFaultMessage = new AxisMessage();
            this.addDocumentation(axisFaultMessage, fault.getDocumentationElement());
            Message faultMessage = fault.getMessage();
            if (null != faultMessage) {
                axisFaultMessage.setName(faultMessage.getQName().getLocalPart());
                this.copyExtensibleElements(faultMessage.getExtensibilityElements(), dif, axisFaultMessage, PORT_TYPE_OPERATION_FAULT);
            }
            if ((action = axisOperation.getFaultAction(fault.getName())) == null) {
                action = WSDL11ActionHelper.getActionFromFaultElement(dif, wsdl4jPortType, wsdl4jOperation, fault);
            }
            if (action != null) {
                axisOperation.addFaultAction(fault.getName(), action);
            }
            axisOperation.setFaultMessages(axisFaultMessage);
        }
        return axisOperation;
    }

    private Element[] generateWrapperSchema(Map schemaMap, Binding wsdl4jBinding, PortType portType) {
        ArrayList schemaElementList = new ArrayList();
        String porttypeNamespaceURI = portType.getQName().getNamespaceURI();
        List wrappableBOEList = this.findWrappableBindingOperations(wsdl4jBinding);
        Map newSchemaMap = this.createSchemaForPorttype(porttypeNamespaceURI, wrappableBOEList, schemaMap);
        schemaElementList.addAll(newSchemaMap.values());
        return schemaElementList.toArray(new Element[schemaElementList.size()]);
    }

    private Map createSchemaForPorttype(String namespaceURI, List boeListToProcess, Map existingSchemaMap) {
        Element elementDeclaration;
        HashMap<String, Element> newSchemaMap = new HashMap<String, Element>();
        if (boeListToProcess.isEmpty()) {
            return newSchemaMap;
        }
        HashMap<QName, Message> messageQnameToMessageMap = new HashMap<QName, Message>();
        HashMap<BindingOperationEntry, Message> boeToInputMessageMap = new HashMap<BindingOperationEntry, Message>();
        HashMap<BindingOperationEntry, Message> boeToOutputMessageMap = new HashMap<BindingOperationEntry, Message>();
        HashMap namespaceImportsMap = null;
        HashMap namespacePrefixMap = null;
        for (int k = 0; k < boeListToProcess.size(); ++k) {
            Output output;
            Message message;
            BindingOperationEntry boe = (BindingOperationEntry)boeListToProcess.get(k);
            Input input = boe.getBindingOperation().getOperation().getInput();
            if (input != null) {
                message = input.getMessage();
                messageQnameToMessageMap.put(message.getQName(), message);
                boeToInputMessageMap.put(boe, message);
            }
            if ((output = boe.getBindingOperation().getOperation().getOutput()) == null) continue;
            message = output.getMessage();
            messageQnameToMessageMap.put(message.getQName(), message);
            boeToOutputMessageMap.put(boe, message);
        }
        String xsdPrefix = this.findSchemaPrefix();
        Document document = this.getDOMDocumentBuilder().newDocument();
        for (BindingOperationEntry boEntry : boeToInputMessageMap.keySet()) {
            elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", boEntry.getBindingOperation().getName());
            BindingInput bindingInput = boEntry.getBindingOperation().getBindingInput();
            Message message = (Message)boeToInputMessageMap.get(boEntry);
            if (bindingInput != null) {
                List partsCollection = null;
                if (BINDING_TYPE_SOAP.equals(this.bindingType)) {
                    List bodyPartsList = this.getPartsListFromSoapBody(bindingInput.getExtensibilityElements());
                    partsCollection = message.getOrderedParts(bodyPartsList);
                } else {
                    partsCollection = message.getParts().values();
                }
                List parameterOrder = boEntry.getBindingOperation().getOperation().getParameterOrdering();
                namespaceImportsMap = new HashMap();
                namespacePrefixMap = new HashMap();
                Element newComplexType = this.getNewComplextType(document, xsdPrefix, partsCollection, parameterOrder, false, namespaceImportsMap, namespacePrefixMap, boEntry);
                elementDeclaration.appendChild(newComplexType);
                String namespaceToUse = namespaceURI;
                if (BINDING_TYPE_SOAP.equals(this.bindingType)) {
                    String bodyNamespace = this.getNamespaceFromSoapBody(bindingInput.getExtensibilityElements());
                    String string = namespaceToUse = bodyNamespace != null ? bodyNamespace : namespaceURI;
                }
                if (existingSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)existingSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else if (newSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)newSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else {
                    Element newSchema = this.createNewSchemaWithElement(elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse, document, xsdPrefix);
                    newSchemaMap.put(namespaceToUse, newSchema);
                }
                this.resolvedRpcWrappedElementMap.put(boEntry.getBindingOperation().getName(), new QName(namespaceToUse, boEntry.getBindingOperation().getName(), "axis2wrapped"));
                continue;
            }
            throw new WSDLProcessingException("No binding input is defiend for binding operation ==> " + boEntry.getBindingOperation().getName());
        }
        for (BindingOperationEntry boEntry : boeToOutputMessageMap.keySet()) {
            String baseoutputOpName = boEntry.getBindingOperation().getName();
            String outputOpName = baseoutputOpName + WRAPPED_OUTPUTNAME_SUFFIX;
            elementDeclaration = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            elementDeclaration.setAttribute("name", outputOpName);
            BindingOutput bindingOutput = boEntry.getBindingOperation().getBindingOutput();
            Message message = (Message)boeToOutputMessageMap.get(boEntry);
            if (bindingOutput != null) {
                List partsCollection = null;
                if (BINDING_TYPE_SOAP.equals(this.bindingType)) {
                    List bodyPartsList = this.getPartsListFromSoapBody(bindingOutput.getExtensibilityElements());
                    partsCollection = message.getOrderedParts(bodyPartsList);
                } else {
                    partsCollection = message.getParts().values();
                }
                List parameterOrder = boEntry.getBindingOperation().getOperation().getParameterOrdering();
                namespacePrefixMap = new HashMap();
                namespaceImportsMap = new HashMap();
                Element newComplexType = this.getNewComplextType(document, xsdPrefix, partsCollection, parameterOrder, true, namespaceImportsMap, namespacePrefixMap, boEntry);
                elementDeclaration.appendChild(newComplexType);
                String namespaceToUse = namespaceURI;
                if (BINDING_TYPE_SOAP.equals(this.bindingType)) {
                    String bodyNamespace = this.getNamespaceFromSoapBody(bindingOutput.getExtensibilityElements());
                    String string = namespaceToUse = bodyNamespace != null ? bodyNamespace : namespaceURI;
                }
                if (existingSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)existingSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else if (newSchemaMap.containsKey(namespaceToUse)) {
                    this.addElementToAnExistingSchema((Element)newSchemaMap.get(namespaceToUse), elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse);
                } else {
                    Element newSchema = this.createNewSchemaWithElement(elementDeclaration, namespacePrefixMap, namespaceImportsMap, namespaceToUse, document, xsdPrefix);
                    newSchemaMap.put(namespaceToUse, newSchema);
                }
                this.resolvedRpcWrappedElementMap.put(outputOpName, new QName(namespaceToUse, outputOpName, "axis2wrapped"));
                continue;
            }
            throw new WSDLProcessingException("No binding out put is defined for binding operation ==>" + boEntry.getBindingOperation().getName());
        }
        return newSchemaMap;
    }

    private void addElementToAnExistingSchema(Element schemaElement, Element newElement, Map namespacePrefixMap, Map namespaceImportsMap, String targetNamespace) {
        Document ownerDocument = schemaElement.getOwnerDocument();
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            this.checkAndAddNamespaceDeclarations(s, namespacePrefixMap, schemaElement);
        }
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            if (targetNamespace.equals(namespaceImports[i].getAttribute(NAMESPACE_URI))) continue;
            schemaElement.appendChild(ownerDocument.importNode(namespaceImports[i], true));
        }
        schemaElement.appendChild(ownerDocument.importNode(newElement, true));
    }

    private Element createNewSchemaWithElement(Element newElement, Map namespacePrefixMap, Map namespaceImportsMap, String targetNamespace, Document document, String xsdPrefix) {
        Element schemaElement = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "schema");
        String[] nameSpaceDeclarationArray = namespacePrefixMap.keySet().toArray(new String[namespacePrefixMap.size()]);
        for (int i = 0; i < nameSpaceDeclarationArray.length; ++i) {
            String s = nameSpaceDeclarationArray[i];
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + namespacePrefixMap.get(s).toString(), s);
        }
        if (schemaElement.getAttributeNS(XML_NAMESPACE_URI, xsdPrefix).length() == 0) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + xsdPrefix, "http://www.w3.org/2001/XMLSchema");
        }
        schemaElement.setAttributeNS(XML_NAMESPACE_URI, "xmlns:axis2wrapped", targetNamespace);
        schemaElement.setAttribute(TRAGET_NAMESPACE, targetNamespace);
        schemaElement.setAttribute("elementFormDefault", "unqualified");
        Element[] namespaceImports = namespaceImportsMap.values().toArray(new Element[namespaceImportsMap.size()]);
        for (int i = 0; i < namespaceImports.length; ++i) {
            schemaElement.appendChild(namespaceImports[i]);
        }
        schemaElement.appendChild(newElement);
        return schemaElement;
    }

    private List getPartsListFromSoapBody(List extensibilityElements) {
        List partsList = null;
        for (ExtensibilityElement extElement : extensibilityElements) {
            ExtensibilityElement soapBody;
            if (log.isDebugEnabled()) {
                log.debug("Extensibility Element type is:" + extElement.getElementType());
                log.debug("Extensibility Element class is:" + extElement.getClass().getName());
            }
            if (extElement instanceof SOAPBody) {
                soapBody = (SOAPBody)extElement;
                partsList = soapBody.getParts();
                continue;
            }
            if (extElement instanceof SOAP12Body) {
                soapBody = (SOAP12Body)extElement;
                partsList = soapBody.getParts();
                continue;
            }
            if (!(extElement instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated minMimeMultipartRelated = (MIMEMultipartRelated)extElement;
            List mimePartsList = minMimeMultipartRelated.getMIMEParts();
            MIMEPart mimePart = null;
            for (Object object : mimePartsList) {
                if (!(object instanceof MIMEPart)) continue;
                mimePart = (MIMEPart)object;
                List mimePartElements = mimePart.getExtensibilityElements();
                for (ExtensibilityElement mimePartExtensibilityElement : mimePartElements) {
                    ExtensibilityElement soapBody2;
                    if (mimePartExtensibilityElement instanceof SOAPBody) {
                        soapBody2 = (SOAPBody)mimePartExtensibilityElement;
                        partsList = soapBody2.getParts();
                        continue;
                    }
                    if (!(mimePartExtensibilityElement instanceof SOAP12Body)) continue;
                    soapBody2 = (SOAP12Body)mimePartExtensibilityElement;
                    partsList = soapBody2.getParts();
                }
            }
        }
        if (partsList == null) {
            log.debug("SOAP body parts have not been set. All the parts in the message were added to the message.");
        }
        return partsList;
    }

    private String getNamespaceFromSoapBody(List extensibilityElements) {
        String namespace = null;
        for (ExtensibilityElement extElement : extensibilityElements) {
            ExtensibilityElement soapBody;
            if (extElement instanceof SOAPBody) {
                soapBody = (SOAPBody)extElement;
                namespace = soapBody.getNamespaceURI();
                continue;
            }
            if (!(extElement instanceof SOAP12Body)) continue;
            soapBody = (SOAP12Body)extElement;
            namespace = soapBody.getNamespaceURI();
        }
        return namespace;
    }

    private Element getNewComplextType(Document document, String xsdPrefix, Collection partsCollection, List parameterOrder, boolean isOutMessage, Map namespaceImportsMap, Map namespacePrefixMap, BindingOperationEntry boe) {
        Element newComplexType = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "complexType");
        Element cmplxTypeSequence = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "sequence");
        if (parameterOrder == null || parameterOrder.size() == 0) {
            for (Part part : partsCollection) {
                this.addPartToElement(part, document, xsdPrefix, namespaceImportsMap, namespacePrefixMap, cmplxTypeSequence, isOutMessage, boe);
            }
        } else {
            Part part2;
            HashMap<String, Part> partsMap = new HashMap<String, Part>();
            for (Part part2 : partsCollection) {
                partsMap.put(part2.getName(), part2);
            }
            for (String partName : parameterOrder) {
                part2 = (Part)partsMap.get(partName);
                if (part2 == null) continue;
                this.addPartToElement(part2, document, xsdPrefix, namespaceImportsMap, namespacePrefixMap, cmplxTypeSequence, isOutMessage, boe);
                partsMap.remove(partName);
            }
            if (isOutMessage && partsMap.size() > 0) {
                if (partsMap.size() == 1) {
                    part2 = (Part)partsMap.values().iterator().next();
                    this.addPartToElement(part2, document, xsdPrefix, namespaceImportsMap, namespacePrefixMap, cmplxTypeSequence, isOutMessage, boe);
                } else {
                    throw new WSDLProcessingException("the parameter order can left atmost one part");
                }
            }
        }
        newComplexType.appendChild(cmplxTypeSequence);
        return newComplexType;
    }

    private void addPartToElement(Part part, Document document, String xsdPrefix, Map namespaceImportsMap, Map namespacePrefixMap, Element cmplxTypeSequence, boolean isOutMessage, BindingOperationEntry boe) {
        String elementName = part.getName();
        QName schemaTypeName = part.getTypeName();
        if (schemaTypeName != null) {
            String prefix;
            Element child = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "element");
            child.setAttribute("form", "unqualified");
            if ("http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
                prefix = xsdPrefix;
            } else {
                String uri = schemaTypeName.getNamespaceURI();
                if (!namespaceImportsMap.containsKey(uri)) {
                    Element namespaceImport = document.createElementNS("http://www.w3.org/2001/XMLSchema", xsdPrefix + ":" + "import");
                    namespaceImport.setAttribute(NAMESPACE_URI, uri);
                    namespaceImportsMap.put(uri, namespaceImport);
                    prefix = this.getTemporaryNamespacePrefix();
                    namespacePrefixMap.put(uri, prefix);
                } else {
                    prefix = (String)namespacePrefixMap.get(uri);
                }
            }
            child.setAttribute("name", elementName);
            child.setAttribute("type", prefix + ":" + schemaTypeName.getLocalPart());
            cmplxTypeSequence.appendChild(child);
        } else {
            String bindingOperationName = boe.getBindingOperation().getName();
            String partName = part.getName();
            if (boe.isRPC()) {
                throw new WSDLProcessingException("The binding operation " + bindingOperationName + " is RPC/literal. " + "The message parts for this operation must use the type " + "attribute as specificed by " + "WS-I Basic Profile specification (4.4.1).  Message part, " + partName + ", violates" + "this rule.  Please remove the element attribute " + "and use the type attribute.");
            }
            boe.setWrappedOutput(false);
            if (log.isDebugEnabled()) {
                log.debug("The binding operation " + bindingOperationName + " references message part " + partName + ".  This part does not use the " + "type attribute, so a wrappering element is not added.");
            }
        }
    }

    private void checkAndAddNamespaceDeclarations(String namespace, Map prefixMap, Element schemaElement) {
        String prefix = (String)prefixMap.get(namespace);
        String existingURL = schemaElement.getAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix);
        if (existingURL == null || existingURL.length() == 0) {
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + prefix, namespace);
        } else if (!existingURL.equals(namespace)) {
            String generatedPrefix = "ns" + prefixCounter++;
            while (prefixMap.containsKey(generatedPrefix)) {
                generatedPrefix = "ns" + prefixCounter++;
            }
            schemaElement.setAttributeNS(XML_NAMESPACE_URI, NAMESPACE_DECLARATION_PREFIX + generatedPrefix, namespace);
            prefixMap.put(namespace, generatedPrefix);
        }
    }

    private Definition readInTheWSDLFile(InputStream in) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature(JAVAX_WSDL_VERBOSE_MODE_KEY, false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        if (this.customWSDLResolver != null) {
            Definition def = reader.readWSDL(this.customWSDLResolver);
            def.setDocumentBaseURI(this.customWSDLResolver.getBaseURI());
            return def;
        }
        try {
            doc = XMLUtils.newDocument(in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading 1.1 WSDL with base uri = " + this.getBaseUri());
            log.debug("  the document base uri = " + this.getDocumentBaseUri());
            log.trace("  the stack at this point is: " + WSDL11ToAxisServiceBuilder.stackToString());
        }
        Definition def = reader.readWSDL(this.getBaseUri(), doc);
        def.setDocumentBaseURI(this.getDocumentBaseUri());
        return def;
    }

    private void copyExtensibleElements(List wsdl4jExtensibleElements, Definition wsdl4jDefinition, AxisDescription description, String originOfExtensibilityElements) throws AxisFault {
        for (ExtensibilityElement wsdl4jExtensibilityElement : wsdl4jExtensibleElements) {
            AxisBinding axisBinding;
            ExtensibilityElement soapBinding;
            AxisBindingMessage bindingMessage;
            Message msg;
            Boolean required;
            SOAPHeaderMessage headerMessage;
            ExtensibilityElement soapHeader;
            String style;
            AxisBindingOperation axisBindingOperation;
            ExtensibilityElement soapOperation;
            ExtensibilityElement soapAddress;
            if (wsdl4jExtensibilityElement instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement unknown = (UnknownExtensibilityElement)wsdl4jExtensibilityElement;
                QName type = unknown.getElementType();
                if (WSDLConstants.WSDL11Constants.POLICY.equals(type)) {
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: PolicyElement found " + unknown);
                    }
                    Policy policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement());
                    description.getPolicySubject().attachPolicy(policy);
                    continue;
                }
                if (WSDLConstants.WSDL11Constants.POLICY_REFERENCE.equals(type)) {
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: PolicyReference found " + unknown);
                    }
                    PolicyReference policyReference = (PolicyReference)PolicyUtil.getPolicyComponent(unknown.getElement());
                    description.getPolicySubject().attachPolicyReference(policyReference);
                    continue;
                }
                if (AddressingConstants.Final.WSAW_USING_ADDRESSING.equals(type) || AddressingConstants.Submission.WSAW_USING_ADDRESSING.equals(unknown.getElementType())) {
                    if (isTraceEnabled) {
                        log.trace("copyExtensibleElements:: wsaw:UsingAddressing found " + unknown);
                    }
                    if (!originOfExtensibilityElements.equals(PORT) && !originOfExtensibilityElements.equals(BINDING)) continue;
                    if (Boolean.TRUE.equals(unknown.getRequired())) {
                        AddressingHelper.setAddressingRequirementParemeterValue(this.axisService, "required");
                        continue;
                    }
                    AddressingHelper.setAddressingRequirementParemeterValue(this.axisService, "optional");
                    continue;
                }
                if (wsdl4jExtensibilityElement.getElementType() != null && wsdl4jExtensibilityElement.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/formatbinding/")) {
                    Element typeMapping = unknown.getElement();
                    NodeList typeMaps = typeMapping.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/formatbinding/", "typeMap");
                    int count = typeMaps.getLength();
                    HashMap<QName, String> typeMapper = new HashMap<QName, String>();
                    for (int index = 0; index < count; ++index) {
                        String ns;
                        String prefix;
                        Node node = typeMaps.item(index);
                        NamedNodeMap attributes = node.getAttributes();
                        Node typeName = attributes.getNamedItem("typeName");
                        if (typeName == null || (prefix = WSDL11ToAxisServiceBuilder.getPrefix(typeName.getNodeValue())) == null || (ns = (String)wsdl4jDefinition.getNamespaces().get(prefix)) == null) continue;
                        Node formatType = attributes.getNamedItem("formatType");
                        typeMapper.put(new QName(ns, WSDL11ToAxisServiceBuilder.getTypeName(typeName.getNodeValue())), formatType.getNodeValue());
                    }
                    continue;
                }
                if (wsdl4jExtensibilityElement.getElementType() != null && wsdl4jExtensibilityElement.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/java/")) {
                    Element unknowJavaElement = unknown.getElement();
                    if (!unknowJavaElement.getLocalName().equals("address")) continue;
                    NamedNodeMap nameAttributes = unknowJavaElement.getAttributes();
                    Node node = nameAttributes.getNamedItem("className");
                    Parameter serviceClass = new Parameter();
                    serviceClass.setName("className");
                    serviceClass.setValue(node.getNodeValue());
                    this.axisService.addParameter(serviceClass);
                    Parameter transportName = new Parameter();
                    transportName.setName("TRANSPORT_NAME");
                    transportName.setValue("java");
                    this.axisService.addParameter(transportName);
                    continue;
                }
                if (!isTraceEnabled) continue;
                log.trace("copyExtensibleElements:: Unknown Extensibility Element found " + unknown);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Address) {
                soapAddress = (SOAP12Address)wsdl4jExtensibilityElement;
                if (!(description instanceof AxisEndpoint)) continue;
                this.setEndpointURL((AxisEndpoint)description, soapAddress.getLocationURI());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPAddress) {
                soapAddress = (SOAPAddress)wsdl4jExtensibilityElement;
                if (!(description instanceof AxisEndpoint)) continue;
                this.setEndpointURL((AxisEndpoint)description, soapAddress.getLocationURI());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof HTTPAddress) {
                HTTPAddress httpAddress = (HTTPAddress)wsdl4jExtensibilityElement;
                if (!(description instanceof AxisEndpoint)) continue;
                this.setEndpointURL((AxisEndpoint)description, httpAddress.getLocationURI());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof Schema) {
                Schema schema = (Schema)wsdl4jExtensibilityElement;
                this.axisService.addSchema(this.getXMLSchema(schema.getElement(), schema.getDocumentBaseURI()));
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Operation) {
                soapOperation = (SOAP12Operation)wsdl4jExtensibilityElement;
                axisBindingOperation = (AxisBindingOperation)description;
                style = soapOperation.getStyle();
                if (style != null) {
                    axisBindingOperation.setProperty("style", style);
                }
                String soapActionURI = soapOperation.getSoapActionURI();
                if (this.isCodegen && (soapActionURI == null || soapActionURI.equals(""))) {
                    soapActionURI = axisBindingOperation.getAxisOperation().getInputAction();
                }
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("WSDL Binding Operation: " + axisBindingOperation.getName() + ", SOAPAction: " + soapActionURI);
                }
                if (soapActionURI == null || soapActionURI.equals("")) continue;
                axisBindingOperation.setProperty("wsoap:action", soapActionURI);
                axisBindingOperation.getAxisOperation().setSoapAction(soapActionURI);
                if (!this.isServerSide) {
                    axisBindingOperation.getAxisOperation().setOutputAction(soapActionURI);
                }
                this.axisService.mapActionToOperation(soapActionURI, axisBindingOperation.getAxisOperation());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPOperation) {
                soapOperation = (SOAPOperation)wsdl4jExtensibilityElement;
                axisBindingOperation = (AxisBindingOperation)description;
                style = soapOperation.getStyle();
                if (style != null) {
                    axisBindingOperation.setProperty("style", style);
                }
                String soapAction = soapOperation.getSoapActionURI();
                if (this.isCodegen && (soapAction == null || soapAction.equals(""))) {
                    soapAction = axisBindingOperation.getAxisOperation().getInputAction();
                }
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug("WSDL Binding Operation: " + axisBindingOperation.getName() + ", SOAPAction: " + soapAction);
                }
                if (soapAction == null || soapAction.equals("")) continue;
                axisBindingOperation.setProperty("wsoap:action", soapAction);
                axisBindingOperation.getAxisOperation().setSoapAction(soapAction);
                if (!this.isServerSide) {
                    axisBindingOperation.getAxisOperation().setOutputAction(soapAction);
                }
                this.axisService.mapActionToOperation(soapAction, axisBindingOperation.getAxisOperation());
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof HTTPOperation) {
                HTTPOperation httpOperation = (HTTPOperation)wsdl4jExtensibilityElement;
                axisBindingOperation = (AxisBindingOperation)description;
                String httpLocation = httpOperation.getLocationURI();
                if (httpLocation != null) {
                    httpLocation = httpLocation.replaceAll("\\(", "{");
                    httpLocation = httpLocation.replaceAll("\\)", "}");
                    axisBindingOperation.setProperty("whttp:location", httpLocation);
                }
                axisBindingOperation.setProperty("whttp:inputSerialization", "application/x-www-form-urlencoded");
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Header) {
                soapHeader = (SOAP12Header)wsdl4jExtensibilityElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (required != null) {
                    headerMessage.setRequired(required);
                }
                if (wsdl4jDefinition != null) {
                    msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    Part msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisBindingMessage)) continue;
                bindingMessage = (AxisBindingMessage)description;
                ArrayList<SOAPHeaderMessage> soapHeaders = (ArrayList<SOAPHeaderMessage>)bindingMessage.getProperty("wsoap:header");
                if (soapHeaders == null) {
                    soapHeaders = new ArrayList<SOAPHeaderMessage>();
                    bindingMessage.setProperty("wsoap:header", soapHeaders);
                }
                soapHeaders.add(headerMessage);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPHeader) {
                soapHeader = (SOAPHeader)wsdl4jExtensibilityElement;
                headerMessage = new SOAPHeaderMessage();
                headerMessage.setNamespaceURI(soapHeader.getNamespaceURI());
                headerMessage.setUse(soapHeader.getUse());
                required = soapHeader.getRequired();
                if (null != required) {
                    headerMessage.setRequired(required);
                }
                if (null != wsdl4jDefinition) {
                    msg = wsdl4jDefinition.getMessage(soapHeader.getMessage());
                    if (msg == null) {
                        throw new AxisFault("message " + soapHeader.getMessage() + " not found in the WSDL ");
                    }
                    Part msgPart = msg.getPart(soapHeader.getPart());
                    if (msgPart == null) {
                        throw new AxisFault("message part " + soapHeader.getPart() + " not found in the WSDL ");
                    }
                    headerMessage.setElement(msgPart.getElementName());
                }
                headerMessage.setMessage(soapHeader.getMessage());
                headerMessage.setPart(soapHeader.getPart());
                if (!(description instanceof AxisBindingMessage)) continue;
                bindingMessage = (AxisBindingMessage)description;
                ArrayList<SOAPHeaderMessage> soapHeaders = (ArrayList<SOAPHeaderMessage>)bindingMessage.getProperty("wsoap:header");
                if (soapHeaders == null) {
                    soapHeaders = new ArrayList<SOAPHeaderMessage>();
                    bindingMessage.setProperty("wsoap:header", soapHeaders);
                }
                soapHeaders.add(headerMessage);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAPBinding) {
                soapBinding = (SOAPBinding)wsdl4jExtensibilityElement;
                axisBinding = (AxisBinding)description;
                axisBinding.setType(soapBinding.getTransportURI());
                axisBinding.setProperty("wsoap:version", "http://schemas.xmlsoap.org/soap/envelope/");
                style = soapBinding.getStyle();
                if (style == null) continue;
                axisBinding.setProperty("style", style);
                continue;
            }
            if (wsdl4jExtensibilityElement instanceof SOAP12Binding) {
                soapBinding = (SOAP12Binding)wsdl4jExtensibilityElement;
                axisBinding = (AxisBinding)description;
                axisBinding.setProperty("wsoap:version", "http://www.w3.org/2003/05/soap-envelope");
                style = soapBinding.getStyle();
                if (style != null) {
                    axisBinding.setProperty("style", style);
                }
                String transportURI = soapBinding.getTransportURI();
                axisBinding.setType(transportURI);
                continue;
            }
            if (!(wsdl4jExtensibilityElement instanceof HTTPBinding)) continue;
            HTTPBinding httpBinding = (HTTPBinding)wsdl4jExtensibilityElement;
            axisBinding = (AxisBinding)description;
            axisBinding.setType("http://www.w3.org/ns/wsdl/http");
            axisBinding.setProperty("whttp:method", httpBinding.getVerb());
        }
    }

    private int getPolicyAttachmentPoint(AxisDescription description, String originOfExtensibilityElements) {
        int result = -1;
        if (SERVICE.equals(originOfExtensibilityElements)) {
            result = 6;
        } else if (PORT.equals(originOfExtensibilityElements)) {
            result = 7;
        } else if (BINDING.equals(originOfExtensibilityElements)) {
            result = 9;
        } else if (BINDING_OPERATION.equals(originOfExtensibilityElements)) {
            result = 11;
        } else if (BINDING_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            result = 14;
        } else if (BINDING_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            result = 15;
        } else if (PORT_TYPE.equals(originOfExtensibilityElements)) {
            result = 8;
        } else if (PORT_TYPE_OPERATION.equals(originOfExtensibilityElements)) {
            result = 10;
        } else if (PORT_TYPE_OPERATION_INPUT.equals(originOfExtensibilityElements)) {
            result = 12;
        } else if (PORT_TYPE_OPERATION_OUTPUT.equals(originOfExtensibilityElements)) {
            result = 13;
        }
        if (isTraceEnabled) {
            log.trace("getPolicyAttachmentPoint:: axisDescription=" + description + " extensibilityPoint=" + originOfExtensibilityElements + " result=" + result);
        }
        return result;
    }

    private List findWrappableBindingOperations(Binding binding) {
        boolean isRPC = false;
        boolean isSOAPBinding = false;
        boolean isHttpBinding = false;
        List extElements = binding.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            ExtensibilityElement soapBinding;
            if (extElements.get(i) instanceof SOAPBinding) {
                isSOAPBinding = true;
                soapBinding = (SOAPBinding)extElements.get(i);
                if (RPC_STYLE.equals(soapBinding.getStyle())) {
                    isRPC = true;
                }
                this.bindingType = BINDING_TYPE_SOAP;
                break;
            }
            if (extElements.get(i) instanceof SOAP12Binding) {
                isSOAPBinding = true;
                soapBinding = (SOAP12Binding)extElements.get(i);
                if (RPC_STYLE.equals(soapBinding.getStyle())) {
                    isRPC = true;
                }
                this.bindingType = BINDING_TYPE_SOAP;
                break;
            }
            if (!(extElements.get(i) instanceof HTTPBinding)) continue;
            isHttpBinding = true;
            this.bindingType = BINDING_TYPE_HTTP;
        }
        if (log.isDebugEnabled()) {
            log.debug("Binding Name    =" + binding.getQName());
            log.debug("  isSOAPBinding =" + isSOAPBinding);
            log.debug("  isHttpBinding =" + isHttpBinding);
            log.debug("  isRPC         =" + isRPC);
        }
        ArrayList<BindingOperationEntry> returnList = new ArrayList<BindingOperationEntry>();
        if (isHttpBinding || isSOAPBinding) {
            for (BindingOperation bindingOp : binding.getBindingOperations()) {
                if (log.isDebugEnabled()) {
                    log.debug("  Binding Operation  =" + bindingOp.getName());
                }
                if (isSOAPBinding) {
                    BindingOperationEntry boe;
                    String style = this.getSOAPStyle(bindingOp);
                    if (log.isDebugEnabled()) {
                        log.debug("    SOAPStyle  =" + style);
                    }
                    if (style == null) {
                        if (!isRPC) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("    schema wrappering required");
                        }
                        boe = new BindingOperationEntry(bindingOp, true, false, style, true);
                        returnList.add(boe);
                        continue;
                    }
                    if (!RPC_STYLE.equals(style)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("    schema wrappering required");
                    }
                    boe = new BindingOperationEntry(bindingOp, true, false, style, true);
                    returnList.add(boe);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("    schema wrappering required");
                }
                BindingOperationEntry boe = new BindingOperationEntry(bindingOp, false, true, null, false);
                returnList.add(boe);
            }
        }
        this.wrappableBOEs = returnList;
        return returnList;
    }

    private String getMEP(Operation operation) throws AxisFault {
        OperationType operationType = operation.getStyle();
        if (this.isServerSide) {
            if (operationType != null) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    return "http://www.w3.org/ns/wsdl/in-out";
                }
                if (operationType.equals(OperationType.ONE_WAY)) {
                    if (operation.getFaults().size() > 0) {
                        return "http://www.w3.org/ns/wsdl/robust-in-only";
                    }
                    return "http://www.w3.org/ns/wsdl/in-only";
                }
                if (operationType.equals(OperationType.NOTIFICATION)) {
                    return "http://www.w3.org/ns/wsdl/out-only";
                }
                if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    return "http://www.w3.org/ns/wsdl/out-in";
                }
                throw new AxisFault("Cannot Determine the MEP");
            }
        } else if (operationType != null) {
            if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                return "http://www.w3.org/ns/wsdl/out-in";
            }
            if (operationType.equals(OperationType.ONE_WAY)) {
                return "http://www.w3.org/ns/wsdl/out-only";
            }
            if (operationType.equals(OperationType.NOTIFICATION)) {
                return "http://www.w3.org/ns/wsdl/in-only";
            }
            if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                return "http://www.w3.org/ns/wsdl/in-out";
            }
            throw new AxisFault("Cannot Determine the MEP");
        }
        throw new AxisFault("Cannot Determine the MEP");
    }

    private void copyExtensionAttributes(Map extAttributes, AxisDescription description, String origin) {
        for (QName key : extAttributes.keySet()) {
            QName value;
            String policyURIs;
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(key.getNamespaceURI()) || !"PolicyURIs".equals(key.getLocalPart()) || (policyURIs = (value = (QName)extAttributes.get(key)).getLocalPart()).length() == 0) continue;
            String[] uris = policyURIs.split(" ");
            for (int i = 0; i < uris.length; ++i) {
                PolicySubject subject;
                PolicyReference ref = new PolicyReference();
                ref.setURI(uris[i]);
                if (!PORT_TYPE.equals(origin) && !PORT_TYPE_OPERATION.equals(origin) && !PORT_TYPE_OPERATION_INPUT.equals(origin) && !PORT_TYPE_OPERATION_OUTPUT.equals(origin) || description == null || (subject = description.getPolicySubject()) == null) continue;
                subject.attachPolicyReference(ref);
            }
        }
    }

    private void processPoliciesInDefintion(Definition definition) {
        this.processPoliciesInDefintion(definition, new HashSet());
    }

    private void processPoliciesInDefintion(Definition definition, Set visitedWSDLs) {
        visitedWSDLs.add(definition.getDocumentBaseURI());
        List extElements = definition.getExtensibilityElements();
        UnknownExtensibilityElement unknown = null;
        Policy policy = null;
        for (ExtensibilityElement extElement : extElements) {
            String key;
            if (!(extElement instanceof UnknownExtensibilityElement) || !WSDLConstants.WSDL11Constants.POLICY.equals((unknown = (UnknownExtensibilityElement)extElement).getElementType()) || (key = (policy = (Policy)PolicyUtil.getPolicyComponent(unknown.getElement())).getName()) == null && (key = policy.getId()) == null) continue;
            this.axisService.registerPolicy(key, policy);
        }
        Iterator iter = definition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport2 = null;
        while (iter.hasNext()) {
            values = (Vector)iter.next();
            for (Import wsdlImport2 : values) {
                Definition innerDefinition = wsdlImport2.getDefinition();
                if (visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                this.processPoliciesInDefintion(innerDefinition, visitedWSDLs);
            }
        }
    }

    private void setEndpointURL(AxisEndpoint axisEndpoint, String endpointURL) throws AxisFault {
        axisEndpoint.setEndpointURL(endpointURL);
        try {
            URL url = new URL(endpointURL);
            axisEndpoint.setTransportInDescription(url.getProtocol());
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
        }
    }

    public boolean isAllPorts() {
        return this.isAllPorts;
    }

    public void setAllPorts(boolean allPorts) {
        this.isAllPorts = allPorts;
    }

    public static String getPrefix(String attributeValue) {
        int splitIdex;
        if (attributeValue != null && (splitIdex = attributeValue.indexOf(58)) > 0) {
            return attributeValue.substring(0, splitIdex);
        }
        return null;
    }

    public static String getTypeName(String attributeValue) {
        if (attributeValue != null) {
            int splitIdex = attributeValue.indexOf(58);
            if (splitIdex > 0) {
                return attributeValue.substring(splitIdex + 1);
            }
            return attributeValue;
        }
        return null;
    }

    private Definition getParentDefinition(Definition definition, QName qname, int componentType, Set visitedWSDLs) {
        visitedWSDLs.add(definition.getDocumentBaseURI());
        Definition newParentDefinition = null;
        Iterator iter = definition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport = null;
        while (iter.hasNext()) {
            Definition innerDefinition;
            values = (Vector)iter.next();
            Iterator valuesIter = values.iterator();
            while (valuesIter.hasNext() && (visitedWSDLs.contains((innerDefinition = (wsdlImport = (Import)valuesIter.next()).getDefinition()).getDocumentBaseURI()) || (newParentDefinition = this.getParentDefinition(innerDefinition, qname, componentType, visitedWSDLs)) == null)) {
            }
            if (newParentDefinition == null) continue;
        }
        if (newParentDefinition == null && this.isComponetAvailable(definition, qname, componentType)) {
            newParentDefinition = definition;
        }
        return newParentDefinition;
    }

    private boolean isComponetAvailable(Definition definition, QName qname, int componentType) {
        boolean isAvailable = false;
        switch (componentType) {
            case 3: {
                isAvailable = definition.getBinding(qname) != null && definition.getBinding(qname).getPortType() != null;
                break;
            }
            case 1: {
                isAvailable = definition.getPortType(qname) != null;
                break;
            }
            case 2: {
                isAvailable = definition.getMessage(qname) != null;
            }
        }
        return isAvailable;
    }

    private BindingOperationEntry find(List boes, BindingOperation bo) {
        for (int i = 0; i < boes.size(); ++i) {
            BindingOperationEntry boe = (BindingOperationEntry)boes.get(i);
            if (boe.getBindingOperation() != bo) continue;
            return boe;
        }
        return null;
    }

    class BindingOperationEntry {
        private BindingOperation bindingOperation;
        private boolean isSOAPBinding;
        private boolean isHTTPBinding;
        private String soapStyle;
        private boolean isRPC;
        private boolean wrappedInput = true;
        private boolean wrappedOutput = true;

        public BindingOperationEntry(BindingOperation bindingOperation, boolean isSOAPBinding, boolean isHTTPBinding, String soapStyle, boolean isRPC) {
            this.bindingOperation = bindingOperation;
            this.isSOAPBinding = isSOAPBinding;
            this.isHTTPBinding = isHTTPBinding;
            this.soapStyle = soapStyle;
            this.isRPC = isRPC;
        }

        public boolean isHTTPBinding() {
            return this.isHTTPBinding;
        }

        public boolean isSOAPBinding() {
            return this.isSOAPBinding;
        }

        public String getSoapStyle() {
            return this.soapStyle;
        }

        public boolean isRPC() {
            return this.isRPC;
        }

        public BindingOperation getBindingOperation() {
            return this.bindingOperation;
        }

        public boolean isWrappedInput() {
            return this.wrappedInput;
        }

        public void setWrappedInput(boolean wrappedInput) {
            this.wrappedInput = wrappedInput;
        }

        public boolean isWrappedOutput() {
            return this.wrappedOutput;
        }

        public void setWrappedOutput(boolean wrappedOutput) {
            this.wrappedOutput = wrappedOutput;
        }
    }

    public static class WSDLProcessingException
    extends RuntimeException {
        public WSDLProcessingException() {
        }

        public WSDLProcessingException(String message) {
            super(message);
        }

        public WSDLProcessingException(Throwable cause) {
            super(cause);
        }

        public WSDLProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

