/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment.tracker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.osgi.deployment.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class BundleTracker {
    private List<Registry> registryList = new ArrayList<Registry>();
    private List<Bundle> bundleList = new ArrayList<Bundle>();
    private boolean open;
    private BundleContext context;
    private BundleListener bundleListener;
    private static Log log = LogFactory.getLog(BundleTracker.class);
    private final Lock lock = new ReentrantLock();

    public BundleTracker(final BundleContext context) {
        this.context = context;
        this.bundleListener = new BundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void bundleChanged(BundleEvent event) {
                BundleTracker.this.lock.lock();
                try {
                    if (!BundleTracker.this.open) {
                        return;
                    }
                    Bundle bundle = event.getBundle();
                    switch (event.getType()) {
                        case 2: {
                            if (BundleTracker.this.bundleList.contains(event.getBundle())) return;
                            BundleTracker.this.bundleList.add(event.getBundle());
                            Iterator i$ = BundleTracker.this.registryList.iterator();
                            while (i$.hasNext()) {
                                Registry registry = (Registry)i$.next();
                                registry.register(bundle);
                            }
                            return;
                        }
                        case 4: {
                            if (context.getBundle() == bundle) return;
                            if (!BundleTracker.this.bundleList.contains(event.getBundle())) return;
                            BundleTracker.this.bundleList.remove(event.getBundle());
                            Iterator i$ = BundleTracker.this.registryList.iterator();
                            while (i$.hasNext()) {
                                Registry registry = (Registry)i$.next();
                                registry.unRegister(bundle, false);
                            }
                            return;
                        }
                        case 16: {
                            if (context.getBundle() == bundle) return;
                            if (!BundleTracker.this.bundleList.contains(event.getBundle())) return;
                            BundleTracker.this.bundleList.remove(event.getBundle());
                            Iterator i$ = BundleTracker.this.registryList.iterator();
                            while (i$.hasNext()) {
                                Registry registry = (Registry)i$.next();
                                registry.remove(bundle);
                            }
                            return;
                        }
                    }
                    return;
                }
                finally {
                    BundleTracker.this.lock.unlock();
                }
            }
        };
    }

    public void addRegistry(Registry registry) {
        this.registryList.add(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.lock.lock();
        try {
            if (!this.open) {
                Bundle[] bundles;
                this.open = true;
                log.info("Bundle tracker is opened");
                for (Bundle bundle : bundles = this.context.getBundles()) {
                    if (bundle.getState() != 32) continue;
                    this.bundleList.add(bundle);
                    for (Registry registry : this.registryList) {
                        registry.register(bundle);
                    }
                }
                this.context.addBundleListener(this.bundleListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            if (this.open) {
                Bundle[] bundles;
                this.open = false;
                this.context.removeBundleListener(this.bundleListener);
                for (Bundle bundle : bundles = this.bundleList.toArray(new Bundle[this.bundleList.size()])) {
                    if (!this.bundleList.remove(bundle)) continue;
                    for (Registry registry : this.registryList) {
                        registry.remove(bundle);
                    }
                }
                log.info("Bundle tracker is closed");
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

