/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisError;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String ILLEGAL_CHARACTERS = "/\n\r\t\u0000\f`?*\\<>|\":";

    public static void addHandler(Flow flow, Handler handler, String phaseName) {
        HandlerDescription handlerDesc = new HandlerDescription(handler.getName());
        PhaseRule rule = new PhaseRule(phaseName);
        handlerDesc.setRules(rule);
        handler.init(handlerDesc);
        handlerDesc.setHandler(handler);
        flow.addHandler(handlerDesc);
    }

    public static MessageContext createOutMessageContext(MessageContext inMessageContext) throws AxisFault {
        return MessageContextBuilder.createOutMessageContext(inMessageContext);
    }

    public static AxisService createSimpleService(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleService(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleServiceforClient(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleInOnlyService(QName serviceName, MessageReceiver messageReceiver, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Utils.getContextClassLoader_DoPriv());
        InOnlyAxisOperation axisOp = new InOnlyAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/" + opName.getLocalPart(), axisOp);
        return service;
    }

    private static ClassLoader getContextClassLoader_DoPriv() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static AxisService createSimpleService(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Utils.getContextClassLoader_DoPriv());
        service.addParameter(new Parameter("ServiceClass", className));
        InOutAxisOperation axisOp = new InOutAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        service.mapActionToOperation("http://ws.apache.org/namespaces/axis2/" + opName.getLocalPart(), axisOp);
        return service;
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Utils.getContextClassLoader_DoPriv());
        service.addParameter(new Parameter("ServiceClass", className));
        OutInAxisOperation axisOp = new OutInAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        return service;
    }

    public static ServiceContext fillContextInformation(AxisService axisService, ConfigurationContext configurationContext) throws AxisFault {
        return Utils.fillServiceContextAndServiceGroupContext(axisService, configurationContext);
    }

    private static ServiceContext fillServiceContextAndServiceGroupContext(AxisService axisService, ConfigurationContext configurationContext) throws AxisFault {
        String serviceGroupContextId = UUIDGenerator.getUUID();
        ServiceGroupContext serviceGroupContext = configurationContext.createServiceGroupContext(axisService.getAxisServiceGroup());
        serviceGroupContext.setId(serviceGroupContextId);
        configurationContext.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
        return serviceGroupContext.getServiceContext(axisService);
    }

    public static String[] parseRequestURLForServiceAndOperation(String path, String servicePath) {
        if (log.isDebugEnabled()) {
            log.debug("parseRequestURLForServiceAndOperation : [" + path + "][" + servicePath + "]");
        }
        if (path == null) {
            return null;
        }
        String[] values = new String[2];
        int index = path.lastIndexOf(servicePath);
        if (-1 != index) {
            int serviceStart = index + servicePath.length();
            if (path.length() > serviceStart + 1) {
                int operationIndex;
                String service = path.substring(serviceStart + 1);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                if ((operationIndex = service.indexOf(47)) > 0) {
                    values[0] = service.substring(0, operationIndex);
                    values[1] = service.substring(operationIndex + 1);
                    operationIndex = values[1].lastIndexOf(47);
                    if (operationIndex > 0) {
                        values[1] = values[1].substring(operationIndex + 1);
                    }
                } else {
                    values[0] = service;
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to parse request URL [" + path + "][" + servicePath + "]");
        }
        return values;
    }

    public static ConfigurationContext getNewConfigurationContext(String repositry) throws Exception {
        final File file = new File(repositry);
        boolean exists = Utils.exists(file);
        if (!exists) {
            throw new Exception("repository directory " + file.getAbsolutePath() + " does not exists");
        }
        File axis2xml = new File(file, "axis.xml");
        String axis2xmlString = null;
        if (Utils.exists(axis2xml)) {
            axis2xmlString = axis2xml.getName();
        }
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        });
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(path, axis2xmlString);
    }

    private static boolean exists(final File file) {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(file.exists());
            }
        });
        return exists;
    }

    public static String getParameterValue(Parameter param) {
        if (param == null) {
            return null;
        }
        return (String)param.getValue();
    }

    public static String getModuleName(String moduleName, String moduleVersion) {
        if (moduleVersion != null && moduleVersion.length() != 0) {
            moduleName = moduleName + "-" + moduleVersion;
        }
        return moduleName;
    }

    public static boolean isValidModuleName(String moduleName) {
        for (int i = 0; i < moduleName.length(); ++i) {
            char c = moduleName.charAt(i);
            if (c <= '\u007f' && ILLEGAL_CHARACTERS.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean checkVersion(Version module1version, Version module2version) throws AxisFault {
        if (module1version != null && !module1version.equals(module2version) || module2version != null && !module2version.equals(module1version)) {
            throw new AxisFault("trying to engage two different module versions " + module1version + " : " + module2version);
        }
        return true;
    }

    public static void calculateDefaultModuleVersion(HashMap modules, AxisConfiguration axisConfig) {
        Iterator allModules = modules.values().iterator();
        HashMap<String, Version> defaultModules = new HashMap<String, Version>();
        while (allModules.hasNext()) {
            AxisModule axisModule = (AxisModule)allModules.next();
            String name = axisModule.getName();
            Version currentDefaultVersion = (Version)defaultModules.get(name);
            Version version = axisModule.getVersion();
            if (currentDefaultVersion != null && (version == null || version.compareTo(currentDefaultVersion) <= 0)) continue;
            defaultModules.put(name, version);
        }
        Iterator def_mod_itr = defaultModules.keySet().iterator();
        while (def_mod_itr.hasNext()) {
            String moduleName;
            Version version = (Version)defaultModules.get(moduleName = (String)def_mod_itr.next());
            axisConfig.addDefaultModuleVersion(moduleName, version == null ? null : version.toString());
        }
    }

    public static boolean isExplicitlyTrue(MessageContext messageContext, String propertyName) {
        Object flag = messageContext.getProperty(propertyName);
        return JavaUtils.isTrueExplicitly(flag);
    }

    public static int getAxisSpecifMEPConstant(String messageExchangePattern) {
        int mepConstant = -1;
        if ("http://www.w3.org/ns/wsdl/in-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-out".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-out".equals(messageExchangePattern)) {
            mepConstant = 12;
        } else if ("http://www.w3.org/ns/wsdl/in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-only".equals(messageExchangePattern)) {
            mepConstant = 10;
        } else if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(messageExchangePattern)) {
            mepConstant = 13;
        } else if ("http://www.w3.org/ns/wsdl/out-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-in".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-in".equals(messageExchangePattern)) {
            mepConstant = 16;
        } else if ("http://www.w3.org/ns/wsdl/out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-only".equals(messageExchangePattern)) {
            mepConstant = 14;
        } else if ("http://www.w3.org/ns/wsdl/out-opt-in".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(messageExchangePattern)) {
            mepConstant = 17;
        } else if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(messageExchangePattern)) {
            mepConstant = 11;
        } else if ("http://www.w3.org/ns/wsdl/robust-out-only".equals(messageExchangePattern) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(messageExchangePattern) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(messageExchangePattern)) {
            mepConstant = 15;
        }
        if (mepConstant == -1) {
            throw new AxisError(Messages.getMessage("mepmappingerror"));
        }
        return mepConstant;
    }

    public static AxisFault getInboundFaultFromMessageContext(MessageContext messageContext) {
        AxisFault result = (AxisFault)messageContext.getProperty("inboundFaultOverride");
        if (result == null) {
            SOAPBody soapBody;
            SOAPEnvelope envelope = messageContext.getEnvelope();
            if (envelope != null && (soapBody = envelope.getBody()) != null) {
                SOAPFault soapFault = soapBody.getFault();
                if (soapFault != null) {
                    return new AxisFault(soapFault, messageContext);
                }
                if (messageContext.isDoingREST() && soapBody.getFirstElement() != null) {
                    return new AxisFault(((Object)soapBody.getFirstElement()).toString());
                }
            }
            throw new IllegalArgumentException("The MessageContext does not have an associated SOAPFault.");
        }
        return result;
    }

    public static ClassLoader getObjectClassLoader(final Object object) {
        if (object == null) {
            return null;
        }
        return (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return object.getClass().getClassLoader();
            }
        });
    }

    public static int getMtomThreshold(MessageContext msgCtxt) {
        int threshold;
        Integer value = null;
        if (!msgCtxt.isServerSide()) {
            value = (Integer)msgCtxt.getProperty("mtomThreshold");
        } else {
            Parameter param = msgCtxt.getParameter("mtomThreshold");
            if (param != null) {
                value = (Integer)param.getValue();
            }
        }
        int n = threshold = value != null ? value : 0;
        if (log.isDebugEnabled()) {
            log.debug("MTOM optimized Threshold value =" + threshold);
        }
        return threshold;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !Utils.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    public static String getIpAddress(AxisConfiguration axisConfiguration) throws SocketException {
        String hostAddress;
        Parameter param;
        if (axisConfiguration != null && (param = axisConfiguration.getParameter("hostname")) != null && (hostAddress = ((String)param.getValue()).trim()) != null) {
            return hostAddress;
        }
        return Utils.getIpAddress();
    }

    public static String getHostname(AxisConfiguration axisConfiguration) {
        String hostAddress;
        Parameter param;
        if (axisConfiguration != null && (param = axisConfiguration.getParameter("hostname")) != null && (hostAddress = ((String)param.getValue()).trim()) != null) {
            return hostAddress;
        }
        return null;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    public static String sanitizeWebOutput(String text) {
        text = text.replaceAll("<", "&lt;");
        return text;
    }
}

