/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;

public class SAMLTokenIssuerConfig
extends AbstractIssuerConfig {
    Log log = LogFactory.getLog(SAMLTokenIssuerConfig.class);
    public static final QName SAML_ISSUER_CONFIG = new QName("saml-issuer-config");
    private static final QName ISSUER_KEY_ALIAS = new QName("issuerKeyAlias");
    private static final QName ISSUER_KEY_PASSWD = new QName("issuerKeyPassword");
    private static final QName ATTR_CALLBACK_HANDLER_NAME = new QName("attrCallbackHandlerName");
    private static final QName TTL = new QName("timeToLive");
    private static final QName TRUSTED_SERVICES = new QName("trusted-services");
    private static final QName KEY_SIZE = new QName("keySize");
    private static final QName SERVICE = new QName("service");
    private static final QName ALIAS = new QName("alias");
    public static final QName USE_SAML_ATTRIBUTE_STATEMENT = new QName("useSAMLAttributeStatement");
    public static final QName ISSUER_NAME = new QName("issuerName");
    public static final QName SAML_CALLBACK_CLASS = new QName("dataCallbackHandlerClass");
    protected String issuerKeyAlias;
    protected String issuerKeyPassword;
    protected String issuerName;
    protected Map trustedServices = new HashMap();
    protected String trustStorePropFile;
    protected SAMLCallbackHandler callbackHandler;
    protected String callbackHandlerName;

    public SAMLTokenIssuerConfig(String issuerName, String cryptoProviderClassName, Properties cryptoProps) {
        this.issuerName = issuerName;
        this.setCryptoProperties(cryptoProviderClassName, cryptoProps);
    }

    public SAMLTokenIssuerConfig(String configFilePath) throws TrustException {
        StAXOMBuilder builder;
        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            builder = new StAXOMBuilder(fis);
        }
        catch (Exception e) {
            throw new TrustException("errorLoadingConfigFile", new String[]{configFilePath});
        }
        this.load(builder.getDocumentElement());
    }

    public SAMLTokenIssuerConfig(OMElement elem) throws TrustException {
        this.load(elem);
    }

    private void load(OMElement elem) throws TrustException {
        OMElement attrElemet;
        OMElement keySizeElem;
        OMElement ttlElem;
        OMElement keyCompElem;
        OMElement userElem;
        OMElement callbackNameElem;
        OMElement proofKeyElem = elem.getFirstChildWithName(PROOF_KEY_TYPE);
        if (proofKeyElem != null) {
            this.proofKeyType = proofKeyElem.getText().trim();
        }
        if ((callbackNameElem = elem.getFirstChildWithName(ATTR_CALLBACK_HANDLER_NAME)) != null) {
            this.callbackHandlerName = callbackNameElem.getText().trim();
        }
        if ((userElem = elem.getFirstChildWithName(ISSUER_KEY_ALIAS)) != null) {
            this.issuerKeyAlias = userElem.getText().trim();
        }
        if (this.issuerKeyAlias == null || "".equals(this.issuerKeyAlias)) {
            throw new TrustException("samlIssuerKeyAliasMissing");
        }
        OMElement issuerKeyPasswdElem = elem.getFirstChildWithName(ISSUER_KEY_PASSWD);
        if (issuerKeyPasswdElem != null) {
            this.issuerKeyPassword = issuerKeyPasswdElem.getText().trim();
        }
        if (this.issuerKeyPassword == null || "".equals(this.issuerKeyPassword)) {
            throw new TrustException("samlIssuerKeyPasswdMissing");
        }
        OMElement issuerNameElem = elem.getFirstChildWithName(ISSUER_NAME);
        if (issuerNameElem != null) {
            this.issuerName = issuerNameElem.getText().trim();
        }
        if (this.issuerName == null || "".equals(this.issuerName)) {
            throw new TrustException("samlIssuerNameMissing");
        }
        this.cryptoPropertiesElement = elem.getFirstChildWithName(CRYPTO_PROPERTIES);
        if (this.cryptoPropertiesElement != null && (this.cryptoElement = this.cryptoPropertiesElement.getFirstChildWithName(CRYPTO)) == null) {
            this.cryptoPropertiesFile = this.cryptoPropertiesElement.getText().trim();
        }
        if ((keyCompElem = elem.getFirstChildWithName(AbstractIssuerConfig.KeyComputation.KEY_COMPUTATION)) != null && keyCompElem.getText() != null && !"".equals(keyCompElem.getText())) {
            this.keyComputation = Integer.parseInt(keyCompElem.getText());
        }
        if ((ttlElem = elem.getFirstChildWithName(TTL)) != null) {
            try {
                this.ttl = Long.parseLong(ttlElem.getText().trim());
            }
            catch (NumberFormatException e) {
                throw new TrustException("invlidTTL");
            }
        }
        if ((keySizeElem = elem.getFirstChildWithName(KEY_SIZE)) != null) {
            try {
                this.keySize = Integer.parseInt(keySizeElem.getText().trim());
            }
            catch (NumberFormatException e) {
                throw new TrustException("invalidKeysize");
            }
        }
        this.addRequestedAttachedRef = elem.getFirstChildWithName(ADD_REQUESTED_ATTACHED_REF) != null;
        this.addRequestedUnattachedRef = elem.getFirstChildWithName(ADD_REQUESTED_UNATTACHED_REF) != null;
        OMElement trustedServices = elem.getFirstChildWithName(TRUSTED_SERVICES);
        if (trustedServices != null) {
            Iterator servicesIter = trustedServices.getChildrenWithName(SERVICE);
            while (servicesIter.hasNext()) {
                OMElement service = (OMElement)servicesIter.next();
                OMAttribute aliasAttr = service.getAttribute(ALIAS);
                if (aliasAttr == null) {
                    throw new TrustException("aliasMissingForService", new String[]{service.getText().trim()});
                }
                if (this.trustedServices == null) {
                    this.trustedServices = new HashMap();
                }
                this.trustedServices.put(service.getText().trim(), aliasAttr.getAttributeValue());
            }
        }
        if ((attrElemet = elem.getFirstChildWithName(SAML_CALLBACK_CLASS)) != null) {
            try {
                String value = attrElemet.getText();
                Class<?> handlerClass = Class.forName(value);
                this.callbackHandler = (SAMLCallbackHandler)handlerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.log.debug("Error loading class", e);
                throw new TrustException("Error loading class", e);
            }
            catch (InstantiationException e) {
                this.log.debug("Error instantiating class", e);
                throw new TrustException("Error instantiating class", e);
            }
            catch (IllegalAccessException e) {
                this.log.debug("Illegal Access", e);
                throw new TrustException("Illegal Access", e);
            }
        }
    }

    public Parameter getParameter() {
        Parameter param = new Parameter();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement paramElem = fac.createOMElement("Parameter", null);
        paramElem.addAttribute("name", SAML_ISSUER_CONFIG.getLocalPart(), null);
        OMElement configElem = fac.createOMElement(SAML_ISSUER_CONFIG, paramElem);
        OMElement issuerNameElem = fac.createOMElement(ISSUER_NAME, configElem);
        issuerNameElem.setText(this.issuerName);
        OMElement issuerKeyAliasElem = fac.createOMElement(ISSUER_KEY_ALIAS, configElem);
        issuerKeyAliasElem.setText(this.issuerKeyAlias);
        OMElement issuerKeyPasswd = fac.createOMElement(ISSUER_KEY_PASSWD, configElem);
        issuerKeyPasswd.setText(this.issuerKeyPassword);
        OMElement callbackHandlerName = fac.createOMElement(ATTR_CALLBACK_HANDLER_NAME, configElem);
        callbackHandlerName.setText(this.callbackHandlerName);
        OMElement timeToLive = fac.createOMElement(TTL, configElem);
        timeToLive.setText(String.valueOf(this.ttl));
        configElem.addChild(this.cryptoPropertiesElement);
        OMElement keySizeElem = fac.createOMElement(KEY_SIZE, configElem);
        keySizeElem.setText(Integer.toString(this.keySize));
        if (this.addRequestedAttachedRef) {
            fac.createOMElement(ADD_REQUESTED_ATTACHED_REF, configElem);
        }
        if (this.addRequestedUnattachedRef) {
            fac.createOMElement(ADD_REQUESTED_UNATTACHED_REF, configElem);
        }
        OMElement keyCompElem = fac.createOMElement(AbstractIssuerConfig.KeyComputation.KEY_COMPUTATION, configElem);
        keyCompElem.setText(Integer.toString(this.keyComputation));
        OMElement proofKeyTypeElem = fac.createOMElement(PROOF_KEY_TYPE, configElem);
        proofKeyTypeElem.setText(this.proofKeyType);
        OMElement trustedServicesElem = fac.createOMElement(TRUSTED_SERVICES, configElem);
        for (String service : this.trustedServices.keySet()) {
            OMElement serviceElem = fac.createOMElement(SERVICE, trustedServicesElem);
            serviceElem.setText(service);
            serviceElem.addAttribute("alias", (String)this.trustedServices.get(service), null);
        }
        param.setName(SAML_ISSUER_CONFIG.getLocalPart());
        param.setParameterElement(paramElem);
        param.setValue(paramElem);
        param.setParameterType(2);
        return param;
    }

    public void setIssuerKeyAlias(String issuerKeyAlias) {
        this.issuerKeyAlias = issuerKeyAlias;
    }

    public String getIssuerKeyAlias() {
        return this.issuerKeyAlias;
    }

    public void setIssuerKeyPassword(String issuerKeyPassword) {
        this.issuerKeyPassword = issuerKeyPassword;
    }

    public String getIssuerKeyPassword() {
        return this.issuerKeyPassword;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public void setTrustedServices(Map trustedServices) {
        this.trustedServices = trustedServices;
    }

    public void setTrustStorePropFile(String trustStorePropFile) {
        this.trustStorePropFile = trustStorePropFile;
    }

    public void addTrustedServiceEndpointAddress(String address, String alias) {
        this.trustedServices.put(address, alias);
    }

    public void setCryptoProperties(String providerClassName, Properties props) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.cryptoPropertiesElement = fac.createOMElement(CRYPTO_PROPERTIES);
        OMElement cryptoElem = fac.createOMElement(CRYPTO, this.cryptoPropertiesElement);
        cryptoElem.addAttribute(PROVIDER.getLocalPart(), providerClassName, null);
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String prop = (String)keys.nextElement();
            String value = (String)props.get(prop);
            OMElement propElem = fac.createOMElement(PROPERTY, cryptoElem);
            propElem.setText(value);
            propElem.addAttribute("name", prop, null);
        }
    }

    public Map getTrustedServices() {
        return this.trustedServices;
    }

    @Deprecated
    public SAMLCallbackHandler getCallbackHander() {
        return this.callbackHandler;
    }

    @Deprecated
    public void setCallbackHander(SAMLCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public SAMLCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(SAMLCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public String getCallbackHandlerName() {
        return this.callbackHandlerName;
    }

    public void setCallbackHandlerName(String callbackHandlerName) {
        this.callbackHandlerName = callbackHandlerName;
    }

    public X509Certificate getServiceCert(Crypto crypto, String serviceAddress) throws WSSecurityException {
        if (serviceAddress != null && !"".equals(serviceAddress)) {
            String alias = (String)this.trustedServices.get(serviceAddress);
            if (alias != null) {
                return crypto.getCertificates(alias)[0];
            }
            alias = (String)this.trustedServices.get("*");
            return crypto.getCertificates(alias)[0];
        }
        String alias = (String)this.trustedServices.get("*");
        return crypto.getCertificates(alias)[0];
    }
}

