/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.SecureRandom;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TokenIssuerUtil {
    public static final String ENCRYPTED_KEY = "EncryptedKey";
    public static final String BINARY_SECRET = "BinarySecret";

    public static byte[] getSharedSecret(RahasData data, int keyComputation, int keySize) throws TrustException {
        boolean reqEntrPresent = data.getRequestEntropy() != null;
        try {
            if (reqEntrPresent && keyComputation != 3) {
                if (keyComputation == 2) {
                    data.setResponseEntropy(WSSecurityUtil.generateNonce(keySize / 8));
                    P_SHA1 p_sha1 = new P_SHA1();
                    return p_sha1.createKey(data.getRequestEntropy(), data.getResponseEntropy(), 0, keySize / 8);
                }
                return data.getRequestEntropy();
            }
            return TokenIssuerUtil.generateEphemeralKey(keySize);
        }
        catch (WSSecurityException e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
        catch (ConversationException e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }

    public static void handleRequestedProofToken(RahasData data, int wstVersion, AbstractIssuerConfig config, OMElement rstrElem, Token token, Document doc) throws TrustException {
        OMElement reqProofTokElem = TrustUtil.createRequestedProofTokenElement(wstVersion, rstrElem);
        if (config.keyComputation == 2 && data.getRequestEntropy() != null) {
            OMElement respEntrElem = TrustUtil.createEntropyElement(wstVersion, rstrElem);
            String entr = Base64.encode(data.getResponseEntropy());
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, respEntrElem, "/Nonce");
            binSecElem.setText(entr);
            OMElement compKeyElem = TrustUtil.createComputedKeyElement(wstVersion, reqProofTokElem);
            compKeyElem.setText(data.getWstNs() + "/CK/PSHA1");
        } else if (ENCRYPTED_KEY.equals(config.proofKeyType)) {
            WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
            Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance(TrustUtil.toProperties(config.cryptoElement), data.getInMessageContext().getAxisService().getClassLoader()) : CryptoFactory.getInstance(config.cryptoPropertiesFile, data.getInMessageContext().getAxisService().getClassLoader());
            encrKeyBuilder.setKeyIdentifierType(8);
            try {
                encrKeyBuilder.setUseThisCert(data.getClientCert());
                encrKeyBuilder.prepare(doc, crypto);
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{data.getClientCert().getSubjectDN().getName()});
            }
            Element encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            Element bstElem = encrKeyBuilder.getBinarySecurityTokenElement();
            if (bstElem != null) {
                reqProofTokElem.addChild((OMElement)((Object)bstElem));
            }
            reqProofTokElem.addChild((OMElement)((Object)encryptedKeyElem));
            token.setSecret(encrKeyBuilder.getEphemeralKey());
        } else if (BINARY_SECRET.equals(config.proofKeyType)) {
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.keyComputation, config.keySize);
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, reqProofTokElem, null);
            binSecElem.setText(Base64.encode(secret));
            token.setSecret(secret);
        } else {
            throw new IllegalArgumentException(config.proofKeyType);
        }
    }

    private static byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }
}

