/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.impl.util.SAML2KeyInfo;
import org.apache.rahas.impl.util.SAML2Utils;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ServiceNonceCache;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.opensaml.SAMLAssertion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmationData;

public class RampartEngine {
    private static Log log = LogFactory.getLog(RampartEngine.class);
    private static Log tlog = LogFactory.getLog("org.apache.rampart.TIME");
    private static ServiceNonceCache serviceNonceCache = new ServiceNonceCache();

    public Vector process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        boolean doDebug = log.isDebugEnabled();
        boolean dotDebug = tlog.isDebugEnabled();
        if (doDebug) {
            log.debug("Enter process(MessageContext msgCtx)");
        }
        RampartMessageData rmd = new RampartMessageData(msgCtx, false);
        RampartPolicyData rpd = rmd.getPolicyData();
        msgCtx.setProperty("rampartPolicyData", rpd);
        RampartUtil.validateTransport(rmd);
        if (rpd == null) {
            return null;
        }
        if (this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            if (doDebug) {
                log.debug("Return process MessageContext msgCtx)");
            }
            return null;
        }
        Vector results = null;
        WSSecurityEngine engine = new WSSecurityEngine();
        ValidatorData data = new ValidatorData(rmd);
        SOAPHeader header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        ArrayList headerBlocks = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPHeaderBlock secHeader = null;
        if (headerBlocks != null) {
            for (SOAPHeaderBlock elem : headerBlocks) {
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        String actorValue = secHeader.getAttributeValue(new QName(rmd.getSoapConstants().getEnvelopeURI(), "actor"));
        Crypto signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        TokenCallbackHandler tokenCallbackHandler = new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        if (rpd.isSymmetricBinding()) {
            if (doDebug) {
                log.debug("Processing security header using SymetricBinding");
            }
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        } else {
            if (doDebug) {
                log.debug("Processing security header in normal path");
            }
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        for (int j = 0; j < results.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)results.get(j);
            Integer actInt = (Integer)wser.get("action");
            if (8 == actInt) {
                String id;
                Assertion assertion;
                if (wser.get("saml-assertion") instanceof Assertion) {
                    assertion = (Assertion)wser.get("saml-assertion");
                    id = assertion.getID();
                    Subject subject = assertion.getSubject();
                    Date dateOfCreation = null;
                    Date dateOfExpiration = null;
                    if (assertion.getConditions() != null) {
                        Conditions conditions = assertion.getConditions();
                        if (conditions.getNotBefore() != null) {
                            dateOfCreation = conditions.getNotBefore().toDate();
                        }
                        if (conditions.getNotOnOrAfter() != null) {
                            dateOfExpiration = conditions.getNotOnOrAfter().toDate();
                        }
                    } else {
                        SubjectConfirmationData scData = subject.getSubjectConfirmations().get(0).getSubjectConfirmationData();
                        if (scData.getNotBefore() != null) {
                            dateOfCreation = scData.getNotBefore().toDate();
                        }
                        if (scData.getNotOnOrAfter() != null) {
                            dateOfExpiration = scData.getNotOnOrAfter().toDate();
                        }
                    }
                    SAML2KeyInfo saml2KeyInfo = SAML2Utils.getSAML2KeyInfo(assertion, signatureCrypto, (CallbackHandler)tokenCallbackHandler);
                    try {
                        TokenStorage store = rmd.getTokenStorage();
                        if (store.getToken(id) != null) continue;
                        Token token = new Token(id, (OMElement)((Object)SAML2Utils.getElementFromAssertion(assertion)), dateOfCreation, dateOfExpiration);
                        token.setSecret(saml2KeyInfo.getSecret());
                        store.add(token);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RampartException("errorInAddingTokenIntoStore", e);
                    }
                }
                assertion = (SAMLAssertion)wser.get("saml-assertion");
                id = assertion.getId();
                Date created = assertion.getNotBefore();
                Date expires = assertion.getNotOnOrAfter();
                SAMLKeyInfo samlKi = SAMLUtil.getSAMLKeyInfo((SAMLAssertion)assertion, signatureCrypto, (CallbackHandler)tokenCallbackHandler);
                try {
                    TokenStorage store = rmd.getTokenStorage();
                    if (store.getToken(id) != null) continue;
                    Token token = new Token(id, (OMElement)((Object)assertion.toDOM()), created, expires);
                    token.setSecret(samlKi.getSecret());
                    store.add(token);
                    continue;
                }
                catch (Exception e) {
                    throw new RampartException("errorInAddingTokenIntoStore", e);
                }
            }
            if (1 == actInt) {
                String serviceEndpointName;
                boolean valueRepeating;
                WSUsernameTokenPrincipal userNameTokenPrincipal = (WSUsernameTokenPrincipal)wser.get("principal");
                String username = userNameTokenPrincipal.getName();
                msgCtx.setProperty("username", username);
                if (userNameTokenPrincipal.getNonce() == null) continue;
                int nonceLifeTimeInSeconds = 0;
                if (rpd.getRampartConfig() != null) {
                    String stringLifeTime = rpd.getRampartConfig().getNonceLifeTime();
                    try {
                        nonceLifeTimeInSeconds = Integer.parseInt(stringLifeTime);
                    }
                    catch (NumberFormatException e) {
                        log.error("Invalid value for nonceLifeTime in rampart configuration file.", e);
                        throw new RampartException("invalidNonceLifeTime", e);
                    }
                }
                if (valueRepeating = serviceNonceCache.isNonceRepeatingForService(serviceEndpointName = msgCtx.getAxisService().getEndpointName(), username, userNameTokenPrincipal.getNonce())) {
                    throw new RampartException("repeatingNonceValue", new Object[]{userNameTokenPrincipal.getNonce(), username});
                }
                serviceNonceCache.addNonceForService(serviceEndpointName, username, userNameTokenPrincipal.getNonce(), nonceLifeTimeInSeconds);
                continue;
            }
            if (2 != actInt) continue;
            X509Certificate cert = (X509Certificate)wser.get("x509-certificate");
            msgCtx.setProperty("X509Certificate", cert);
        }
        SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        PolicyValidatorCallbackHandler validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        validator.validate(data, results);
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            tlog.debug("processHeader by WSSecurityEngine took : " + (t1 - t0) + ", DOOM conversion took :" + (t2 - t1) + ", PolicyBasedResultsValidattor took " + (t3 - t2));
        }
        if (doDebug) {
            log.debug("Return process(MessageContext msgCtx)");
        }
        return results;
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFaultValue faultSubCodeValue;
        SOAPFaultSubCode faultSubCode;
        SOAPEnvelope soapEnvelope = rmd.getMsgContext().getEnvelope();
        SOAPFault soapFault = soapEnvelope.getBody().getFault();
        if (soapFault == null) {
            return false;
        }
        String soapVersionURI = rmd.getMsgContext().getEnvelope().getNamespace().getNamespaceURI();
        SOAPFaultCode faultCode = soapFault.getCode();
        if (faultCode == null) {
            return false;
        }
        return soapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/") ? faultCode.getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") : soapVersionURI.equals("http://www.w3.org/2003/05/soap-envelope") && (faultSubCode = faultCode.getSubCode()) != null && (faultSubCodeValue = faultSubCode.getValue()) != null && faultSubCodeValue.getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }
}

