/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.MessageBuilder;
import org.apache.rampart.RampartException;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityException;

public class RampartSender
implements Handler {
    private static Log mlog = LogFactory.getLog("org.apache.rampart.MESSAGE");
    private static HandlerDescription EMPTY_HANDLER_METADATA = new HandlerDescription("default Handler");
    private HandlerDescription handlerDesc = EMPTY_HANDLER_METADATA;

    public void cleanup() {
    }

    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isEngaged("rampart")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        MessageBuilder builder = new MessageBuilder();
        try {
            builder.build(msgContext);
        }
        catch (WSSecurityException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        catch (WSSPolicyException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        catch (RampartException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        if (mlog.isDebugEnabled()) {
            mlog.debug("*********************** RampartSender sent out \n" + msgContext.getEnvelope());
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.handlerDesc;
    }

    public String getName() {
        return "Apache Rampart outflow handler";
    }

    public Parameter getParameter(String name) {
        return this.handlerDesc.getParameter(name);
    }
}

