/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.basic;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.binding.ws.axis2.context.WSAxis2BindingContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;
import org.apache.tuscany.sca.policy.security.SecurityUtil;

public class BasicAuthenticationServicePolicyInterceptor
implements PhasedInterceptor {
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    public static final QName policySetQName = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "wsBasicAuthentication");
    private Invoker next;
    private PolicySet policySet = null;
    private String context;
    private BasicAuthenticationPolicy policy;

    public BasicAuthenticationServicePolicyInterceptor(String context, PolicySet policySet) {
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (PolicyExpression policyExpression : this.policySet.getPolicies()) {
                if (!(policyExpression.getPolicy() instanceof BasicAuthenticationPolicy)) continue;
                this.policy = (BasicAuthenticationPolicy)policyExpression.getPolicy();
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        WSAxis2BindingContext bindingContext = (WSAxis2BindingContext)msg.getBindingContext();
        MessageContext messageContext = bindingContext.getAxisInMessageContext();
        Map httpHeaderProperties = (Map)messageContext.getProperty("TRANSPORT_HEADERS");
        String basicAuthString = (String)httpHeaderProperties.get("Authorization");
        String decodedBasicAuthString = null;
        String username = null;
        String password = null;
        if (basicAuthString != null) {
            int collonIndex;
            if ((basicAuthString = basicAuthString.trim()).startsWith("Basic ")) {
                decodedBasicAuthString = new String(Base64Utils.decode(basicAuthString.substring(6)));
            }
            if ((collonIndex = decodedBasicAuthString.indexOf(58)) == -1) {
                username = decodedBasicAuthString;
            } else {
                username = decodedBasicAuthString.substring(0, collonIndex);
                password = decodedBasicAuthString.substring(collonIndex + 1);
            }
        }
        Subject subject = SecurityUtil.getSubject((Message)msg);
        BasicAuthenticationPrincipal principal = new BasicAuthenticationPrincipal(username, password);
        subject.getPrincipals().add((Principal)principal);
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public String getPhase() {
        return "service.binding.policy";
    }
}

