/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.axis2.context.WSAxis2BindingContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ReferenceBindingInvoker
implements Invoker {
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
    public static final QName QNAME_WSA_TO = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    public static final QName QNAME_WSA_ACTION = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
    public static final QName QNAME_WSA_RELATESTO = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo", "wsa");
    public static final QName QNAME_WSA_MESSAGEID = new QName("http://www.w3.org/2005/08/addressing", "MessageID", "wsa");
    private RuntimeEndpointReference endpointReference;
    private ServiceClient serviceClient;
    private QName wsdlOperationName;
    private Options options;
    private SOAPFactory soapFactory;
    private WebServiceBinding wsBinding;
    private static String WS_REF_PARMS = "WS_REFERENCE_PARAMETERS";
    private static String WS_MESSAGE_ID = "WS_MESSAGE_ID";
    protected static String SCA_CALLBACK_REL = "http://docs.oasis-open.org/opencsa/sca-bindings/ws/callback";

    public Axis2ReferenceBindingInvoker(RuntimeEndpointReference endpointReference, ServiceClient serviceClient, QName wsdlOperationName, Options options, SOAPFactory soapFactory, WebServiceBinding wsBinding) {
        this.endpointReference = endpointReference;
        this.serviceClient = serviceClient;
        this.wsdlOperationName = wsdlOperationName;
        this.options = options;
        this.soapFactory = soapFactory;
        this.wsBinding = wsBinding;
    }

    public Message invoke(Message msg) {
        try {
            OMElement operationResponseElement;
            OperationClient operationClient = this.createOperationClient(msg);
            WSAxis2BindingContext bindingContext = new WSAxis2BindingContext();
            bindingContext.setAxisOperationClient(operationClient);
            bindingContext.setAxisOutMessageContext(operationClient.getMessageContext("Out"));
            msg.setBindingContext((Object)bindingContext);
            msg = this.endpointReference.getBindingInvocationChain().getHeadInvoker().invoke(msg);
            if (this.wsBinding.isRpcLiteral() && (operationResponseElement = (OMElement)msg.getBody()) != null) {
                msg.setBody(operationResponseElement.getChildElements().next());
            }
        }
        catch (AxisFault e) {
            if (e.getDetail() != null) {
                FaultException f = new FaultException(e.getMessage(), (Object)e.getDetail(), (Throwable)e);
                f.setFaultName(e.getDetail().getQName());
                msg.setFaultBody((Object)f);
            } else {
                msg.setFaultBody((Object)e);
            }
        }
        catch (Throwable e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    protected OperationClient createOperationClient(Message msg) throws AxisFault {
        Endpoint callbackEndpoint;
        SOAPEnvelope env = this.soapFactory.getDefaultEnvelope();
        Object[] args = (Object[])msg.getBody();
        if (args != null && args.length > 0) {
            if (this.wsBinding.isRpcLiteral()) {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                String wrapperNamespace = null;
                if (this.wsBinding.getBinding() != null) {
                    block2: for (BindingOperation bOp : this.wsBinding.getBinding().getBindingOperations()) {
                        if (!bOp.getName().equals(msg.getOperation().getName())) continue;
                        for (Object ext : bOp.getBindingInput().getExtensibilityElements()) {
                            if (!(ext instanceof SOAPBody)) continue;
                            wrapperNamespace = ((SOAPBody)ext).getNamespaceURI();
                            break block2;
                        }
                    }
                }
                if (wrapperNamespace == null) {
                    wrapperNamespace = this.wsBinding.getUserSpecifiedWSDLDefinition().getNamespace();
                }
                QName operationQName = new QName(wrapperNamespace, msg.getOperation().getName());
                OMElement operationNameElement = factory.createOMElement(operationQName);
                for (Object bc : args) {
                    if (!(bc instanceof OMElement)) {
                        throw new IllegalArgumentException("Can't handle mixed payloads between OMElements and other types for endpoint reference " + this.endpointReference);
                    }
                    operationNameElement.addChild((OMElement)bc);
                }
                org.apache.axiom.soap.SOAPBody body = env.getBody();
                body.addChild(operationNameElement);
            } else {
                if (this.wsBinding.isRpcEncoded()) {
                    throw new ServiceRuntimeException("rpc/encoded WSDL style not supported for endpoint reference " + this.endpointReference);
                }
                if (this.wsBinding.isDocEncoded()) {
                    throw new ServiceRuntimeException("doc/encoded WSDL style not supported for endpoint reference " + this.endpointReference);
                }
                if (this.wsBinding.isDocLiteralWrapped() || this.wsBinding.isDocLiteralUnwrapped()) {
                    org.apache.axiom.soap.SOAPBody body = env.getBody();
                    for (Object bc : args) {
                        if (!(bc instanceof OMElement)) {
                            throw new IllegalArgumentException("Can't handle mixed payloads between OMElements and other types for endpoint reference " + this.endpointReference);
                        }
                        body.addChild((OMElement)bc);
                    }
                } else {
                    throw new ServiceRuntimeException("Unrecognized WSDL style for endpoint reference " + this.endpointReference);
                }
            }
        }
        final MessageContext requestMC = new MessageContext();
        requestMC.setEnvelope(env);
        final OperationClient operationClient = this.serviceClient.createClient(this.wsdlOperationName);
        operationClient.setOptions(this.options);
        AsyncResponseInvoker respInvoker = (AsyncResponseInvoker)msg.getHeaders().get("ASYNC_RESPONSE_INVOKER");
        if (respInvoker != null) {
            callbackEndpoint = this.createAsyncResponseEndpoint(msg, (AsyncResponseInvoker<String>)respInvoker);
            msg.setTo(callbackEndpoint);
        } else {
            callbackEndpoint = msg.getFrom().getCallbackEndpoint();
        }
        SOAPEnvelope sev = requestMC.getEnvelope();
        SOAPHeader sh = sev.getHeader();
        if (callbackEndpoint != null) {
            org.apache.axis2.addressing.EndpointReference fromEPR = null;
            fromEPR = callbackEndpoint.getBinding().getType().equals(SCABinding.TYPE) ? new org.apache.axis2.addressing.EndpointReference(callbackEndpoint.getURI()) : new org.apache.axis2.addressing.EndpointReference(callbackEndpoint.getBinding().getURI());
            this.addWSAFromHeader(sh, fromEPR);
            this.addWSAActionHeader(sh);
            this.addWSAMessageIDHeader(sh, (String)msg.getHeaders().get("MESSAGE_ID"));
            requestMC.setFrom(fromEPR);
        }
        String toAddress = this.getToAddress(msg);
        requestMC.setTo(new org.apache.axis2.addressing.EndpointReference(toAddress));
        if (this.isInvocationForCallback(msg)) {
            this.addWSAToHeader(sh, toAddress, msg);
            this.addWSAActionHeader(sh);
            this.addWSARelatesTo(sh, msg);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AxisFault {
                    operationClient.addMessageContext(requestMC);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)e.getException();
        }
        return operationClient;
    }

    private Endpoint createAsyncResponseEndpoint(Message msg, AsyncResponseInvoker<String> respInvoker) {
        String callbackAddress = (String)respInvoker.getResponseTargetAddress();
        if (callbackAddress == null) {
            return null;
        }
        ExtensionPointRegistry registry = this.endpointReference.getCompositeContext().getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        RuntimeAssemblyFactory assemblyFactory = (RuntimeAssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        WebServiceBindingFactory webServiceBindingFactory = (WebServiceBindingFactory)modelFactories.getFactory(WebServiceBindingFactory.class);
        RuntimeEndpoint callbackEndpoint = (RuntimeEndpoint)assemblyFactory.createEndpoint();
        WebServiceBinding cbBinding = webServiceBindingFactory.createWebServiceBinding();
        cbBinding.setURI(callbackAddress);
        callbackEndpoint.setBinding((Binding)cbBinding);
        callbackEndpoint.setURI(callbackAddress);
        callbackEndpoint.setUnresolved(true);
        return callbackEndpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getToAddress(Message msg) throws ServiceRuntimeException {
        String address = null;
        if (this.options.getTo() != null) return this.options.getTo().getAddress();
        Endpoint ep = msg.getTo();
        if (ep == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        if (ep.getBinding() == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        if (ep.getBinding().getURI() == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        if (ep.getBinding().getURI().length() <= 0) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        return ep.getBinding().getURI();
    }

    private void addWSAFromHeader(SOAPHeader sh, org.apache.axis2.addressing.EndpointReference fromEPR) throws AxisFault {
        OMElement epr = EndpointReferenceHelper.toOM(sh.getOMFactory(), fromEPR, QNAME_WSA_FROM, "http://www.w3.org/2005/08/addressing");
        sh.addChild(epr);
    }

    private void addWSAMessageIDHeader(SOAPHeader sh, String msgID) throws AxisFault {
        if (msgID == null) {
            return;
        }
        OMElement idHeader = sh.getOMFactory().createOMElement(QNAME_WSA_MESSAGEID);
        idHeader.setText(msgID);
        sh.addChild(idHeader);
    }

    private void addWSAToHeader(SOAPHeader sh, String address, Message msg) {
        if (address == null) {
            return;
        }
        OMElement wsaToOM = sh.getOMFactory().createOMElement(QNAME_WSA_TO);
        wsaToOM.setText(address);
        sh.addChild(wsaToOM);
        if (msg == null) {
            return;
        }
        OMElement refParms = (OMElement)msg.getHeaders().get(WS_REF_PARMS);
        if (refParms != null) {
            Iterator children = refParms.getChildElements();
            while (children.hasNext()) {
                OMElement child = (OMElement)children.next();
                OMNamespace wsaNamespace = sh.getOMFactory().createOMNamespace("http://www.w3.org/2005/08/addressing", "wsa");
                OMAttribute isRefParm = sh.getOMFactory().createOMAttribute("IsReferenceParameter", wsaNamespace, "true");
                child.addAttribute(isRefParm);
                sh.addChild(child);
            }
        }
    }

    private void addWSAActionHeader(SOAPHeader sh) {
        String action = this.options.getAction();
        if (action == null) {
            PortType portType = ((WSDLInterface)this.wsBinding.getBindingInterfaceContract().getInterface()).getPortType();
            Operation op = portType.getOperation(this.wsdlOperationName.getLocalPart(), null, null);
            action = WSDL11ActionHelper.getActionFromInputElement(this.wsBinding.getGeneratedWSDLDocument(), portType, op, op.getInput());
        }
        OMElement actionOM = sh.getOMFactory().createOMElement(QNAME_WSA_ACTION);
        actionOM.setText(action == null ? "" : action);
        sh.addChild(actionOM);
    }

    private void addWSARelatesTo(SOAPHeader sh, Message msg) {
        String idValue = (String)msg.getHeaders().get("RELATES_TO");
        if (idValue != null) {
            OMElement relatesToOM = sh.getOMFactory().createOMElement(QNAME_WSA_RELATESTO);
            OMAttribute relType = sh.getOMFactory().createOMAttribute("RelationshipType", null, SCA_CALLBACK_REL);
            relatesToOM.addAttribute(relType);
            relatesToOM.setText(idValue);
            sh.addChild(relatesToOM);
        }
    }

    private boolean isInvocationForCallback(Message msg) {
        ComponentReference ref;
        EndpointReference fromEPR = msg.getFrom();
        if (fromEPR != null && (ref = fromEPR.getReference()) != null) {
            return ref.isForCallback();
        }
        return false;
    }
}

