/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2BaseBindingProvider;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2BindingProviderFactory;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2EngineIntegration;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ReferenceBindingInvoker;
import org.apache.tuscany.sca.binding.ws.axis2.transport.TransportReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.util.PolicyHelper;
import org.apache.tuscany.sca.provider.EndpointReferenceProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ReferenceBindingProvider
extends Axis2BaseBindingProvider
implements EndpointReferenceProvider {
    private RuntimeEndpointReference endpointReference;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private WebServiceBinding wsBinding;
    private ServiceClient serviceClient;
    private AxisService axisClientSideService;

    public Axis2ReferenceBindingProvider(ExtensionPointRegistry extensionPoints, EndpointReference endpointReference) {
        super(extensionPoints);
        Binding binding;
        Definition def;
        this.endpointReference = (RuntimeEndpointReference)endpointReference;
        this.wsBinding = (WebServiceBinding)endpointReference.getBinding();
        this.component = (RuntimeComponent)endpointReference.getComponent();
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        if (this.wsBinding.getGeneratedWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + this.component.getName() + "/" + this.reference.getName());
        }
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        if (contract.getInterface() != null) {
            contract.getInterface().resetDataBinding(OMElement.class.getName());
        }
        this.isSOAP11Required = PolicyHelper.isIntentRequired((PolicySubject)((PolicySubject)this.wsBinding), (QName)Constants.SOAP11_INTENT);
        this.isSOAP12Required = PolicyHelper.isIntentRequired((PolicySubject)((PolicySubject)this.wsBinding), (QName)Constants.SOAP12_INTENT);
        this.isMTOMRequired = PolicyHelper.isIntentRequired((PolicySubject)((PolicySubject)this.wsBinding), (QName)Axis2BindingProviderFactory.MTOM_INTENT);
        QName wsPolicyQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        if (PolicyHelper.getPolicies((PolicySubject)endpointReference, (QName)wsPolicyQName).size() > 0) {
            this.isRampartRequired = true;
        }
        if (this.wsBinding.isRpcEncoded()) {
            throw new ServiceRuntimeException("rpc/encoded WSDL style not supported. Component " + endpointReference.getComponent().getName() + " Reference " + endpointReference.getReference() + " Binding " + endpointReference.getBinding().getName());
        }
        if (this.wsBinding.isDocEncoded()) {
            throw new ServiceRuntimeException("doc/encoded WSDL style not supported. Component " + endpointReference.getComponent().getName() + " Reference " + endpointReference.getReference() + " Binding " + endpointReference.getBinding().getName());
        }
        if (this.wsBinding.isDocLiteralUnwrapped()) {
            // empty if block
        }
        if (this.isSOAP11Required && this.wsBinding.getBinding() != null) {
            def = this.wsBinding.getGeneratedWSDLDocument();
            binding = def.getBinding(this.wsBinding.getBinding().getQName());
            for (Object ext : binding.getExtensibilityElements()) {
                if (!(ext instanceof SOAP12Binding)) continue;
                throw new ServiceRuntimeException("WSDL document is using SOAP v1.2 but SOAP v1.1 is required by the specified policy intents");
            }
        }
        if (this.isSOAP12Required && this.wsBinding.getBinding() != null) {
            def = this.wsBinding.getGeneratedWSDLDocument();
            binding = def.getBinding(this.wsBinding.getBinding().getQName());
            for (Object ext : binding.getExtensibilityElements()) {
                if (!(ext instanceof SOAPBinding)) continue;
                throw new ServiceRuntimeException("WSDL document is using SOAP v1.1 but SOAP v1.2 is required by the specified policy intents");
            }
        }
    }

    public void start() {
        this.configContext = Axis2EngineIntegration.getAxisConfigurationContext(this.extensionPoints.getServiceDiscovery());
        if (this.isRampartRequired) {
            Axis2EngineIntegration.loadRampartModule(this.configContext);
        }
        for (PolicyProvider pp : this.endpointReference.getPolicyProviders()) {
            pp.configureBinding((Object)this);
        }
        try {
            Definition definition = this.wsBinding.getGeneratedWSDLDocument();
            QName serviceQName = this.wsBinding.getService().getQName();
            Port port = this.wsBinding.getPort();
            if (port == null) {
                Collection ports = this.wsBinding.getService().getPorts().values();
                for (Port p : ports) {
                    if (!(p.getExtensibilityElements().get(0) instanceof SOAPAddress)) continue;
                    port = p;
                    break;
                }
                if (port == null) {
                    for (Port p : ports) {
                        if (!(p.getExtensibilityElements().get(0) instanceof SOAP12Address)) continue;
                        port = p;
                        break;
                    }
                }
            }
            this.axisClientSideService = Axis2EngineIntegration.createClientSideAxisService(definition, serviceQName, port.getName(), new Options());
            HttpClient httpClient = (HttpClient)this.configContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
                connectionManagerParams.setDefaultMaxConnectionsPerHost(2);
                connectionManagerParams.setTcpNoDelay(true);
                connectionManagerParams.setStaleCheckingEnabled(true);
                connectionManagerParams.setLinger(0);
                connectionManager.setParams(connectionManagerParams);
                httpClient = new HttpClient(connectionManager);
                this.configContext.setThreadPool(new ThreadPool(1, 5));
                this.configContext.setProperty("REUSE_HTTP_CLIENT", Boolean.TRUE);
                this.configContext.setProperty("CACHED_HTTP_CLIENT", httpClient);
            }
            this.serviceClient = new ServiceClient(this.configContext, this.axisClientSideService);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.serviceClient != null) {
            HttpClient httpClient = (HttpClient)this.serviceClient.getServiceContext().getConfigurationContext().getProperty("CACHED_HTTP_CLIENT");
            if (httpClient != null) {
                ((MultiThreadedHttpConnectionManager)httpClient.getHttpConnectionManager()).shutdown();
            }
            this.serviceClient = null;
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public Invoker createInvoker(Operation operation) {
        Options options = new Options();
        org.apache.axis2.addressing.EndpointReference epTo = this.getWSATOEPR(this.wsBinding);
        if (epTo != null) {
            options.setTo(epTo);
        }
        options.setProperty("__CHUNKED__", Boolean.FALSE);
        String operationName = operation.getName();
        String soapAction = this.getSOAPAction(operationName);
        if (soapAction != null && soapAction.length() > 1) {
            options.setAction(soapAction);
        }
        options.setTimeOutInMilliSeconds(30000L);
        SOAPFactory soapFactory = AccessController.doPrivileged(new PrivilegedAction<SOAPFactory>(){

            @Override
            public SOAPFactory run() {
                if (Axis2ReferenceBindingProvider.this.isSOAP12Required) {
                    return OMAbstractFactory.getSOAP12Factory();
                }
                return OMAbstractFactory.getSOAP11Factory();
            }
        });
        QName wsdlOperationQName = new QName(operationName);
        if (this.isMTOMRequired) {
            options.setProperty("enableMTOM", "true");
        }
        return new Axis2ReferenceBindingInvoker(this.endpointReference, this.serviceClient, wsdlOperationQName, options, soapFactory, this.wsBinding);
    }

    public void configure() {
        InvocationChain bindingChain = this.endpointReference.getBindingInvocationChain();
        bindingChain.addInterceptor("reference.binding.transport", (Interceptor)new TransportReferenceInterceptor());
    }

    protected org.apache.axis2.addressing.EndpointReference getWSATOEPR(WebServiceBinding binding) {
        org.apache.axis2.addressing.EndpointReference bindingEPR;
        org.apache.axis2.addressing.EndpointReference epr = this.getEPR(binding);
        if (epr == null) {
            epr = this.getPortLocationEPR(binding);
        } else if ((epr.getAddress() == null || epr.getAddress().length() < 1) && (bindingEPR = this.getPortLocationEPR(binding)) != null) {
            epr.setAddress(bindingEPR.getAddress());
        }
        return epr;
    }

    protected org.apache.axis2.addressing.EndpointReference getPortLocationEPR(WebServiceBinding binding) {
        String ep = null;
        if (binding.getPort() != null) {
            List wsdlPortExtensions = binding.getPort().getExtensibilityElements();
            for (Object extension : wsdlPortExtensions) {
                if (extension instanceof SOAPAddress) {
                    ep = ((SOAPAddress)extension).getLocationURI();
                    break;
                }
                if (!(extension instanceof SOAP12Address)) continue;
                SOAP12Address address = (SOAP12Address)extension;
                ep = address.getLocationURI();
                break;
            }
        }
        if (ep == null || ep.equals("")) {
            ep = binding.getURI();
        }
        return ep == null || "".equals(ep) ? null : new org.apache.axis2.addressing.EndpointReference(ep);
    }

    protected org.apache.axis2.addressing.EndpointReference getEPR(WebServiceBinding wsBinding) {
        if (wsBinding.getEndPointReference() == null) {
            return null;
        }
        try {
            DOMSource domSource = new DOMSource(wsBinding.getEndPointReference());
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(domSource);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            org.apache.axis2.addressing.EndpointReference epr = EndpointReferenceHelper.fromOM(omElement);
            return epr;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    protected String getSOAPAction(String operationName) {
        Binding binding = this.wsBinding.getBinding();
        if (binding != null) {
            for (Object o : binding.getBindingOperations()) {
                BindingOperation bop = (BindingOperation)o;
                if (!bop.getName().equalsIgnoreCase(operationName)) continue;
                for (Object o2 : bop.getExtensibilityElements()) {
                    if (!(o2 instanceof SOAPOperation)) continue;
                    return ((SOAPOperation)o2).getSoapActionURI();
                }
            }
        }
        return null;
    }
}

