/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.policy.mtom.Axis2MTOMPolicyProvider;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2BaseBindingProvider;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2BindingProviderFactory;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2EngineIntegration;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ServiceBindingResponseInterceptor;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2ServiceServlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.util.PolicyHelper;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ServiceBindingProvider
extends Axis2BaseBindingProvider
implements EndpointProvider {
    private static final Logger logger = Logger.getLogger(Axis2ServiceBindingProvider.class.getName());
    private AssemblyFactory assemblyFactory;
    private ServletHost servletHost;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;
    private Port wsdlPort;
    private String endpointURI;
    private String deployedURI;
    private InterfaceContract contract;
    private static final String DEFAULT_QUEUE_CONNECTION_FACTORY = "TuscanyQueueConnectionFactory";

    public Axis2ServiceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint, ServletHost servletHost) {
        super(extensionPoints);
        this.extensionPoints = extensionPoints;
        this.endpoint = endpoint;
        this.servletHost = servletHost;
        this.assemblyFactory = (RuntimeAssemblyFactory)this.modelFactories.getFactory(AssemblyFactory.class);
        this.wsBinding = (WebServiceBinding)endpoint.getBinding();
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        if (this.wsBinding.getGeneratedWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + this.component.getName() + "/" + this.service.getName());
        }
        this.contract = this.wsBinding.getBindingInterfaceContract();
        this.contract.getInterface().resetDataBinding(OMElement.class.getName());
        this.configContext = Axis2EngineIntegration.getAxisConfigurationContext(extensionPoints.getServiceDiscovery());
        this.configContext.setContextRoot(servletHost.getContextPath());
        this.isSOAP12Required = PolicyHelper.isIntentRequired((PolicySubject)((PolicySubject)this.wsBinding), (QName)Constants.SOAP12_INTENT);
        this.isMTOMRequired = PolicyHelper.isIntentRequired((PolicySubject)((PolicySubject)this.wsBinding), (QName)Axis2BindingProviderFactory.MTOM_INTENT);
        QName wsPolicyQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
        if (PolicyHelper.getPolicies((PolicySubject)endpoint, (QName)wsPolicyQName).size() > 0) {
            this.isRampartRequired = true;
        }
        this.wsdlPort = (Port)this.wsBinding.getService().getPorts().values().iterator().next();
        if (this.wsdlPort == null) {
            throw new ServiceRuntimeException("No WSDL port for ws binding of " + this.component.getName() + "/" + this.service.getName());
        }
        this.endpointURI = Axis2EngineIntegration.getPortAddress(this.wsdlPort);
        if (this.endpointURI.startsWith("jms:")) {
            this.deployedURI = this.endpointURI;
            this.isJMSRequired = true;
        } else {
            if (servletHost == null) {
                throw new ServiceRuntimeException("No Servlet host is avaible for HTTP web services");
            }
            this.deployedURI = servletHost.getURLMapping(this.endpointURI, this.httpSecurityContext).toString();
        }
        Axis2EngineIntegration.setPortAddress(this.wsdlPort, this.deployedURI);
        if (this.isRampartRequired) {
            Axis2EngineIntegration.loadRampartModule(this.configContext);
        }
        if (this.isMTOMRequired) {
            new Axis2MTOMPolicyProvider((PolicySubject)endpoint).configureBinding(this.configContext);
        }
        if (this.isJMSRequired) {
            // empty if block
        }
        this.wsBinding.setURI(this.deployedURI);
        if (this.wsBinding.isRpcEncoded()) {
            throw new ServiceRuntimeException("rpc/encoded WSDL style not supported.  Component " + endpoint.getComponent().getName() + " Service " + endpoint.getService() + " Binding " + endpoint.getBinding().getName());
        }
        if (this.wsBinding.isDocEncoded()) {
            throw new ServiceRuntimeException("doc/encoded WSDL style not supported.  Component " + endpoint.getComponent().getName() + " Service " + endpoint.getService() + " Binding " + endpoint.getBinding().getName());
        }
    }

    public void start() {
        try {
            this.createAxisService(this.deployedURI, this.wsdlPort);
            for (PolicyProvider pp : this.endpoint.getPolicyProviders()) {
                pp.configureBinding((Object)this);
            }
            if (this.deployedURI.startsWith("http://") || this.deployedURI.startsWith("https://") || this.deployedURI.startsWith("/")) {
                Axis2ServiceServlet servlet = new Axis2ServiceServlet();
                servlet.init(this.configContext);
                this.deployedURI = this.httpSecurityContext.isSSLEnabled() ? this.servletHost.addServletMapping(this.endpointURI, (Servlet)servlet, this.httpSecurityContext) : this.servletHost.addServletMapping(this.endpointURI, (Servlet)servlet);
            }
            this.endpoint.setDeployedURI(this.deployedURI);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.servletHost.removeServletMapping(this.endpointURI);
            this.servletHost = null;
            URI uriPath = new URI(this.deployedURI);
            String stringURIPath = uriPath.getPath();
            this.configContext.getAxisConfiguration().removeService(stringURIPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public void configure() {
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        bindingChain.addInterceptor("service.binding.policy", (Interceptor)new Axis2ServiceBindingResponseInterceptor(this.endpoint));
    }

    private void createAxisService(String endpointURL, Port port) throws AxisFault {
        AxisService axisService = this.wsBinding.getGeneratedWSDLDocument() != null ? Axis2EngineIntegration.createWSDLAxisService(endpointURL, port, this.wsBinding) : Axis2EngineIntegration.createJavaAxisService(endpointURL, this.configContext, (AbstractContract)this.service);
        Axis2EngineIntegration.createAxisServiceProviders(axisService, this.endpoint, this.wsBinding, this.extensionPoints);
        this.configContext.getAxisConfiguration().addService(axisService);
    }
}

