/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.context.WSAxis2BindingContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class Axis2ServiceBindingResponseInterceptor
implements PhasedInterceptor {
    private Invoker next;
    private RuntimeEndpoint endpoint;
    private WebServiceBinding wsBinding;

    public Axis2ServiceBindingResponseInterceptor(RuntimeEndpoint endpoint) {
        this.endpoint = endpoint;
        this.wsBinding = (WebServiceBinding)endpoint.getBinding();
    }

    public Message invoke(Message msg) {
        Message response = this.getNext().invoke(msg);
        WSAxis2BindingContext bindingContext = (WSAxis2BindingContext)msg.getBindingContext();
        MessageContext responseMC = bindingContext.getAxisOutMessageContext();
        if (!response.isFault()) {
            OMElement responseOM = (OMElement)response.getBody();
            if (this.wsBinding.isRpcLiteral()) {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                String wrapperNamespace = null;
                if (this.wsBinding.getBinding() != null) {
                    block0: for (BindingOperation bOp : this.wsBinding.getBinding().getBindingOperations()) {
                        if (!bOp.getName().equals(msg.getOperation().getName())) continue;
                        for (Object ext : bOp.getBindingOutput().getExtensibilityElements()) {
                            if (!(ext instanceof SOAPBody)) continue;
                            wrapperNamespace = ((SOAPBody)ext).getNamespaceURI();
                            break block0;
                        }
                    }
                }
                if (wrapperNamespace == null) {
                    wrapperNamespace = this.wsBinding.getUserSpecifiedWSDLDefinition().getNamespace();
                }
                QName operationResponseQName = new QName(wrapperNamespace, msg.getOperation().getName() + "Response");
                OMElement operationResponseElement = factory.createOMElement(operationResponseQName);
                operationResponseElement.addChild(responseOM);
                responseOM = operationResponseElement;
            }
            if (null != responseOM) {
                responseMC.getEnvelope().getBody().addChild(responseOM);
            }
        }
        return response;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public String getPhase() {
        return "service.binding.policy";
    }
}

