/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.axiom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.axiom.AxiomDataBinding;
import org.apache.tuscany.sca.databinding.axiom.AxiomHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class OMElementWrapperHandler
implements WrapperHandler<OMElement> {
    private static final Logger logger = Logger.getLogger(OMElementWrapperHandler.class.getName());
    private OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final QName XSI_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");

    public OMElement create(Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        OMElement wrapper = AxiomHelper.createOMElement(this.factory, element.getQName());
        return wrapper;
    }

    public void setChildren(OMElement wrapper, Object[] childObjects, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        List childElements = input ? inputWrapperInfo.getChildElements() : outputWrapperInfo.getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            this.setChild(wrapper, i, (ElementInfo)childElements.get(i), childObjects[i]);
        }
    }

    public void setChild(OMElement wrapper, int i, ElementInfo childElement, Object value) {
        if (childElement.isMany()) {
            Object[] elements = (Object[])value;
            if (value != null) {
                for (Object e : elements) {
                    this.addChild(wrapper, childElement, (OMElement)e);
                }
            }
        } else {
            OMElement element = (OMElement)value;
            this.addChild(wrapper, childElement, element);
        }
    }

    private void addChild(OMElement wrapper, ElementInfo childElement, OMElement element) {
        if (element == null) {
            if (childElement.isNillable()) {
                OMElement e = wrapper.getOMFactory().createOMElement(childElement.getQName(), wrapper);
                this.attachXSINil(e);
            }
            return;
        }
        QName elementName = childElement.getQName();
        if (!elementName.equals(element.getQName())) {
            OMNamespace namespace = this.factory.createOMNamespace(elementName.getNamespaceURI(), elementName.getPrefix());
            element.setNamespace(namespace);
            element.setLocalName(childElement.getQName().getLocalPart());
        }
        wrapper.addChild(element);
    }

    public List getChildren(OMElement wrapper, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        List childElements = input ? inputWrapperInfo.getChildElements() : outputWrapperInfo.getChildElements();
        List<List<OMElement>> groupedElements = this.getElements(wrapper);
        List<Object> children = null;
        try {
            children = this.getValidChildren(groupedElements, childElements);
        }
        catch (InvalidChildException e) {
            children = this.getInvalidChildren(groupedElements, childElements);
        }
        return children;
    }

    private List<Object> getValidChildren(List<List<OMElement>> groupedElementList, List<ElementInfo> elementInfoList) throws InvalidChildException {
        ArrayList<Object> elements = new ArrayList<Object>();
        Iterator<List<OMElement>> groupedElementListIter = groupedElementList.iterator();
        List<OMElement> currentElemGroup = null;
        QName currentPayloadElemQName = null;
        int currentPayloadElemGroupSize = 0;
        QName currentElementInfoQName = null;
        boolean first = true;
        boolean lookAtNextElementGroup = true;
        boolean matchedLastElementGroup = false;
        for (ElementInfo currentElementInfo : elementInfoList) {
            String logMsg;
            currentElementInfoQName = currentElementInfo.getQName();
            logger.fine("Iterating to next ElementInfo child with QName: " + currentElementInfoQName + ". Control variables lookAtNextElementGroup = " + lookAtNextElementGroup + ", matchedLastElementGroup = " + matchedLastElementGroup);
            if (first || lookAtNextElementGroup) {
                first = false;
                currentElemGroup = groupedElementListIter.next();
                matchedLastElementGroup = false;
                currentPayloadElemGroupSize = currentElemGroup.size();
                if (currentPayloadElemGroupSize < 1) {
                    logMsg = "Not sure how this would occur based on getElements() impl, but give the other routine a chance to happen to work.";
                    logger.fine(logMsg);
                    throw new InvalidChildException(logMsg);
                }
                currentPayloadElemQName = currentElemGroup.get(0).getQName();
                logger.fine("Iterating to next payload element group with QName: " + currentPayloadElemQName);
            }
            if (currentElementInfoQName.equals(currentPayloadElemQName)) {
                logger.fine("Matched payload to child ElementInfo for QName: " + currentElementInfoQName);
                matchedLastElementGroup = true;
                if (currentElementInfo.isMany()) {
                    logger.fine("ElementInfo 'isMany' = true, and group size = " + currentPayloadElemGroupSize);
                    Iterator<OMElement> likeElemIterator = currentElemGroup.iterator();
                    ArrayList<OMElement> likeTypedElements = new ArrayList<OMElement>();
                    while (likeElemIterator.hasNext()) {
                        OMElement child = likeElemIterator.next();
                        this.attachXSIType(currentElementInfo, child);
                        likeTypedElements.add(child);
                    }
                    elements.add(likeTypedElements.toArray());
                } else {
                    if (currentPayloadElemGroupSize != 1) {
                        logMsg = "Detected invalid data.  Group size = " + currentPayloadElemGroupSize + " but 'isMany' = false";
                        logger.fine(logMsg);
                        throw new InvalidChildException(logMsg);
                    }
                    logger.fine("Single element.");
                    OMElement child = currentElemGroup.get(0);
                    this.attachXSIType(currentElementInfo, child);
                    elements.add(child);
                }
                lookAtNextElementGroup = true;
                continue;
            }
            logger.fine("Did not match payload QName: " + currentPayloadElemQName + ", with child ElementInfo for QName: " + currentElementInfoQName);
            if (!currentElementInfo.isOmissible()) {
                logMsg = "Detected invalid data. Child ElementInfo 'isOmissible' = false.";
                logger.fine(logMsg);
                throw new InvalidChildException(logMsg);
            }
            logger.fine("Child ElementInfo 'isOmissible' = true, so look at next ElementInfo.");
            elements.add(null);
            lookAtNextElementGroup = false;
        }
        if (!matchedLastElementGroup || groupedElementListIter.hasNext()) {
            String logMsg = "Exhausted list of ElementInfo children without matching payload element group with QName: " + currentPayloadElemQName;
            logger.fine(logMsg);
            throw new InvalidChildException(logMsg);
        }
        return elements;
    }

    private List<Object> getInvalidChildren(List<List<OMElement>> groupedElementList, List<ElementInfo> childElements) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        if (childElements.size() == 0) {
            return retVal;
        }
        for (int index = 0; index < groupedElementList.size(); ++index) {
            Object[] array;
            List<OMElement> elements = groupedElementList.get(index);
            ElementInfo childElement = childElements.get(index);
            if (!childElement.isMany()) {
                OMElement next = elements.isEmpty() ? null : this.attachXSIType(childElement, elements.get(0));
                retVal.add(next);
                continue;
            }
            for (Object item : array = elements.toArray()) {
                this.attachXSIType(childElement, (OMElement)item);
            }
            retVal.add(array);
        }
        return retVal;
    }

    public DataType getWrapperType(Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        DataTypeImpl wrapperType = new DataTypeImpl(AxiomDataBinding.NAME, OMElement.class, (Object)new XMLType(element));
        return wrapperType;
    }

    public boolean isInstance(Object wrapperObj, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        OMElement wrapper = (OMElement)wrapperObj;
        return element.getQName().equals(wrapper.getQName());
    }

    private List<List<OMElement>> getElements(OMElement wrapper) {
        ArrayList<List<OMElement>> elements = new ArrayList<List<OMElement>>();
        ArrayList<OMElement> current = new ArrayList<OMElement>();
        elements.add(current);
        boolean first = true;
        QName last = null;
        Iterator i = wrapper.getChildElements();
        while (i.hasNext()) {
            OMElement element = (OMElement)i.next();
            if (first || element.getQName().equals(last)) {
                current.add(element);
                last = element.getQName();
            } else {
                current = new ArrayList();
                elements.add(current);
                current.add(element);
                last = element.getQName();
            }
            first = false;
        }
        return elements;
    }

    private OMElement attachXSIType(ElementInfo childElement, OMElement element) {
        OMAttribute attr;
        TypeInfo type = childElement.getType();
        if (type != null && type.getQName() != null && (attr = element.getAttribute(XSI_TYPE_QNAME)) == null) {
            String typeNS = type.getQName().getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(typeNS)) {
                return element;
            }
            OMNamespace ns = element.getOMFactory().createOMNamespace(typeNS, "_typens_");
            element.declareNamespace(ns);
            OMNamespace xsiNS = element.getOMFactory().createOMNamespace(XSI_TYPE_QNAME.getNamespaceURI(), XSI_TYPE_QNAME.getPrefix());
            element.declareNamespace(xsiNS);
            attr = element.getOMFactory().createOMAttribute("type", xsiNS, "_typens_:" + type.getQName().getLocalPart());
            element.addAttribute(attr);
        }
        return element;
    }

    private void attachXSINil(OMElement element) {
        OMNamespace xsiNS = element.getOMFactory().createOMNamespace(XSI_TYPE_QNAME.getNamespaceURI(), XSI_TYPE_QNAME.getPrefix());
        element.declareNamespace(xsiNS);
        OMAttribute attr = element.getOMFactory().createOMAttribute("nil", xsiNS, "true");
        element.addAttribute(attr);
    }

    private class InvalidChildException
    extends Exception {
        private static final long serialVersionUID = 4858608999124013014L;

        public InvalidChildException() {
        }

        public InvalidChildException(String message) {
            super(message);
        }
    }
}

