/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;

public class JAXBDataSource
implements OMDataSource {
    private JAXBContext context;
    private Object element;
    private JAXBContextHelper contextHelper;

    public JAXBDataSource(Object element, JAXBContext context, JAXBContextHelper contextHelper) {
        this.element = element;
        this.context = context;
        this.contextHelper = contextHelper;
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        this.serialize(writer, new OMOutputFormat());
        StringReader reader = new StringReader(writer.toString());
        return StAXUtils.createXMLStreamReader(reader);
    }

    @Override
    public void serialize(final XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.contextHelper.getMarshaller(JAXBDataSource.this.context);
                        marshaller.marshal(JAXBDataSource.this.element, xmlWriter);
                    }
                    finally {
                        JAXBDataSource.this.contextHelper.releaseJAXBMarshaller(JAXBDataSource.this.context, marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    @Override
    public void serialize(final OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.contextHelper.getMarshaller(JAXBDataSource.this.context);
                        marshaller.marshal(JAXBDataSource.this.element, output);
                    }
                    finally {
                        JAXBDataSource.this.contextHelper.releaseJAXBMarshaller(JAXBDataSource.this.context, marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    @Override
    public void serialize(final Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Marshaller marshaller = null;
                    try {
                        marshaller = JAXBDataSource.this.contextHelper.getMarshaller(JAXBDataSource.this.context);
                        marshaller.marshal(JAXBDataSource.this.element, writer);
                    }
                    finally {
                        JAXBDataSource.this.contextHelper.releaseJAXBMarshaller(JAXBDataSource.this.context, marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public Object getObject() {
        return this.element;
    }
}

