/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom.ext;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.util.StAXUtils;

public class XMLStringDataSource
extends OMDataSourceExtBase {
    private String data;

    public XMLStringDataSource(String data) {
        this.data = data;
    }

    @Override
    public void close() {
    }

    @Override
    public OMDataSourceExt copy() {
        return new XMLStringDataSource(this.data);
    }

    @Override
    public Object getObject() {
        return this.data;
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        StringReader reader = new StringReader(this.data);
        return StAXUtils.createXMLStreamReader(reader);
    }

    @Override
    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            writer.write(this.data);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        return this.data.getBytes(encoding);
    }

    @Override
    public boolean isDestructiveRead() {
        return false;
    }

    @Override
    public boolean isDestructiveWrite() {
        return false;
    }
}

