/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.wspolicy;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Policy;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.wspolicy.WSPolicy;

public class WSPolicyBuilder
implements PolicyBuilder<Policy> {
    public boolean build(Endpoint endpoint, BuilderContext context) {
        List<WSPolicy> polices = this.getPolicies((PolicySubject)endpoint);
        System.out.println(endpoint + ": " + polices);
        return true;
    }

    public boolean build(EndpointReference endpointReference, BuilderContext context) {
        List<WSPolicy> polices = this.getPolicies((PolicySubject)endpointReference);
        System.out.println(endpointReference + ": " + polices);
        return true;
    }

    public boolean build(Component component, Implementation implementation, BuilderContext context) {
        List<WSPolicy> polices = this.getPolicies((PolicySubject)implementation);
        System.out.println(implementation + ": " + polices);
        return true;
    }

    public QName getPolicyType() {
        return WSPolicy.WS_POLICY_QNAME;
    }

    public List<QName> getSupportedBindings() {
        return null;
    }

    public boolean build(EndpointReference endpointReference, Endpoint endpoint, BuilderContext context) {
        for (PolicySet eprPolicySet : endpointReference.getPolicySets()) {
            for (PolicySet epPolicySet : endpoint.getPolicySets()) {
                if (this.build(eprPolicySet, epPolicySet)) continue;
                return false;
            }
        }
        for (PolicySet epPolicySet : endpoint.getPolicySets()) {
            for (PolicySet eprPolicySet : endpointReference.getPolicySets()) {
                if (this.build(epPolicySet, eprPolicySet)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean build(PolicySet policySet1, PolicySet policySet2) {
        ArrayList<PolicyExpression> policyExpressions1 = new ArrayList<PolicyExpression>();
        ArrayList<PolicyExpression> policyExpressions2 = new ArrayList<PolicyExpression>();
        for (PolicyExpression policyExpression : policySet1.getPolicies()) {
            if (!policyExpression.getName().equals(this.getPolicyType())) continue;
            policyExpressions1.add(policyExpression);
        }
        for (PolicyExpression policyExpression : policySet2.getPolicies()) {
            if (!policyExpression.getName().equals(this.getPolicyType())) continue;
            policyExpressions2.add(policyExpression);
        }
        for (PolicyExpression policyExpression1 : policyExpressions1) {
            for (PolicyExpression policyExpression2 : policyExpressions2) {
                if (this.build((WSPolicy)policyExpression1.getPolicy(), (WSPolicy)policyExpression2.getPolicy())) continue;
                return false;
            }
        }
        return true;
    }

    private List<WSPolicy> getPolicies(PolicySubject subject) {
        ArrayList<WSPolicy> polices = new ArrayList<WSPolicy>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                if (!this.getPolicyType().equals(exp.getName())) continue;
                polices.add((WSPolicy)exp.getPolicy());
            }
        }
        return polices;
    }

    private boolean build(WSPolicy wsPolicy1, WSPolicy wsPolicy2) {
        for (Object policyAssertion1 : wsPolicy1.getPolicyAssertions()) {
            boolean matched = false;
            for (Object policyAssertion2 : wsPolicy2.getPolicyAssertions()) {
                if (policyAssertion1.getClass() != policyAssertion2.getClass()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

