/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Policy;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.SecurityContextToken;

public class SecureConversationToken
extends SecurityContextToken {
    private Policy bootstrapPolicy;
    private OMElement issuerEpr;

    public SecureConversationToken(int version) {
        super(version);
    }

    public Policy getBootstrapPolicy() {
        return this.bootstrapPolicy;
    }

    public void setBootstrapPolicy(Policy bootstrapPolicy) {
        this.bootstrapPolicy = bootstrapPolicy;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.SECURE_CONVERSATION_TOKEN;
        }
        return SP11Constants.SECURE_CONVERSATION_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String inclusion;
        String prefix;
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion())) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, "Issuer", namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys() || this.isRequireExternalUriRef() || this.isSc10SecurityContextToken() || this.bootstrapPolicy != null) {
            String wspPrefix;
            String wspNamespaceURI = SPConstants.POLICY.getNamespaceURI();
            String wspWriterPrefix = writer.getPrefix(wspNamespaceURI);
            if (wspWriterPrefix == null) {
                wspPrefix = SPConstants.POLICY.getPrefix();
                writer.setPrefix(wspPrefix, wspNamespaceURI);
            } else {
                wspPrefix = wspWriterPrefix;
            }
            writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), wspNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, wspNamespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeEmptyElement(prefix, "RequireDerivedKeys", namespaceURI);
            }
            if (this.isRequireExternalUriRef()) {
                writer.writeEmptyElement(prefix, "RequireExternalUriReference", namespaceURI);
            }
            if (this.isSc10SecurityContextToken()) {
                writer.writeEmptyElement(prefix, "SC10SecurityContextToken", namespaceURI);
            }
            if (this.bootstrapPolicy != null) {
                writer.writeStartElement(prefix, "BootstrapPolicy", namespaceURI);
                this.bootstrapPolicy.serialize(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }
}

