/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.SymmetricBinding;

public class SymmetricBindingBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SymmetricBinding symmetricBinding = new SymmetricBinding(2);
        Policy policy = PolicyEngine.getPolicy(element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternatives((List)iterator.next(), symmetricBinding);
        }
        return symmetricBinding;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.SYMMETRIC_BINDING};
    }

    private void processAlternatives(List assertions, SymmetricBinding symmetricBinding) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP12Constants.ALGORITHM_SUITE.equals(name)) {
                symmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                continue;
            }
            if (SP12Constants.LAYOUT.equals(name)) {
                symmetricBinding.setLayout((Layout)assertion);
                continue;
            }
            if (SP12Constants.INCLUDE_TIMESTAMP.equals(name)) {
                symmetricBinding.setIncludeTimestamp(true);
                continue;
            }
            if (SP12Constants.PROTECTION_TOKEN.equals(name)) {
                symmetricBinding.setProtectionToken((ProtectionToken)assertion);
                continue;
            }
            if (SP12Constants.ENCRYPT_BEFORE_SIGNING.equals(name)) {
                symmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                continue;
            }
            if (SP12Constants.SIGN_BEFORE_ENCRYPTING.equals(name)) {
                symmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                continue;
            }
            if (SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY.equals(name)) {
                symmetricBinding.setEntireHeadersAndBodySignatures(true);
                continue;
            }
            if (!SP12Constants.ENCRYPT_SIGNATURE.equals(name)) continue;
            symmetricBinding.setSignatureProtection(true);
        }
    }
}

