/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.HttpsToken;
import org.apache.ws.secpolicy.model.TransportToken;

public class TransportTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        TransportToken transportToken = new TransportToken(2);
        Policy policy = PolicyEngine.getPolicy(element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), transportToken);
        }
        return transportToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.TRANSPORT_TOKEN};
    }

    private void processAlternative(List assertions, TransportToken parent) {
        for (XmlPrimtiveAssertion primtive : assertions) {
            OMElement child;
            QName qname = primtive.getName();
            if (!SP12Constants.HTTPS_TOKEN.equals(qname)) continue;
            HttpsToken httpsToken = new HttpsToken(2);
            OMElement element = primtive.getValue().getFirstChildWithName(SPConstants.POLICY);
            if (element != null && (child = element.getFirstElement()) != null) {
                if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(child.getQName())) {
                    httpsToken.setHttpBasicAuthentication(true);
                } else if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(child.getQName())) {
                    httpsToken.setHttpDigestAuthentication(true);
                } else if (SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(child.getQName())) {
                    httpsToken.setRequireClientCertificate(true);
                }
            }
            parent.setToken(httpsToken);
        }
    }
}

