/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.Wss10;

public class WSS10Builder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Wss10 wss10 = new Wss10(2);
        Policy policy = PolicyEngine.getPolicy(element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), wss10);
        }
        return wss10;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.WSS10};
    }

    private void processAlternative(List assertions, Wss10 parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP12Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.equals(name)) {
                parent.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if (SP12Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.equals(name)) {
                parent.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if (SP12Constants.MUST_SUPPORT_REF_EXTERNAL_URI.equals(name)) {
                parent.setMustSupportRefExternalURI(true);
                continue;
            }
            if (!SP12Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN.equals(name)) continue;
            parent.setMustSupportRefEmbeddedToken(true);
        }
    }
}

