/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.util.Loader;

public abstract class AbstractCrypto
extends CryptoBase {
    private static final Log log = LogFactory.getLog((class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto).getName());
    private static final boolean doDebug = log.isDebugEnabled();
    protected static CertificateFactory certFact;
    protected Properties properties = null;
    static /* synthetic */ Class class$org$apache$ws$security$components$crypto$AbstractCrypto;

    public AbstractCrypto(Properties properties) throws CredentialException, IOException {
        this(properties, Loader.getClassLoader(class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractCrypto(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        URL url;
        this.properties = properties;
        if (this.properties == null) {
            return;
        }
        String location = this.properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        if (location != null) {
            location = location.trim();
        }
        InputStream is = null;
        if (location != null && (is = (url = Loader.getResource(loader, location)) != null ? url.openStream() : new FileInputStream(location)) == null) {
            try {
                is = new FileInputStream(location);
            }
            catch (Exception e) {
                if (!doDebug) throw new CredentialException(3, "proxyNotFound", new Object[]{location}, e);
                log.debug(e.getMessage(), e);
                throw new CredentialException(3, "proxyNotFound", new Object[]{location}, e);
            }
        }
        try {
            String type;
            String passwd;
            String provider = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
            if (provider != null) {
                provider = provider.trim();
            }
            if ((passwd = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security")) != null) {
                passwd = passwd.trim();
            }
            if ((type = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType())) != null) {
                type = type.trim();
            }
            this.keystore = this.load(is, passwd, provider, type);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String loadCacerts = properties.getProperty("org.apache.ws.security.crypto.merlin.load.cacerts", "true");
        if (loadCacerts != null) {
            loadCacerts = loadCacerts.trim();
        }
        if (Boolean.valueOf(loadCacerts).booleanValue()) {
            String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            FileInputStream cacertsIs = new FileInputStream(cacertsPath);
            try {
                String cacertsPasswd = properties.getProperty("org.apache.ws.security.crypto.merlin.cacerts.password", "changeit");
                if (cacertsPasswd != null) {
                    cacertsPasswd = cacertsPasswd.trim();
                }
                this.cacerts = this.load(cacertsIs, cacertsPasswd, null, KeyStore.getDefaultType());
                if (!doDebug) return;
                log.debug("CA certs have been loaded");
                return;
            }
            finally {
                ((InputStream)cacertsIs).close();
            }
        } else {
            if (!doDebug) return;
            log.debug("CA certs have not been loaded");
        }
    }

    public KeyStore load(InputStream input, String storepass, String provider, String type) throws CredentialException {
        KeyStore ks = null;
        try {
            ks = provider == null || provider.length() == 0 ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            ks.load(input, storepass == null || storepass.length() == 0 ? new char[]{} : storepass.toCharArray());
        }
        catch (IOException e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(4, "secError00", e);
        }
        catch (Exception e) {
            if (doDebug) {
                log.debug(e.getMessage(), e);
            }
            throw new CredentialException(-1, "error00", e);
        }
        return ks;
    }

    protected String getCryptoProvider() {
        if (this.properties == null) {
            return null;
        }
        String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
        if (provider != null) {
            provider = provider.trim();
        }
        return provider;
    }

    public String getDefaultX509Alias() {
        if (this.properties == null) {
            return null;
        }
        String alias = this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias");
        if (alias != null) {
            alias = alias.trim();
        }
        return alias;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

