/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSEncryptBody
extends WSBaseMessage {
    private static Log log = LogFactory.getLog((class$org$apache$ws$security$message$WSEncryptBody == null ? (class$org$apache$ws$security$message$WSEncryptBody = WSEncryptBody.class$("org.apache.ws.security.message.WSEncryptBody")) : class$org$apache$ws$security$message$WSEncryptBody).getName());
    private static Log tlog = LogFactory.getLog("org.apache.ws.security.TIME");
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected String encCanonAlgo = null;
    protected byte[] embeddedKey = null;
    protected String embeddedKeyName = null;
    protected X509Certificate useThisCert = null;
    protected SecretKey symmetricKey = null;
    protected SecretKey encryptionKey = null;
    protected Element parentNode = null;
    protected SecurityTokenReference securityTokenReference = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSEncryptBody;

    public WSEncryptBody() {
    }

    public WSEncryptBody(String actor) {
        super(actor);
    }

    public WSEncryptBody(String actor, boolean mu) {
        super(actor, mu);
    }

    public void setKey(byte[] key) {
        this.embeddedKey = key;
    }

    public void setKeyEnc(String keyEnc) {
        this.keyEncAlgo = keyEnc;
    }

    public void setUserInfo(String user) {
        this.user = user;
    }

    public void setEmbeddedKeyName(String embeddedKeyName) {
        this.embeddedKeyName = embeddedKeyName;
    }

    public void setUseThisCert(X509Certificate cert) {
        this.useThisCert = cert;
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    public void setEncCanonicalization(String algo) {
        this.encCanonAlgo = algo;
    }

    public String getSymmetricEncAlgorithm() {
        return this.symEncAlgo;
    }

    public Document build(Document doc, Crypto crypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.keyIdentifierType == 5 || this.keyIdentifierType == 6) {
            return this.buildEmbedded(doc);
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug("Beginning Encryption...");
        }
        this.encryptionKey = this.symmetricKey;
        if (this.encryptionKey == null) {
            KeyGenerator keyGen = this.getKeyGenerator();
            this.encryptionKey = keyGen.generateKey();
        }
        Vector encDataRefs = this.doEncryption(doc, this.encryptionKey);
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        X509Certificate remoteCert = null;
        if (this.useThisCert != null) {
            remoteCert = this.useThisCert;
        } else {
            X509Certificate[] certs = crypto.getCertificates(this.user);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "noUserCertsFound", new Object[]{this.user, "encryption"});
            }
            remoteCert = certs[0];
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(this.keyEncAlgo);
        try {
            cipher.init(1, remoteCert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(9, null, null, e);
        }
        byte[] encKey = this.encryptionKey.getEncoded();
        if (this.doDebug) {
            log.debug("cipher blksize: " + cipher.getBlockSize() + ", symm key length: " + encKey.length);
        }
        if (cipher.getBlockSize() < encKey.length) {
            throw new WSSecurityException(0, "unsupportedKeyTransp", new Object[]{"public key algorithm too weak to encrypt symmetric key"});
        }
        byte[] encryptedKey = null;
        try {
            encryptedKey = cipher.doFinal(encKey);
        }
        catch (IllegalStateException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        catch (IllegalBlockSizeException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        catch (BadPaddingException e1) {
            throw new WSSecurityException(9, null, null, e1);
        }
        Text keyText = WSSecurityUtil.createBase64EncodedTextNode(doc, encryptedKey);
        Element wsseSecurity = this.insertSecurityHeader(doc);
        Element xencEncryptedKey = WSEncryptBody.createEncryptedKey(doc, this.keyEncAlgo);
        if (this.parentNode == null) {
            WSSecurityUtil.prependChildElement(wsseSecurity, xencEncryptedKey);
        } else {
            WSSecurityUtil.prependChildElement(this.parentNode, xencEncryptedKey);
        }
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        switch (this.keyIdentifierType) {
            case 3: {
                secToken.setKeyIdentifier(remoteCert);
                break;
            }
            case 4: {
                secToken.setKeyIdentifierSKI(remoteCert, crypto);
                break;
            }
            case 8: {
                secToken.setKeyIdentifierThumb(remoteCert);
                break;
            }
            case 2: {
                XMLX509IssuerSerial data = new XMLX509IssuerSerial(doc, remoteCert);
                X509Data x509Data = new X509Data(doc);
                x509Data.add(data);
                secToken.setX509IssuerSerial(x509Data);
                break;
            }
            case 1: {
                Reference ref = new Reference(doc);
                String certUri = this.wssConfig.getIdAllocator().createId("EncCertId-", remoteCert);
                ref.setURI("#" + certUri);
                X509Security bstToken = null;
                bstToken = new X509Security(doc);
                bstToken.setX509Certificate(remoteCert);
                bstToken.setID(certUri);
                ref.setValueType(bstToken.getValueType());
                secToken.setReference(ref);
                WSSecurityUtil.prependChildElement(wsseSecurity, bstToken.getElement());
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.addUnknownElement(secToken.getElement());
        xencEncryptedKey.appendChild(keyInfo.getElement());
        Element xencCipherValue = WSEncryptBody.createCipherValue(doc, xencEncryptedKey);
        xencCipherValue.appendChild(keyText);
        WSEncryptBody.createDataRefList(doc, xencEncryptedKey, encDataRefs);
        log.debug("Encryption complete.");
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
            tlog.debug("EncryptBody: symm-enc " + (t1 - t0) + " cert " + (t2 - t1) + " key-encrypt " + (t3 - t2));
        }
        return doc;
    }

    private Vector doEncryption(Document doc, SecretKey encryptKey) throws WSSecurityException {
        return this.doEncryption(doc, encryptKey, null);
    }

    private Vector doEncryption(Document doc, SecretKey encryptKey, KeyInfo keyInfo) throws WSSecurityException {
        Element envelope = doc.getDocumentElement();
        envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(this.symEncAlgo);
        }
        catch (XMLEncryptionException e3) {
            throw new WSSecurityException(2, null, null, e3);
        }
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Vector<String> encDataRefs = new Vector<String>();
        for (int part = 0; part < this.parts.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)this.parts.get(part);
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            String modifier = encPart.getEncModifier();
            Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
            if (body == null) {
                throw new WSSecurityException(0, "noEncElement", new Object[]{"{" + nmSpace + "}" + elemName});
            }
            boolean content = modifier.equals("Content");
            String xencEncryptedDataId = this.wssConfig.getIdAllocator().createId("EncDataId-", body);
            try {
                xmlCipher.init(1, encryptKey);
                EncryptedData encData = xmlCipher.getEncryptedData();
                encData.setId(xencEncryptedDataId);
                encData.setKeyInfo(keyInfo);
                xmlCipher.doFinal(doc, body, content);
            }
            catch (Exception e2) {
                throw new WSSecurityException(9, null, null, e2);
            }
            encDataRefs.add(new String("#" + xencEncryptedDataId));
        }
        return encDataRefs;
    }

    private Document buildEmbedded(Document doc) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug("Beginning Encryption embedded...");
        }
        this.encryptionKey = this.symmetricKey;
        if (this.encryptionKey == null) {
            if (this.embeddedKey == null) {
                throw new WSSecurityException(0, "noKeySupplied");
            }
            this.encryptionKey = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, this.embeddedKey);
        }
        KeyInfo keyInfo = null;
        if (this.keyIdentifierType == 5) {
            keyInfo = new KeyInfo(doc);
            keyInfo.addKeyName(this.embeddedKeyName == null ? this.user : this.embeddedKeyName);
        } else if (this.keyIdentifierType == 6) {
            if (this.securityTokenReference == null) {
                throw new WSSecurityException(7, "You must set keyInfo element, if the keyIdentifier == EMBED_SECURITY_TOKEN_REF");
            }
            keyInfo = new KeyInfo(doc);
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        }
        Vector encDataRefs = this.doEncryption(doc, this.encryptionKey, keyInfo);
        Element wsseSecurity = this.insertSecurityHeader(doc);
        Element tmpE = doc.createElement("temp");
        Element refList = WSEncryptBody.createDataRefList(doc, tmpE, encDataRefs);
        WSSecurityUtil.prependChildElement(wsseSecurity, refList);
        if (tlog.isDebugEnabled()) {
            tlog.debug("EncryptBody embedded: symm-enc " + (t1 - t0));
        }
        return doc;
    }

    private KeyGenerator getKeyGenerator() throws WSSecurityException {
        KeyGenerator keyGen;
        block6: {
            keyGen = null;
            try {
                keyGen = KeyGenerator.getInstance("AES");
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGen = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGen.init(128);
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGen.init(192);
                    break block6;
                }
                if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGen.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(2, null, null, e);
            }
        }
        return keyGen;
    }

    public static Element createEncryptedKey(Document doc, String keyTransportAlgo) {
        Element encryptedKey = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        WSSecurityUtil.setNamespace(encryptedKey, "http://www.w3.org/2001/04/xmlenc#", "xenc");
        Element encryptionMethod = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", keyTransportAlgo);
        encryptedKey.appendChild(encryptionMethod);
        return encryptedKey;
    }

    public static Element createEnrcyptedKey(Document doc, String keyTransportAlgo) {
        return WSEncryptBody.createEncryptedKey(doc, keyTransportAlgo);
    }

    public static Element createCipherValue(Document doc, Element encryptedKey) {
        Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValue = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherData.appendChild(cipherValue);
        encryptedKey.appendChild(cipherData);
        return cipherValue;
    }

    public static Element createDataRefList(Document doc, Element encryptedKey, Vector encDataRefs) {
        Element referenceList = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        for (int i = 0; i < encDataRefs.size(); ++i) {
            String dataReferenceUri = (String)encDataRefs.get(i);
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        encryptedKey.appendChild(referenceList);
        return referenceList;
    }

    public void setParentNode(Element element) {
        this.parentNode = element;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SecretKey key) {
        this.symmetricKey = key;
    }

    public SecretKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

