/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DerivedKeyToken {
    private Log log = LogFactory.getLog((class$org$apache$ws$security$message$token$DerivedKeyToken == null ? (class$org$apache$ws$security$message$token$DerivedKeyToken = DerivedKeyToken.class$("org.apache.ws.security.message.token.DerivedKeyToken")) : class$org$apache$ws$security$message$token$DerivedKeyToken).getName());
    protected Element element = null;
    protected Element elementSecurityTokenReference = null;
    protected Element elementProperties = null;
    protected Element elementGeneration = null;
    protected Element elementOffset = null;
    protected Element elementLength = null;
    protected Element elementLabel = null;
    protected Element elementNonce = null;
    private String ns;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$DerivedKeyToken;

    public DerivedKeyToken(Document doc) throws ConversationException {
        this(1, doc);
    }

    public DerivedKeyToken(int version, Document doc) throws ConversationException {
        this.log.debug("DerivedKeyToken: created");
        this.ns = ConversationConstants.getWSCNs(version);
        this.element = doc.createElementNS(this.ns, "wsc:DerivedKeyToken");
        WSSecurityUtil.setNamespace(this.element, this.ns, "wsc");
    }

    public DerivedKeyToken(Element elem) throws WSSecurityException {
        this.log.debug("DerivedKeyToken: created : element constructor");
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(ConversationConstants.DERIVED_KEY_TOKEN_QNAME_05_02) && !el.equals(ConversationConstants.DERIVED_KEY_TOKEN_QNAME_05_12)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementSecurityTokenReference = (Element)WSSecurityUtil.getDirectChild(this.element, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.ns = el.getNamespaceURI();
        this.elementProperties = (Element)WSSecurityUtil.getDirectChild(this.element, "Properties", this.ns);
        this.elementGeneration = (Element)WSSecurityUtil.getDirectChild(this.element, "Generation", this.ns);
        this.elementOffset = (Element)WSSecurityUtil.getDirectChild(this.element, "Offset", this.ns);
        this.elementLength = (Element)WSSecurityUtil.getDirectChild(this.element, "Length", this.ns);
        this.elementLabel = (Element)WSSecurityUtil.getDirectChild(this.element, "Label", this.ns);
        this.elementNonce = (Element)WSSecurityUtil.getDirectChild(this.element, "Nonce", this.ns);
    }

    public void setSecurityTokenReference(SecurityTokenReference ref) {
        this.elementSecurityTokenReference = ref.getElement();
        WSSecurityUtil.prependChildElement(this.element, ref.getElement());
    }

    public void setSecuityTokenReference(SecurityTokenReference ref) {
        this.setSecurityTokenReference(ref);
    }

    public void setSecurityTokenReference(Element elem) {
        this.elementSecurityTokenReference = elem;
        WSSecurityUtil.prependChildElement(this.element, elem);
    }

    public void setSecuityTokenReference(Element elem) {
        this.setSecurityTokenReference(elem);
    }

    public SecurityTokenReference getSecurityTokenReference() throws WSSecurityException {
        if (this.elementSecurityTokenReference != null) {
            return new SecurityTokenReference(this.elementSecurityTokenReference);
        }
        return null;
    }

    public SecurityTokenReference getSecuityTokenReference() throws WSSecurityException {
        return this.getSecurityTokenReference();
    }

    private void addProperty(String propName, String propValue) {
        if (this.elementProperties == null) {
            this.elementProperties = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Properties");
            this.element.appendChild(this.elementProperties);
        }
        Element tempElement = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:" + propName);
        tempElement.appendChild(this.element.getOwnerDocument().createTextNode(propValue));
        this.elementProperties.appendChild(tempElement);
    }

    public void setProperties(String name, String label, String nonce) {
        Hashtable<String, String> table = new Hashtable<String, String>(3);
        table.put("Name", name);
        table.put("Label", label);
        table.put("Nonce", nonce);
        this.setProperties(table);
    }

    public void setProperties(Hashtable properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            Node node = WSSecurityUtil.findElement(this.elementProperties, propertyName, this.ns);
            if (node instanceof Element) {
                Text node1 = this.getFirstNode((Element)node);
                node1.setData((String)properties.get(propertyName));
                continue;
            }
            this.addProperty(propertyName, (String)properties.get(propertyName));
        }
    }

    public Hashtable getProperties() {
        if (this.elementProperties != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            NodeList nodes = this.elementProperties.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node tempNode = nodes.item(i);
                if (!(tempNode instanceof Element)) continue;
                Text text = this.getFirstNode((Element)tempNode);
                table.put(tempNode.getNodeName(), text.getData());
            }
        }
        return null;
    }

    public void setLength(int length) {
        this.elementLength = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Length");
        this.elementLength.appendChild(this.element.getOwnerDocument().createTextNode(Long.toString(length)));
        this.element.appendChild(this.elementLength);
    }

    public int getLength() {
        if (this.elementLength != null) {
            return Integer.parseInt(this.getFirstNode(this.elementLength).getData());
        }
        return -1;
    }

    public void setOffset(int offset) throws ConversationException {
        if (this.elementGeneration != null) {
            throw new ConversationException("Offset cannot be set along with generation - generation is already set");
        }
        this.elementOffset = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Offset");
        this.elementOffset.appendChild(this.element.getOwnerDocument().createTextNode(Integer.toString(offset)));
        this.element.appendChild(this.elementOffset);
    }

    public int getOffset() {
        if (this.elementOffset != null) {
            return Integer.parseInt(this.getFirstNode(this.elementOffset).getData());
        }
        return -1;
    }

    public void setGeneration(int generation) throws ConversationException {
        if (this.elementOffset != null) {
            throw new ConversationException("Generation cannot be set along with offset - Offset is already set");
        }
        this.elementGeneration = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Generation");
        this.elementGeneration.appendChild(this.element.getOwnerDocument().createTextNode(Integer.toString(generation)));
        this.element.appendChild(this.elementGeneration);
    }

    public int getGeneration() {
        if (this.elementGeneration != null) {
            return Integer.parseInt(this.getFirstNode(this.elementGeneration).getData());
        }
        return -1;
    }

    public void setLabel(String label) {
        this.elementLabel = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Label");
        this.elementLabel.appendChild(this.element.getOwnerDocument().createTextNode(label));
        this.element.appendChild(this.elementLabel);
    }

    public void setNonce(String nonce) {
        this.elementNonce = this.element.getOwnerDocument().createElementNS(this.ns, "wsc:Nonce");
        this.elementNonce.appendChild(this.element.getOwnerDocument().createTextNode(nonce));
        this.element.appendChild(this.elementNonce);
    }

    public String getLabel() {
        if (this.elementLabel != null) {
            return this.getFirstNode(this.elementLabel).getData();
        }
        return null;
    }

    public String getNonce() {
        if (this.elementNonce != null) {
            return this.getFirstNode(this.elementNonce).getData();
        }
        return null;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String getAlgorithm() {
        String algo = this.element.getAttributeNS(this.ns, "Algorithm");
        if (algo == null || algo.equals("")) {
            return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
        }
        return algo;
    }

    public void setAlgorithm(String algo) {
        this.element.setAttributeNS(this.ns, "Algorithm", algo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

