/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UsernameToken {
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    public static final String PASSWORD_TYPE = "passwordType";
    public static final int DEFAULT_ITERATION = 1000;
    public static final QName TOKEN;
    private static final Log LOG;
    private static final boolean DO_DEBUG;
    private static SecureRandom random;
    protected Element element = null;
    protected Element elementUsername = null;
    protected Element elementPassword = null;
    protected Element elementNonce = null;
    protected Element elementCreated = null;
    protected Element elementSalt = null;
    protected Element elementIteration = null;
    protected String passwordType = null;
    protected boolean hashed = true;
    private String rawPassword;
    private boolean passwordsAreEncoded = false;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$UsernameToken;

    public UsernameToken(Element elem) throws WSSecurityException {
        this(elem, false);
    }

    public UsernameToken(Element elem, boolean allowNamespaceQualifiedPasswordTypes) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementUsername = (Element)WSSecurityUtil.getDirectChild(this.element, "Username", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementPassword = (Element)WSSecurityUtil.getDirectChild(this.element, "Password", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementNonce = (Element)WSSecurityUtil.getDirectChild(this.element, "Nonce", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementCreated = (Element)WSSecurityUtil.getDirectChild(this.element, "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.elementSalt = (Element)WSSecurityUtil.getDirectChild(this.element, "Salt", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        this.elementIteration = (Element)WSSecurityUtil.getDirectChild(this.element, "Iteration", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        if (this.elementUsername == null) {
            throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
        }
        this.hashed = false;
        if (this.elementSalt != null) {
            if (this.elementPassword != null || this.elementIteration == null) {
                throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
            }
            return;
        }
        if (this.elementPassword != null) {
            if (this.elementPassword.hasAttribute("Type")) {
                this.passwordType = this.elementPassword.getAttribute("Type");
            } else if (this.elementPassword.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type")) {
                if (allowNamespaceQualifiedPasswordTypes) {
                    this.passwordType = this.elementPassword.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type");
                } else {
                    throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
                }
            }
        }
        if (this.passwordType != null && this.passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
            this.hashed = true;
            if (this.elementNonce == null || this.elementCreated == null) {
                throw new WSSecurityException(4, "badTokenType01", new Object[]{el});
            }
        }
    }

    public UsernameToken(boolean milliseconds, Document doc) {
        this(milliseconds, doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    public UsernameToken(boolean milliseconds, Document doc, String pwType) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        this.elementUsername = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
        this.elementUsername.appendChild(doc.createTextNode(""));
        this.element.appendChild(this.elementUsername);
        if (pwType != null) {
            this.elementPassword = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
            this.elementPassword.appendChild(doc.createTextNode(""));
            this.element.appendChild(this.elementPassword);
            this.hashed = false;
            this.passwordType = pwType;
            if (this.passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                this.hashed = true;
                this.addNonce(doc);
                this.addCreated(milliseconds, doc);
            }
        }
    }

    public void addNonce(Document doc) {
        if (this.elementNonce != null) {
            return;
        }
        byte[] nonceValue = new byte[16];
        random.nextBytes(nonceValue);
        this.elementNonce = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Nonce");
        this.elementNonce.appendChild(doc.createTextNode(Base64.encode(nonceValue)));
        this.elementNonce.setAttributeNS(null, "EncodingType", BASE64_ENCODING);
        this.element.appendChild(this.elementNonce);
    }

    public void addCreated(boolean milliseconds, Document doc) {
        if (this.elementCreated != null) {
            return;
        }
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Calendar rightNow = Calendar.getInstance();
        this.elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(rightNow.getTime())));
        this.element.appendChild(this.elementCreated);
    }

    public byte[] addSalt(Document doc, byte[] saltValue, boolean mac) {
        if (saltValue == null) {
            saltValue = UsernameToken.generateSalt(mac);
        }
        this.elementSalt = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Salt");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementSalt.appendChild(doc.createTextNode(Base64.encode(saltValue)));
        this.element.appendChild(this.elementSalt);
        return saltValue;
    }

    public void addIteration(Document doc, int iteration) {
        String text = "" + iteration;
        this.elementIteration = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Iteration");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementIteration.appendChild(doc.createTextNode(text));
        this.element.appendChild(this.elementIteration);
    }

    public String getName() {
        return this.nodeString(this.elementUsername);
    }

    public void setName(String name) {
        Text node = this.getFirstNode(this.elementUsername);
        node.setData(name);
    }

    public String getNonce() {
        return this.nodeString(this.elementNonce);
    }

    public String getCreated() {
        return this.nodeString(this.elementCreated);
    }

    public String getPassword() {
        String password = this.nodeString(this.elementPassword);
        if (password == null && this.elementPassword != null) {
            return "";
        }
        return password;
    }

    public byte[] getSalt() throws WSSecurityException {
        String salt = this.nodeString(this.elementSalt);
        if (salt != null) {
            return Base64.decode(this.nodeString(this.elementSalt));
        }
        return null;
    }

    public int getIteration() {
        String iter = this.nodeString(this.elementIteration);
        if (iter != null) {
            return Integer.parseInt(iter);
        }
        return 1000;
    }

    public boolean isHashed() {
        return this.hashed;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPassword(String pwd) {
        block8: {
            if (pwd == null) {
                if (this.passwordType != null) {
                    throw new IllegalArgumentException("pwd == null but a password is needed");
                }
                return;
            }
            this.rawPassword = pwd;
            Text node = this.getFirstNode(this.elementPassword);
            try {
                if (!this.hashed) {
                    node.setData(pwd);
                    this.elementPassword.setAttributeNS(null, "Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                } else {
                    if (this.passwordsAreEncoded) {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), Base64.decode(pwd)));
                    } else {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), pwd));
                    }
                    this.elementPassword.setAttributeNS(null, "Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                }
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block8;
                LOG.debug(e.getMessage(), e);
            }
        }
    }

    public void setRawPassword(String newRawPassword) {
        this.rawPassword = newRawPassword;
    }

    public String getRawPassword() {
        return this.rawPassword;
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public static String doPasswordDigest(String nonce, String created, byte[] password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                byte[] b1 = nonce != null ? Base64.decode(nonce) : new byte[]{};
                byte[] b2 = created != null ? created.getBytes("UTF-8") : new byte[]{};
                byte[] b3 = password;
                byte[] b4 = new byte[b1.length + b2.length + b3.length];
                int offset = 0;
                System.arraycopy(b1, 0, b4, offset, b1.length);
                System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
                System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                sha.reset();
                sha.update(b4);
                passwdDigest = Base64.encode(sha.digest());
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug(e.getMessage(), e);
            }
        }
        return passwdDigest;
    }

    public static String doPasswordDigest(String nonce, String created, String password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                passwdDigest = UsernameToken.doPasswordDigest(nonce, created, password.getBytes("UTF-8"));
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug(e.getMessage(), e);
            }
        }
        return passwdDigest;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    private String nodeString(Element e) {
        Text node;
        if (e != null && (node = this.getFirstNode(e)) != null) {
            return node.getData();
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public byte[] getSecretKey() {
        return this.getSecretKey(16, "WS-Security");
    }

    public byte[] getSecretKey(int keylen) {
        return this.getSecretKey(keylen, "WS-Security");
    }

    public byte[] getSecretKey(int keylen, String labelString) {
        byte[] key = null;
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] password = this.passwordsAreEncoded ? Base64.decode(this.rawPassword) : this.rawPassword.getBytes("UTF-8");
            byte[] label = labelString.getBytes("UTF-8");
            byte[] nonce = Base64.decode(this.getNonce());
            byte[] created = this.getCreated().getBytes("UTF-8");
            byte[] seed = new byte[label.length + nonce.length + created.length];
            int offset = 0;
            System.arraycopy(label, 0, seed, offset, label.length);
            System.arraycopy(nonce, 0, seed, offset += label.length, nonce.length);
            System.arraycopy(created, 0, seed, offset += nonce.length, created.length);
            key = UsernameToken.P_hash(password, seed, mac, keylen);
            if (LOG.isDebugEnabled()) {
                LOG.debug("password   :" + Base64.encode(password));
                LOG.debug("label      :" + Base64.encode(label));
                LOG.debug("nonce      :" + Base64.encode(nonce));
                LOG.debug("created    :" + Base64.encode(created));
                LOG.debug("seed       :" + Base64.encode(seed));
                LOG.debug("Key        :" + Base64.encode(key));
            }
        }
        catch (Exception e) {
            if (DO_DEBUG) {
                LOG.debug(e.getMessage(), e);
            }
            return null;
        }
        return key;
    }

    public static byte[] generateDerivedKey(byte[] password, byte[] salt, int iteration) throws WSSecurityException {
        if (iteration == 0) {
            iteration = 1000;
        }
        byte[] pwSalt = new byte[salt.length + password.length];
        System.arraycopy(password, 0, pwSalt, 0, password.length);
        System.arraycopy(salt, 0, pwSalt, password.length, salt.length);
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            if (DO_DEBUG) {
                LOG.debug(e.getMessage(), e);
            }
            throw new WSSecurityException(0, "noSHA1availabe", null, e);
        }
        sha.reset();
        byte[] K = sha.digest(pwSalt);
        for (int i = 1; i < iteration; ++i) {
            K = sha.digest(K);
        }
        return K;
    }

    public static byte[] generateDerivedKey(String password, byte[] salt, int iteration) throws WSSecurityException {
        try {
            return UsernameToken.generateDerivedKey(password.getBytes("UTF-8"), salt, iteration);
        }
        catch (UnsupportedEncodingException e) {
            if (DO_DEBUG) {
                LOG.debug(e.getMessage(), e);
            }
            throw new WSSecurityException("Unable to convert password to UTF-8", e);
        }
    }

    public byte[] getDerivedKey() throws WSSecurityException {
        int iteration = this.getIteration();
        byte[] salt = this.getSalt();
        if (this.passwordsAreEncoded) {
            return UsernameToken.generateDerivedKey(Base64.decode(this.rawPassword), salt, iteration);
        }
        return UsernameToken.generateDerivedKey(this.rawPassword, salt, iteration);
    }

    public boolean isDerivedKey() throws WSSecurityException {
        return this.elementSalt != null && this.elementIteration != null;
    }

    public static byte[] generateSalt(boolean useForMac) {
        byte[] saltValue = new byte[16];
        random.nextBytes(saltValue);
        saltValue[15] = useForMac ? 1 : 2;
        return saltValue;
    }

    private static byte[] P_hash(byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] A = seed;
        SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
        mac.init(key);
        while (required > 0) {
            mac.update(A);
            A = mac.doFinal();
            mac.update(A);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = UsernameToken.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
            LOG = LogFactory.getLog((class$org$apache$ws$security$message$token$UsernameToken == null ? (class$org$apache$ws$security$message$token$UsernameToken = UsernameToken.class$("org.apache.ws.security.message.token.UsernameToken")) : class$org$apache$ws$security$message$token$UsernameToken).getName());
            DO_DEBUG = LOG.isDebugEnabled();
            try {
                random = WSSecurityUtil.resolveSecureRandom();
            }
            catch (NoSuchAlgorithmException e) {
                if (!DO_DEBUG) break block2;
                LOG.debug(e.getMessage(), e);
            }
        }
    }
}

