/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(RSAKeyValueResolver.class.getName());
    Key _kek;
    String _algorithm;

    public EncryptedKeyResolver(String string) {
        this._kek = null;
        this._algorithm = string;
    }

    public EncryptedKeyResolver(String string, Key key) {
        this._algorithm = string;
        this._kek = key;
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug("EncryptedKeyResolver - Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return null;
        }
        SecretKey secretKey = null;
        boolean bl = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
        if (bl) {
            log.debug("Passed an Encrypted Key");
            try {
                XMLCipher xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(4, this._kek);
                EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(element);
                secretKey = (SecretKey)xMLCipher.decryptKey(encryptedKey, this._algorithm);
            }
            catch (XMLEncryptionException xMLEncryptionException) {
                // empty catch block
            }
        }
        return secretKey;
    }
}

