/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(X509IssuerSerialResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        X509Data x509Data = null;
        try {
            x509Data = new X509Data(element, string);
        }
        catch (XMLSignatureException xMLSignatureException) {
            log.debug("I can't");
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("I can't");
            return null;
        }
        if (x509Data == null) {
            log.debug("I can't");
            return null;
        }
        if (!x509Data.containsIssuerSerial()) {
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509IssuerSerial"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info("", keyResolverException);
                throw keyResolverException;
            }
            int n = x509Data.lengthIssuerSerial();
            Iterator iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509IssuerSerial xMLX509IssuerSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), x509Certificate);
                if (log.isDebugEnabled()) {
                    log.debug("Found Certificate Issuer: " + xMLX509IssuerSerial.getIssuerName());
                    log.debug("Found Certificate Serial: " + xMLX509IssuerSerial.getSerialNumber().toString());
                }
                for (int i = 0; i < n; ++i) {
                    XMLX509IssuerSerial xMLX509IssuerSerial2 = x509Data.itemIssuerSerial(i);
                    if (log.isDebugEnabled()) {
                        log.debug("Found Element Issuer:     " + xMLX509IssuerSerial2.getIssuerName());
                        log.debug("Found Element Serial:     " + xMLX509IssuerSerial2.getSerialNumber().toString());
                    }
                    if (xMLX509IssuerSerial.equals(xMLX509IssuerSerial2)) {
                        log.debug("match !!! ");
                        return x509Certificate;
                    }
                    log.debug("no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

