/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(X509SKIResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug("I can't");
            return null;
        }
        XMLX509SKI[] xMLX509SKIArray = null;
        Element[] elementArray = null;
        elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        if (elementArray == null || elementArray.length <= 0) {
            log.debug("I can't");
            return null;
        }
        try {
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SKI"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info("", keyResolverException);
                throw keyResolverException;
            }
            xMLX509SKIArray = new XMLX509SKI[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                xMLX509SKIArray[i] = new XMLX509SKI(elementArray[i], string);
            }
            Iterator iterator = storageResolver.getIterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                XMLX509SKI xMLX509SKI = new XMLX509SKI(element.getOwnerDocument(), x509Certificate);
                for (int i = 0; i < xMLX509SKIArray.length; ++i) {
                    if (!xMLX509SKI.equals(xMLX509SKIArray[i])) continue;
                    log.debug("Return PublicKey from " + x509Certificate.getSubjectDN().getName());
                    return x509Certificate;
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new KeyResolverException("empty", xMLSecurityException);
        }
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

